/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.dependencies;

import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.util.ATask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class DepUtil {
    public static Task getReplacementTask(DepSnapshot depSnapshot, IDirectDependent iDirectDependent, IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        Task task = iDirectDependent.taskReplaceDep(iPyroObject, iPyroObject2);
        if (iDirectDependent instanceof IPyroObject) {
            return task;
        }
        Set<IPyroObject> set = depSnapshot.getAncestors(IPyroObject.class, iDirectDependent);
        return new ReplacementTask(task, set);
    }

    private static class ReplacementTask
    extends ATask {
        private final Task d_baseTask;
        private final IPyroObject[] d_domainParents;

        public ReplacementTask(Task task, Collection<? extends IPyroObject> collection) {
            this.d_baseTask = task;
            this.d_domainParents = collection.toArray(new IPyroObject[collection.size()]);
        }

        @Override
        public boolean canUndo() {
            return this.d_baseTask.canUndo();
        }

        @Override
        public void run() {
            this.pauseEvts();
            this.d_baseTask.run();
            this.fireEvts();
            this.resumeEvts();
        }

        @Override
        public void undo() {
            this.pauseEvts();
            this.d_baseTask.undo();
            this.fireEvts();
            this.resumeEvts();
        }

        private void pauseEvts() {
            PyroMod pyroMod = this.domain();
            if (pyroMod != null) {
                pyroMod.pauseUpdates();
            }
        }

        private void resumeEvts() {
            PyroMod pyroMod = this.domain();
            if (pyroMod != null) {
                pyroMod.resumeUpdates();
            }
        }

        private PyroMod domain() {
            return this.d_domainParents.length > 0 ? (PyroMod)this.d_domainParents[0].getDomain() : null;
        }

        private void fireEvts() {
            for (IPyroObject iPyroObject : this.d_domainParents) {
                iPyroObject.changedEvt(new Object[0]);
            }
        }
    }
}

