/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.dependencies;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.PyroSim;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.TypeFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.util.ITransformer;
import pyrosim.legacy_2012_1.util.TransformedSet;

public class DepSnapshot {
    private final Map<Object, Set<IParentEntry>> d_map = new LinkedIdentityHashMap<Object, Set<IParentEntry>>();
    private final Set<? extends IPyroObject> d_interestingDepOns;
    private static final Set<? extends Class> s_skipClazzes = Sets.fromArrayHS(String.class, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, PyroSim.class);

    public DepSnapshot() {
        this(Collections.EMPTY_LIST);
    }

    public DepSnapshot(Collection<? extends IPyroObject> collection) {
        this.d_interestingDepOns = collection instanceof Set ? (Set<Object>)collection : (collection.isEmpty() ? Collections.EMPTY_SET : new IdentityHashSet<IPyroObject>(collection));
    }

    public void start(PyroMod pyroMod, Serialized serialized) {
        theTimer theTimer2 = new theTimer();
        this.add(pyroMod, serialized, DLink.WEAK);
        System.out.println("DepSnapshot: " + theTimer2.curr());
    }

    private boolean add(Object object, Object object2, DLink dLink) {
        if (object2 == null) {
            return false;
        }
        assert (object != null);
        boolean bl = this.takeSnapshot(object2);
        if (bl) {
            Set<IParentEntry> set = this.d_map.get(object2);
            assert (set != null);
            if (object instanceof IDirectDependent) {
                DirectEntry directEntry = new DirectEntry(dLink, (IDirectDependent)object);
                if (dLink != DLink.WEAK) {
                    set.remove(directEntry);
                }
                set.add(directEntry);
            } else {
                set.add(new IndirectEntry(object));
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean takeSnapshot(Object object) {
        Class<?> clazz;
        boolean bl;
        if (object instanceof PyroMod) {
            return false;
        }
        if (this.d_map.containsKey(object)) {
            Set<IParentEntry> set = this.d_map.get(object);
            return set != null;
        }
        this.d_map.put(object, new LinkedHashSet());
        boolean bl2 = bl = this.d_interestingDepOns.isEmpty() && object instanceof IPyroObject || this.d_interestingDepOns.contains(object);
        if (object instanceof IDirectDependent) {
            clazz = new DepList((IDirectDependent)object);
            ((IDirectDependent)object).takeDepSnapshot((DepList)((Object)clazz));
            for (Pair<DLink, IPyroObject> pair : ((DepList)((Object)clazz)).getLinks()) {
                bl |= this.add(object, pair.v2, (DLink)((Object)pair.v1));
            }
        }
        if (object instanceof Composite) {
            for (Object e : ((Composite)object).getMembers()) {
                bl |= this.takeSnapshot(e);
            }
        } else if (!(object instanceof IDirectDependent) && object instanceof Collection) {
            for (Object e : (Collection)object) {
                bl |= this.checkTypeAndAdd(object, e);
            }
        } else if (!(object instanceof IDirectDependent) && object instanceof Map) {
            clazz = ((Map)object).entrySet();
            Iterator iterator = clazz.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                bl |= this.checkTypeAndAdd(object, entry.getKey());
                bl |= this.checkTypeAndAdd(object, entry.getValue());
            }
        } else if (object.getClass().isArray()) {
            clazz = object.getClass().getComponentType();
            if (!DepSnapshot.isSkippable(clazz)) {
                void var5_19;
                int n = Array.getLength(object);
                boolean bl3 = false;
                while (var5_19 < n) {
                    bl |= this.checkTypeAndAdd(object, Array.get(object, (int)var5_19));
                    ++var5_19;
                }
            }
        } else {
            try {
                for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    for (Field field : clazz.getDeclaredFields()) {
                        int n = field.getModifiers();
                        if (Modifier.isStatic(n) || field.isAnnotationPresent(SkipDep.class) || DepSnapshot.isSkippable(field.getType())) continue;
                        boolean bl4 = field.isAccessible();
                        if (!bl4) {
                            field.setAccessible(true);
                        }
                        Object object2 = field.get(object);
                        if (!bl4) {
                            field.setAccessible(false);
                        }
                        if (object2 == null) continue;
                        bl |= this.checkTypeAndAdd(object, object2);
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                assert (false);
            }
        }
        if (!bl) {
            this.d_map.put(object, null);
        }
        return bl;
    }

    private boolean checkTypeAndAdd(Object object, Object object2) {
        if (DepSnapshot.isSkippable(object2)) {
            return false;
        }
        return this.add(object, object2, DLink.WEAK);
    }

    private static boolean isSkippable(Object object) {
        return object == null || DepSnapshot.isSkippable(object.getClass());
    }

    private static boolean isSkippable(Class clazz) {
        return s_skipClazzes.contains(clazz) || IGeom.class.isAssignableFrom(clazz);
    }

    public <T> Set<T> findAllDependents(Class<T> clazz, Object object) {
        IdentityHashSet identityHashSet = new IdentityHashSet();
        TypeFilter<Object> typeFilter = new TypeFilter<Object>(new Class[]{clazz});
        this.findAllDependents(typeFilter, object, identityHashSet);
        return identityHashSet;
    }

    public Set<Object> findAllDependents(IObjectFilter<Object> iObjectFilter, Object object) {
        IdentityHashSet<Object> identityHashSet = new IdentityHashSet<Object>();
        this.findAllDependents(iObjectFilter, object, identityHashSet);
        return identityHashSet;
    }

    public void findAllDependents(IObjectFilter<Object> iObjectFilter, Object object, Set set) {
        IdentityHashSet identityHashSet = new IdentityHashSet();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.addLast(object);
        identityHashSet.add(object);
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.removeLast();
            Set<IParentEntry> set2 = this.d_map.get(e);
            if (set2 == null) continue;
            for (IParentEntry iParentEntry : set2) {
                Object object2 = iParentEntry.getSource();
                if (!iObjectFilter.shouldFilter(object2)) {
                    set.add(object2);
                    continue;
                }
                if (!identityHashSet.add(object2)) continue;
                arrayDeque.addLast(object2);
            }
        }
    }

    public Set<IPyroObject> getAllDependedOn() {
        IObjectFilter<IPyroObject> iObjectFilter = new IObjectFilter<IPyroObject>(){

            @Override
            public boolean shouldFilter(IPyroObject iPyroObject) {
                Set set = (Set)DepSnapshot.this.d_map.get(iPyroObject);
                return set == null || set.isEmpty();
            }
        };
        return new FilteredSet<IPyroObject>(this.d_map.keySet(), IPyroObject.class, iObjectFilter);
    }

    public Set<Dependency> getDependents(IPyroObject iPyroObject) {
        Set<IParentEntry> set = this.d_map.get(iPyroObject);
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        ITransformer<DirectEntry, Dependency> iTransformer = new ITransformer<DirectEntry, Dependency>(){

            @Override
            public Dependency transform(DirectEntry directEntry) {
                return new Dependency(directEntry.link, directEntry.source);
            }
        };
        ITransformer<Dependency, DirectEntry> iTransformer2 = new ITransformer<Dependency, DirectEntry>(){

            @Override
            public DirectEntry transform(Dependency dependency) {
                return new DirectEntry(dependency.link, dependency.source);
            }
        };
        FilteredSet<DirectEntry> filteredSet = new FilteredSet<DirectEntry>(set, DirectEntry.class);
        return new TransformedSet<DirectEntry, Dependency>(filteredSet, iTransformer, iTransformer2, Dependency.class);
    }

    public <T> Set<T> getAncestors(Class<T> clazz, Object object) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.push(object);
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.pop();
            Set<IParentEntry> set = this.d_map.get(e);
            if (set == null) continue;
            for (IParentEntry iParentEntry : set) {
                Object object2 = iParentEntry.getSource();
                if (clazz.isInstance(object2)) {
                    linkedIdentityHashSet.add(clazz.cast(object2));
                    continue;
                }
                arrayDeque.push(object2);
            }
        }
        return linkedIdentityHashSet;
    }

    public void removeMappings(Collection<?> collection) {
        this.d_map.keySet().removeAll(collection);
    }

    private static class DirectEntry
    implements IParentEntry {
        public final DLink link;
        public final IDirectDependent source;

        public DirectEntry(DLink dLink, IDirectDependent iDirectDependent) {
            this.source = iDirectDependent;
            this.link = dLink;
        }

        public int hashCode() {
            return -1826424077 + System.identityHashCode(this.source);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof DirectEntry && this.source == ((DirectEntry)object).source;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class IndirectEntry
    implements IParentEntry {
        public final Object obj;

        public IndirectEntry(Object object) {
            this.obj = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object object) {
            return object == this || object == this.obj || object instanceof IndirectEntry && ((IndirectEntry)object).obj == this.obj;
        }

        @Override
        public Object getSource() {
            return this.obj;
        }
    }

    private static interface IParentEntry {
        public Object getSource();
    }
}

