/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.signals.AOneDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class CustomCtrl
extends AControl {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin;
    private IOutPin d_outPin;
    private boolean d_initState;
    private SortedSet<UnitDouble> d_tripValues;

    public CustomCtrl() {
        this(false, new ArrayList<UnitDouble>());
    }

    public CustomCtrl(boolean bl, Collection<UnitDouble> collection) {
        this(bl, (SortedSet<UnitDouble>)new TreeSet<UnitDouble>(collection));
    }

    public CustomCtrl(boolean bl, SortedSet<UnitDouble> sortedSet) {
        this.d_initState = bl;
        this.d_tripValues = sortedSet;
        this.d_inPin = new AOneDoubleInPin(this){
            static final long serialVersionUID = 7930361730409851012L;

            @Override
            public void updateInputUnit(Unit unit) {
                TreeSet<UnitDouble> treeSet = new TreeSet<UnitDouble>();
                for (UnitDouble unitDouble : CustomCtrl.this.d_tripValues) {
                    treeSet.add(unitDouble.reinterpret(unit));
                }
                CustomCtrl.this.d_tripValues = treeSet;
                CustomCtrl.this.changedEvt(new Object[0]);
            }

            @Override
            protected void changeInputUnit(Unit unit) {
                TreeSet<UnitDouble> treeSet = new TreeSet<UnitDouble>();
                for (UnitDouble unitDouble : CustomCtrl.this.d_tripValues) {
                    treeSet.add(new UnitDouble(unitDouble.getValueNoUnit(), unit));
                }
                CustomCtrl.this.d_tripValues = treeSet;
                CustomCtrl.this.changedEvt(new Object[0]);
            }
        };
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("custom");
    }

    @Override
    public boolean isNoop() {
        return this.d_tripValues.isEmpty() || super.isNoop();
    }

    @Override
    public Object clone() {
        CustomCtrl customCtrl = (CustomCtrl)super.clone();
        customCtrl.d_inPin = (IInPin)this.d_inPin.clone(customCtrl);
        customCtrl.d_outPin = (IOutPin)this.d_outPin.clone(customCtrl);
        customCtrl.d_tripValues = new TreeSet<UnitDouble>(this.d_tripValues);
        return customCtrl;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CustomCtrl)) {
            return false;
        }
        CustomCtrl customCtrl = (CustomCtrl)object;
        return super.equals(object) && this.d_inPin.equals(customCtrl.d_inPin) && this.d_initState == customCtrl.d_initState && this.d_tripValues.equals(customCtrl.d_tripValues);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 53803487 + this.d_inPin.hashCode() + theUtil.hashCode(this.d_initState) + this.d_tripValues.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    public boolean getInitialState() {
        return this.d_initState;
    }

    public void setInitialState(boolean bl) {
        this.d_initState = bl;
        this.changedEvt(new Object[0]);
    }

    public SortedSet<UnitDouble> getTripValues() {
        return Collections.unmodifiableSortedSet(this.d_tripValues);
    }

    public void setTripValues(Collection<UnitDouble> collection) {
        this.d_tripValues = new TreeSet<UnitDouble>(collection);
        this.changedEvt(new Object[0]);
    }
}

