/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class TempRegulation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_netHeatFlux;
    public final UnitDouble d_temperature;
    public final UnitDouble d_heatFlux;
    public final TimeFunction d_rampup;
    public final double d_emissivity;

    private TempRegulation(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, double d) {
        this.d_netHeatFlux = unitDouble;
        this.d_temperature = unitDouble2;
        this.d_heatFlux = unitDouble3;
        this.d_rampup = timeFunction;
        this.d_emissivity = d;
    }

    public static TempRegulation newNetHeatFluxTR(UnitDouble unitDouble) {
        return new TempRegulation(unitDouble, null, null, null, 0.0);
    }

    public static TempRegulation newFixedHeatFluxTR(UnitDouble unitDouble, UnitDouble unitDouble2, TimeFunction timeFunction, double d) {
        return new TempRegulation(null, unitDouble, unitDouble2, timeFunction, d);
    }

    public static TempRegulation newDefault() {
        return new TempRegulation(null, null, SIUS.newud(0.0, 33), TimeFunction.newDefault(), 0.9);
    }

    public boolean isNetHeatFluxTR() {
        return this.d_netHeatFlux != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TempRegulation)) {
            return false;
        }
        TempRegulation tempRegulation = (TempRegulation)object;
        if (this.d_netHeatFlux != null) {
            return this.d_netHeatFlux.equals(tempRegulation.d_netHeatFlux);
        }
        return theUtil.equal(this.d_temperature, tempRegulation.d_temperature) && this.d_heatFlux.equals(tempRegulation.d_heatFlux) && this.d_rampup.equals(tempRegulation.d_rampup) && this.d_emissivity == tempRegulation.d_emissivity;
    }
}

