/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Surface
extends NamedPyroObject
implements IMaterial {
    static final long serialVersionUID = 1L;
    public static final Object EVT_TEXTURE = new Object();
    public static final Object EVT_COLOR = new Object();
    public static final Object EVT_FYI = new Object();
    private Color d_color;
    private TextureInfo d_texinfo;
    @SkipDep
    private transient Icon d_icon = null;
    private ISurfDesc d_surfDesc = null;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Surface() {
        this(Intl.intl("DEFAULT"));
    }

    public Surface(String string) {
        this(string, new Color(255, 204, 102), null);
    }

    public Surface(String string, Color color, TextureInfo textureInfo) {
        this(string, color, textureInfo, new SurfDescStatic.Inert());
    }

    public Surface(String string, Color color, TextureInfo textureInfo, ISurfDesc iSurfDesc) {
        super(string);
        this.d_color = color;
        this.d_texinfo = textureInfo;
        this.d_surfDesc = iSurfDesc;
        this.d_fyi = "";
        this.d_customFDSProps = new CustomFDSProps();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Surface)) {
            return false;
        }
        Surface surface = (Surface)object;
        return super.equals(object) && this.d_color.equals(surface.d_color) && theUtil.equal(this.d_texinfo, surface.d_texinfo) && this.d_surfDesc.equals(surface.d_surfDesc) && this.d_customFDSProps.equals(surface.d_customFDSProps);
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        if (this.d_color.equals(color)) {
            return;
        }
        this.d_color = color;
        this.changedEvt(EVT_COLOR);
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Pair<Color, pyrosim.legacy_2012_1.thunderheadeng.image.Image> getDiffuse() {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image image = null;
        if (this.d_texinfo != null && this.getDomain() != null) {
            Texture texture = TextureInfo.getTexture(this.d_texinfo, ((PyroMod)this.getDomain()).getTextureDB());
            image = texture != null ? texture.getImage() : null;
        }
        return new Pair<Color, Object>(this.d_color, image);
    }

    @Override
    public Pair<Color, pyrosim.legacy_2012_1.thunderheadeng.image.Image> getSpecular() {
        return new Pair<Color, Object>(Color.WHITE, null);
    }

    @Override
    public pyrosim.legacy_2012_1.thunderheadeng.image.Image getNormal() {
        return null;
    }

    public void setSurfDesc(ISurfDesc iSurfDesc) {
        this.d_surfDesc = iSurfDesc;
        this.changedEvt(new Object[0]);
    }

    public ISurfDesc getSurfDesc() {
        return this.d_surfDesc;
    }

    public TextureInfo getTextureInfo() {
        return this.d_texinfo;
    }

    public void setTexture(TextureInfo textureInfo) {
        if (this.d_texinfo == textureInfo) {
            return;
        }
        this.d_texinfo = textureInfo;
        this.invalidateIcon();
        this.changedEvt(EVT_TEXTURE);
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(EVT_FYI);
    }

    private void invalidateIcon() {
        this.d_icon = null;
    }

    public Icon getIcon(int n, int n2) {
        if (this.d_icon == null) {
            TextureInfo textureInfo = this.getTextureInfo();
            if (textureInfo != null && this.getDomain() != null) {
                Texture texture = TextureInfo.getTexture(textureInfo, ((PyroMod)this.getDomain()).getTextureDB());
                assert (texture != null);
                BufferedImage bufferedImage = texture.getBufferedImage();
                if (bufferedImage == null) {
                    return null;
                }
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(1.0, 1.0);
                affineTransform.scale((double)(n - 2) / (double)bufferedImage.getWidth(), (double)(n2 - 2) / (double)bufferedImage.getHeight());
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage(bufferedImage, affineTransform, new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                        return true;
                    }
                });
                graphics2D.dispose();
                this.d_icon = new ImageIcon(bufferedImage2);
            } else {
                this.d_icon = null;
            }
        }
        return this.d_icon;
    }

    public boolean isPredefined() {
        for (PredefSurf predefSurf : PredefSurf.values()) {
            if (!predefSurf.name().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Surface: " + this.getName() + " (" + this.d_fyi + ")";
    }

    @Override
    public boolean invokesMixFrac() {
        return this.d_surfDesc.invokesMixFrac();
    }
}

