/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class SurfComposition
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_initInnerTemp;
    public final TimeFunction d_tempRamp;
    public final List<SurfLayer> d_layers;
    public final Backing d_backing;
    public final boolean d_porous;
    public final Double d_layerDivide;

    public SurfComposition() {
        this(null, TimeFunction.newDefault(), Backing.newDefault(), false, null, new ArrayList<SurfLayer>(0));
    }

    public SurfComposition(UnitDouble unitDouble, TimeFunction timeFunction, Backing backing, boolean bl, Double d, List<SurfLayer> list) {
        this.d_initInnerTemp = unitDouble;
        this.d_tempRamp = timeFunction;
        this.d_backing = backing;
        this.d_porous = bl;
        this.d_layerDivide = d;
        this.d_layers = Collections.unmodifiableList(list);
        assert (this.d_layerDivide == null || this.d_layerDivide <= (double)this.d_layers.size() && this.d_layerDivide >= 0.0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SurfComposition)) {
            return false;
        }
        SurfComposition surfComposition = (SurfComposition)object;
        return this.d_porous == surfComposition.d_porous && this.d_backing.equals(surfComposition.d_backing) && theUtil.equal(this.d_layerDivide, surfComposition.d_layerDivide) && theUtil.equal(this.d_initInnerTemp, surfComposition.d_initInnerTemp) && this.d_tempRamp.equals(surfComposition.d_tempRamp) && this.d_layers.equals(surfComposition.d_layers);
    }

    public static class SurfLayer
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_thickness;
        private final Map<Material, SurfComponent> d_components;

        public SurfLayer(UnitDouble unitDouble, Collection<SurfComponent> collection) {
            this.d_thickness = unitDouble;
            this.d_components = new LinkedIdentityHashMap<Material, SurfComponent>();
            for (SurfComponent surfComponent : collection) {
                this.d_components.put(surfComponent.d_material, surfComponent);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof SurfLayer)) {
                return false;
            }
            SurfLayer surfLayer = (SurfLayer)object;
            return this.d_thickness.equals(surfLayer.d_thickness) && Util.identityMapsEqual(this.d_components, surfLayer.d_components);
        }

        public Collection<SurfComponent> getComponents() {
            return this.d_components.values();
        }

        @Override
        public void takeDepSnapshot(DepList depList) {
            depList.add(DLink.REQUIRED, this.d_components.keySet());
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
            Util.removeAllNotOfType(set, Material.class);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
            if (!this.d_components.containsKey(iPyroObject)) {
                return null;
            }
            return new AUndoableTask(){
                private Map<Material, SurfComponent> d_oldComp;

                @Override
                public void undo() {
                    d_components.clear();
                    d_components.putAll(this.d_oldComp);
                    this.d_oldComp = null;
                }

                @Override
                public void run() {
                    this.d_oldComp = new LinkedIdentityHashMap<Material, SurfComponent>(d_components);
                    SurfComponent surfComponent = (SurfComponent)d_components.remove(iPyroObject);
                    SurfComponent surfComponent2 = (SurfComponent)d_components.get(iPyroObject2);
                    if (surfComponent2 == null) {
                        SurfComponent surfComponent3 = new SurfComponent(surfComponent.d_massFraction, (Material)iPyroObject2);
                        d_components.put((Material)iPyroObject2, surfComponent3);
                    } else {
                        SurfComponent surfComponent4 = new SurfComponent(surfComponent.d_massFraction + surfComponent2.d_massFraction, (Material)iPyroObject2);
                        d_components.put((Material)iPyroObject2, surfComponent4);
                    }
                }
            };
        }

        public static class SurfComponent
        implements Serializable {
            static final long serialVersionUID = 1L;
            public final double d_massFraction;
            public final Material d_material;

            public SurfComponent(double d, Material material) {
                this.d_massFraction = d;
                this.d_material = material;
            }

            public boolean equals(Object object) {
                if (!(object instanceof SurfComponent)) {
                    return false;
                }
                SurfComponent surfComponent = (SurfComponent)object;
                return this.d_massFraction == surfComponent.d_massFraction && this.d_material.equals(surfComponent.d_material);
            }
        }
    }
}

