/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class SpecInjList
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int MASS_FLUX = 0;
    public static final int MASS_FRACTION = 1;
    public final int injType;
    public final TimeBasedValue<Object> d_bgInjection;
    private final Map<ExSpec, SpeciesInjection> d_injections;

    public SpecInjList() {
        this(0, null, new ArrayList<SpeciesInjection>(0));
    }

    public SpecInjList(int n, TimeBasedValue<Object> timeBasedValue, List<SpeciesInjection> list) {
        this.injType = n;
        this.d_bgInjection = timeBasedValue;
        this.d_injections = new IdentityHashMap<ExSpec, SpeciesInjection>(list.size());
        for (SpeciesInjection speciesInjection : list) {
            this.d_injections.put(speciesInjection.species, speciesInjection);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpecInjList)) {
            return false;
        }
        SpecInjList specInjList = (SpecInjList)object;
        return this.injType == specInjList.injType && theUtil.equal(this.d_bgInjection, specInjList.d_bgInjection) && Util.identityMapsEqual(this.d_injections, specInjList.d_injections);
    }

    public Collection<SpeciesInjection> getInjections() {
        return this.d_injections.values();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, this.d_injections.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!this.d_injections.containsKey(iPyroObject)) {
            return null;
        }
        return new AUndoableTask(){
            private SpeciesInjection d_inj;
            private boolean d_replAdded;

            @Override
            public void undo() {
                if (this.d_replAdded) {
                    SpecInjList.this.d_injections.remove(iPyroObject2);
                }
                SpecInjList.this.d_injections.put(this.d_inj.species, this.d_inj);
            }

            @Override
            public void run() {
                this.d_inj = (SpeciesInjection)SpecInjList.this.d_injections.remove(iPyroObject);
                if (iPyroObject2 != null && !SpecInjList.this.d_injections.containsKey(iPyroObject2)) {
                    SpeciesInjection speciesInjection = new SpeciesInjection((ExSpec)iPyroObject2, this.d_inj.val, this.d_inj.func);
                    SpecInjList.this.d_injections.put((ExSpec)iPyroObject2, speciesInjection);
                    this.d_replAdded = true;
                } else {
                    this.d_replAdded = false;
                }
            }
        };
    }
}

