/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public interface ISlip
extends Serializable {
    public static final ISlip DEFAULT = new RoughSlip(SIUS.newud(0.0, 0));
    public static final FreeSlip FREE_SLIP = new FreeSlip();
    public static final NoSlip NO_SLIP = new NoSlip();

    public static class RoughSlip
    implements ISlip {
        static final long serialVersionUID = 1L;
        public final UnitDouble roughness;

        public RoughSlip(UnitDouble unitDouble) {
            this.roughness = unitDouble;
        }

        public boolean equals(Object object) {
            return object instanceof RoughSlip && ((RoughSlip)object).roughness.equals(this.roughness);
        }
    }

    public static class NoSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private NoSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_SLIP;
        }
    }

    public static class FreeSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private FreeSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return FREE_SLIP;
        }
    }
}

