/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class HeatRelease
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Type d_type;
    public final UnitDouble d_extingCoeff;

    public HeatRelease() {
        this(new HRRType(), new UnitDouble(0.0, SIUS.unit(21)));
    }

    public HeatRelease(Type type, UnitDouble unitDouble) {
        this.d_type = type;
        this.d_extingCoeff = unitDouble;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 34) {
            double d = this.d_extingCoeff.getValueNoUnit();
            UnitDouble unitDouble = new UnitDouble(d, SIUS.unit(21));
            try {
                Util.assignFinalField(this, "d_extingCoeff", unitDouble);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    public boolean invokesMixFrac() {
        return this.d_type.invokesMixFrac();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeatRelease)) {
            return false;
        }
        HeatRelease heatRelease = (HeatRelease)object;
        return this.d_type.equals(heatRelease.d_type) && this.d_extingCoeff.equals(heatRelease.d_extingCoeff);
    }

    public static class MLRType
    extends Type {
        static final long serialVersionUID = 6552285593797687956L;

        public MLRType() {
            this(new UnitDouble(0.0, SIUS.unit(44)), TimeFunction.newDefault());
        }

        public MLRType(UnitDouble unitDouble, TimeFunction timeFunction) {
            super(unitDouble, timeFunction);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MLRType && super.equals(object);
        }

        @Override
        public boolean invokesMixFrac() {
            return ((UnitDouble)this.val).getValueNoUnit() > 0.0;
        }
    }

    public static class HRRType
    extends Type {
        static final long serialVersionUID = -2937414973907714621L;

        public HRRType() {
            this(new UnitDouble(500.0, SIUS.unit(22)), TimeFunction.newDefault());
        }

        public HRRType(UnitDouble unitDouble, TimeFunction timeFunction) {
            super(unitDouble, timeFunction);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof HRRType && super.equals(object);
        }

        @Override
        public boolean invokesMixFrac() {
            return ((UnitDouble)this.val).getValueNoUnit() > 0.0;
        }
    }

    public static abstract class Type
    extends TimeBasedValue<UnitDouble> {
        static final long serialVersionUID = 1L;

        public Type(UnitDouble unitDouble, TimeFunction timeFunction) {
            super(unitDouble, timeFunction);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Type && super.equals(object);
        }

        public abstract boolean invokesMixFrac();
    }
}

