/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Fuel
implements Serializable {
    static final long serialVersionUID = 1L;

    public static class ManualReac
    implements IReaction {
        static final long serialVersionUID = 1L;
        public final HeatRelease d_heatRelease;
        public final IIgnition d_ignition;
        public final UnitDouble d_heatOfVap;

        public ManualReac() {
            this(new HeatRelease(), SIUS.newud(0.0, 46), new ImmediateIgnite());
        }

        public ManualReac(HeatRelease heatRelease, UnitDouble unitDouble, IIgnition iIgnition) {
            this.d_heatRelease = heatRelease;
            this.d_heatOfVap = unitDouble;
            this.d_ignition = iIgnition;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ManualReac)) {
                return false;
            }
            ManualReac manualReac = (ManualReac)object;
            return this.d_heatRelease.equals(manualReac.d_heatRelease) && this.d_ignition.equals(manualReac.d_ignition) && (this.d_heatOfVap == null ? manualReac.d_heatOfVap == null : this.d_heatOfVap.equals(manualReac.d_heatOfVap));
        }

        @Override
        public boolean invokesMixFrac() {
            return this.d_heatRelease.invokesMixFrac();
        }

        public static class TemperatureIgnite
        implements IIgnition {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_temperature;

            public TemperatureIgnite() {
                this(new UnitDouble(5000.0, SI.CELSIUS));
            }

            public TemperatureIgnite(UnitDouble unitDouble) {
                this.d_temperature = unitDouble;
            }

            public boolean equals(Object object) {
                return object instanceof TemperatureIgnite && this.d_temperature.equals(((TemperatureIgnite)object).d_temperature);
            }
        }

        public static class ImmediateIgnite
        implements IIgnition {
            static final long serialVersionUID = 1L;

            public boolean equals(Object object) {
                return object instanceof ImmediateIgnite;
            }
        }

        public static interface IIgnition
        extends Serializable {
        }
    }

    public static class MaterialReac
    implements IReaction {
        static final long serialVersionUID = 1L;

        public boolean equals(Object object) {
            return object instanceof MaterialReac;
        }

        @Override
        public boolean invokesMixFrac() {
            return false;
        }
    }

    public static interface IReaction
    extends Serializable {
        public boolean invokesMixFrac();
    }
}

