/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SolidReaction
extends Reaction {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;

    public SolidReaction() {
        this(new Rate(), new ReacByproducts());
    }

    public SolidReaction(Rate rate, ReacByproducts reacByproducts) {
        super(reacByproducts);
        this.d_rate = rate;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SolidReaction)) {
            return false;
        }
        SolidReaction solidReaction = (SolidReaction)object;
        return super.equals(object) && this.d_rate.equals(solidReaction.d_rate);
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final double d_tempExponent;
        public final double d_massFracExponent;
        public final UnitDouble d_thresholdTemp;
        public final ISpecification d_spec;

        public Rate() {
            this(1.0, 0.0, new UnitDouble(-273.15, SI.CELSIUS), new RefSpec());
        }

        public Rate(double d, double d2, UnitDouble unitDouble, ISpecification iSpecification) {
            this.d_tempExponent = d2;
            this.d_massFracExponent = d;
            this.d_thresholdTemp = unitDouble;
            this.d_spec = iSpecification;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Rate)) {
                return false;
            }
            Rate rate = (Rate)object;
            return this.d_tempExponent == rate.d_tempExponent && this.d_massFracExponent == rate.d_massFracExponent && theUtil.equal(this.d_thresholdTemp, rate.d_thresholdTemp) && this.d_spec.equals(rate.d_spec);
        }

        public static class RefSpec
        implements ISpecification {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_refTemp;
            public final UnitDouble d_pyrolysisRange;
            public final UnitDouble d_heatingRate;

            public RefSpec() {
                this(new UnitDouble(100.0, SI.CELSIUS), new UnitDouble(80.0, SI.CELSIUS), new UnitDouble(5.0, SI.KELVIN.divide(NonSI.MINUTE)));
            }

            public RefSpec(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
                this.d_refTemp = unitDouble;
                this.d_pyrolysisRange = unitDouble2;
                this.d_heatingRate = unitDouble3;
            }

            public boolean equals(Object object) {
                if (!(object instanceof RefSpec)) {
                    return false;
                }
                RefSpec refSpec = (RefSpec)object;
                return this.d_refTemp.equals(refSpec.d_refTemp) && this.d_pyrolysisRange.equals(refSpec.d_pyrolysisRange) && this.d_heatingRate.equals(refSpec.d_heatingRate);
            }

            private Object readResolve() throws ObjectStreamException {
                UnitDouble unitDouble = this.d_pyrolysisRange;
                UnitDouble unitDouble2 = this.d_heatingRate;
                if (unitDouble == null || unitDouble2 == null) {
                    RefSpec refSpec = new RefSpec();
                    unitDouble = refSpec.d_pyrolysisRange;
                    unitDouble2 = refSpec.d_heatingRate;
                }
                return new RefSpec(this.d_refTemp, unitDouble, unitDouble2);
            }
        }

        public static class AESpec
        implements ISpecification {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_a;
            public final UnitDouble d_e;

            public AESpec() {
                this(SIUS.newud(1.0E13, 50), SIUS.newud(0.0, 54));
            }

            public AESpec(UnitDouble unitDouble, UnitDouble unitDouble2) {
                this.d_a = unitDouble;
                this.d_e = unitDouble2;
            }

            private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
                objectInputStream.defaultReadObject();
                if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 34) {
                    double d = this.d_a.getValueNoUnit();
                    UnitDouble unitDouble = new UnitDouble(d, SIUS.unit(50));
                    try {
                        Util.assignFinalField(this, "d_a", unitDouble);
                    }
                    catch (Exception exception) {
                        throw new IOException(exception);
                    }
                }
            }

            public boolean equals(Object object) {
                if (!(object instanceof AESpec)) {
                    return false;
                }
                AESpec aESpec = (AESpec)object;
                return this.d_a.equals(aESpec.d_a) && this.d_e.equals(aESpec.d_e);
            }
        }

        public static interface ISpecification
        extends Serializable {
        }
    }
}

