/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class ReacByproducts
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public final double d_nuFuel;
    public final double d_nuWater;
    public double d_nuResidue;
    private Material d_residue;
    public final UnitDouble d_heat;

    public ReacByproducts() {
        this(0.0, 0.0, 0.0, null, null);
    }

    public ReacByproducts(double d, double d2, double d3, Material material, UnitDouble unitDouble) {
        assert (d + d2 + d3 <= 1.000001);
        this.d_nuFuel = d;
        this.d_nuWater = d2;
        this.d_nuResidue = d3;
        if (this.d_nuResidue > 0.0) {
            assert (material != null);
            this.d_residue = material;
        } else {
            this.d_residue = null;
        }
        this.d_heat = unitDouble;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReacByproducts)) {
            return false;
        }
        ReacByproducts reacByproducts = (ReacByproducts)object;
        return this.d_nuFuel == reacByproducts.d_nuFuel && this.d_nuWater == reacByproducts.d_nuWater && this.d_nuResidue == reacByproducts.d_nuResidue && theUtil.equal(this.d_residue, reacByproducts.d_residue) && theUtil.equal(this.d_heat, reacByproducts.d_heat);
    }

    public Material getResidue() {
        return this.d_residue;
    }

    public boolean residueCreatesCycle(Material material) {
        for (Reaction reaction : material.getPyrolysis().getReactions()) {
            ReacByproducts reacByproducts = reaction.d_byproducts;
            if (reacByproducts != this && (reacByproducts.d_residue == null || !this.residueCreatesCycle(reacByproducts.d_residue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_residue);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, Material.class);
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            Material material = (Material)iterator.next();
            if (material == null || !this.residueCreatesCycle(material)) continue;
            iterator.remove();
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject != this.d_residue) {
            return null;
        }
        return new AUndoableTask(){
            private double d_oldNu;

            @Override
            public void undo() {
                ReacByproducts.this.d_residue = (Material)iPyroObject;
                ReacByproducts.this.d_nuResidue = this.d_oldNu;
            }

            @Override
            public void run() {
                this.d_oldNu = ReacByproducts.this.d_nuResidue;
                ReacByproducts.this.d_residue = (Material)iPyroObject2;
                if (ReacByproducts.this.d_residue == null) {
                    ReacByproducts.this.d_nuResidue = 0.0;
                }
            }
        };
    }
}

