/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.Stack;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class Material
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object EVT_FYI = new Object();
    private ThermalProps d_thermalProps;
    private IPyrolysis d_pyrolysis;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Material(String string) {
        this(string, new SolidPyrolysis(), new ThermalProps());
    }

    public Material(String string, IPyrolysis iPyrolysis, ThermalProps thermalProps) {
        super(string);
        this.d_pyrolysis = iPyrolysis;
        this.d_thermalProps = thermalProps;
        this.d_fyi = "";
        this.d_customFDSProps = new CustomFDSProps();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Material)) {
            return false;
        }
        Material material = (Material)object;
        return super.equals(object) && this.d_thermalProps.equals(material.d_thermalProps) && this.d_pyrolysis.equals(material.d_pyrolysis) && this.d_customFDSProps.equals(material.d_customFDSProps);
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public boolean isValidResidue(Material material) {
        return !material.getResidues().contains(this);
    }

    public boolean hasValidResidues() {
        return this.getResidues() != null;
    }

    public Set<Material> getResidues() {
        return Material.getResidues(this);
    }

    private static Set<Material> getResidues(Material material) {
        IdentityHashSet<Material> identityHashSet = new IdentityHashSet<Material>();
        Stack<Material> stack = new Stack<Material>();
        stack.push(material);
        while (!stack.isEmpty()) {
            Material material2 = (Material)stack.pop();
            if (!identityHashSet.add(material2)) {
                return null;
            }
            for (Reaction reaction : material2.d_pyrolysis.getReactions()) {
                Material material3 = reaction.d_byproducts.getResidue();
                if (material3 == null) continue;
                stack.push(material3);
            }
        }
        return identityHashSet;
    }

    public boolean isSolid() {
        return this.d_pyrolysis instanceof SolidPyrolysis;
    }

    public boolean isLiquid() {
        return this.d_pyrolysis instanceof LiquidPyrolysis;
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    public IPyrolysis getPyrolysis() {
        return this.d_pyrolysis;
    }

    public void setPyrolysis(IPyrolysis iPyrolysis) {
        this.d_pyrolysis = iPyrolysis;
        this.changedEvt(new Object[0]);
    }

    public ThermalProps getThermalProps() {
        return this.d_thermalProps;
    }

    public void setThermalProps(ThermalProps thermalProps) {
        this.d_thermalProps = thermalProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean invokesMixFrac() {
        for (Reaction reaction : this.d_pyrolysis.getReactions()) {
            if (!(reaction.d_byproducts.d_nuFuel > 0.0)) continue;
            return true;
        }
        return false;
    }
}

