/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SimParams
extends APyroObject {
    static final long serialVersionUID = 1L;
    private String d_jobTitle = "";
    private Time d_time = new Time();
    private Calculations d_calcs = new Calculations();
    private Environment d_env = new Environment();
    private RadiationTransport d_radi = new RadiationTransport();
    private FileOutput d_fileOutput = new FileOutput();
    private Particles d_particles = new Particles();
    private Misc d_misc;
    @SkipDep
    private Pers d_persGlobals;
    private Map<String, CustomFDSProps> d_customProps;

    public SimParams(SurfaceManager surfaceManager) {
        this.d_misc = new Misc(surfaceManager);
        this.d_persGlobals = SimParams.initPers();
        this.d_customProps = SimParams.createCustomPropsMap();
    }

    private static Map<String, CustomFDSProps> createCustomPropsMap() {
        LinkedHashMap<String, CustomFDSProps> linkedHashMap = new LinkedHashMap<String, CustomFDSProps>();
        linkedHashMap.put("TIME", new CustomFDSProps());
        linkedHashMap.put("DUMP", new CustomFDSProps());
        linkedHashMap.put("RADI", new CustomFDSProps());
        linkedHashMap.put("MISC", new CustomFDSProps());
        return linkedHashMap;
    }

    public Set<String> getCustomFDSTypes() {
        return this.d_customProps.keySet();
    }

    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customProps.get(string);
    }

    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        assert (this.d_customProps.containsKey(string));
        this.d_customProps.put(string, customFDSProps);
        this.changedEvt(new Object[0]);
    }

    @Override
    protected void addToDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
        super.addToDomain(pyroMod, iPyroObject);
        this.d_time.setDomain(pyroMod, this);
        this.d_calcs.setDomain(pyroMod, this);
        this.d_env.setDomain(pyroMod, this);
        this.d_radi.setDomain(pyroMod, this);
        this.d_fileOutput.setDomain(pyroMod, this);
        this.d_particles.setDomain(pyroMod, this);
        this.d_misc.setDomain(pyroMod, this);
        this.d_persGlobals.setDomain(pyroMod, this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SimParams)) {
            return false;
        }
        SimParams simParams = (SimParams)object;
        return simParams.d_time.equals(this.d_time) && simParams.d_calcs.equals(this.d_calcs) && simParams.d_env.equals(this.d_env) && simParams.d_radi.equals(this.d_radi) && simParams.d_fileOutput.equals(this.d_fileOutput) && simParams.d_particles.equals(this.d_particles) && simParams.d_misc.equals(this.d_misc) && simParams.d_persGlobals.equals(this.d_persGlobals) && simParams.d_customProps.equals(this.d_customProps);
    }

    @Override
    public Object clone() {
        SimParams simParams = (SimParams)super.clone();
        simParams.d_time = (Time)this.d_time.clone();
        simParams.d_calcs = (Calculations)this.d_calcs.clone();
        simParams.d_env = (Environment)this.d_env.clone();
        simParams.d_radi = (RadiationTransport)this.d_radi.clone();
        simParams.d_fileOutput = (FileOutput)this.d_fileOutput.clone();
        simParams.d_particles = (Particles)this.d_particles.clone();
        simParams.d_misc = (Misc)this.d_misc.clone();
        simParams.d_persGlobals = (Pers)this.d_persGlobals.clone();
        simParams.d_customProps = new LinkedHashMap<String, CustomFDSProps>();
        simParams.d_customProps.putAll(this.d_customProps);
        return simParams;
    }

    private static Pers initPers() {
        return new Pers("globals");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 31) {
            this.d_persGlobals = SimParams.initPers();
        }
        if (this.d_customProps == null) {
            this.d_customProps = SimParams.createCustomPropsMap();
        }
    }

    public String getJobTitle() {
        return this.d_jobTitle;
    }

    public void setJobTitle(String string) {
        this.d_jobTitle = string;
        this.changedEvt(new Object[0]);
    }

    public Time getTime() {
        return this.d_time;
    }

    public Calculations getCalculations() {
        return this.d_calcs;
    }

    public Environment getEnvironment() {
        return this.d_env;
    }

    public RadiationTransport getRadiTransport() {
        return this.d_radi;
    }

    public FileOutput getFileOutput() {
        return this.d_fileOutput;
    }

    public Particles getParticles() {
        return this.d_particles;
    }

    public Misc getMisc() {
        return this.d_misc;
    }

    public Pers getPersGlobals() {
        return this.d_persGlobals;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_calcs.isMixFracOnly() || this.d_env.isMixFracOnly() || this.d_fileOutput.isMixFracOnly() || this.d_misc.isMixFracOnly() || this.d_particles.isMixFracOnly() || this.d_radi.isMixFracOnly() || this.d_time.isMixFracOnly();
    }

    public static class Misc
    extends APyroObject
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        private String d_backgroundSpecies = ExSpecList.Predefined.AIR.getName();
        private Surface d_surfDefault;
        private UnitPoint3D d_textureOrigin;
        private boolean d_predictCOProd;
        private boolean d_forceMixFrac;
        private Map<String, Object> d_evacProps;
        private transient boolean d_resume = false;

        public Misc(SurfaceManager surfaceManager) {
            this.d_surfDefault = (Surface)surfaceManager.get(PredefSurf.INERT.name());
            this.d_textureOrigin = Geometry.UP3D_ZERO;
            this.d_predictCOProd = false;
            this.d_forceMixFrac = true;
            this.initEvacProps(surfaceManager);
        }

        @Override
        public Object clone() {
            Misc misc = (Misc)super.clone();
            misc.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return misc;
        }

        public void initEvacProps(SurfaceManager surfaceManager) {
            this.d_evacProps = new HashMap<String, Object>();
            this.d_evacProps.put("EVACUATION_MC_MODE", false);
            this.d_evacProps.put("PRESSURE_ITERATIONS", 50);
            this.d_evacProps.put("TIME_ITERATIONS", 50);
            this.d_evacProps.put("EVAC_SURF_DEFAULT", surfaceManager.get(PredefSurf.INERT.name()));
        }

        public void setResume(boolean bl) {
            this.d_resume = bl;
        }

        public boolean getAndClearResume() {
            boolean bl = this.d_resume;
            this.d_resume = false;
            return bl;
        }

        @Override
        public void takeDepSnapshot(DepList depList) {
            Surface surface = (Surface)this.getEvacProp("EVAC_SURF_DEFAULT");
            depList.add(DLink.REQUIRED, (IPyroObject)this.d_surfDefault);
            depList.add(DLink.WEAK, (IPyroObject)surface);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
            AUndoableTask aUndoableTask;
            Task task = iPyroObject == this.getSurfDefault() ? this.taskSetSurfDefault((Surface)iPyroObject2) : null;
            AUndoableTask aUndoableTask2 = aUndoableTask = iPyroObject == this.getEvacProp("EVAC_SURF_DEFAULT") ? new AUndoableTask(){

                @Override
                public void run() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", iPyroObject2);
                }

                @Override
                public void undo() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", iPyroObject);
                }
            } : null;
            if (task != null && aUndoableTask != null) {
                CompositeTask compositeTask = new CompositeTask(this.getDomain());
                compositeTask.addTask(task);
                compositeTask.addTask(aUndoableTask);
                return compositeTask;
            }
            if (task != null) {
                return task;
            }
            if (aUndoableTask != null) {
                return aUndoableTask;
            }
            return EmptyTask.INSTANCE;
        }

        public boolean getForceMixFracFlag() {
            return this.d_forceMixFrac;
        }

        public void setForceMixFracFlag(boolean bl) {
            this.d_forceMixFrac = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean predictCOProd() {
            return this.d_predictCOProd;
        }

        public Task taskSetPredictCOProd(boolean bl) {
            return new AReplaceRefTask<Boolean>((Object)this.d_predictCOProd, (Object)bl){

                @Override
                protected void set(Boolean bl) {
                    d_predictCOProd = bl;
                    this.changedEvt(new Object[0]);
                }
            };
        }

        public String getBackgroundSpecies() {
            return this.d_backgroundSpecies;
        }

        public Task taskSetBackgroundSpecies(String string) {
            return new AReplaceRefTask<String>((Object)this.d_backgroundSpecies, (Object)string){

                @Override
                protected void set(String string) {
                    d_backgroundSpecies = string;
                    this.changedEvt(new Object[0]);
                }
            };
        }

        public Surface getSurfDefault() {
            return this.d_surfDefault;
        }

        public void setSurfDefault(Surface surface) {
            this.d_surfDefault = surface;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProp(String string, Object object) {
            if (this.d_evacProps.get(string) != object) {
                this.d_evacProps.put(string, object);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String string) {
            return this.d_evacProps.get(string);
        }

        public Map<String, Object> getEvacProps() {
            return this.d_evacProps;
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
            Util.removeAllNotOfType(set, Surface.class);
        }

        public Task taskSetSurfDefault(Surface surface) {
            return new AReplaceRefTask<Surface>((Object)this.d_surfDefault, (Object)surface){

                @Override
                protected void set(Surface surface) {
                    this.setSurfDefault(surface);
                }
            };
        }

        public UnitPoint3D getTextureOrigin() {
            return this.d_textureOrigin;
        }

        public void setTextureOrigin(UnitPoint3D unitPoint3D) {
            this.d_textureOrigin = unitPoint3D;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Particles
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final IntVR MAX_PARTICLES_PER_MESH = IntVR.above(0, false);
        private boolean d_porousFloor = true;
        private boolean d_allowUndersideDroplets = false;
        private int d_maxParticlesPerMesh = 500000;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isPourousFloor() {
            return this.d_porousFloor;
        }

        public void setPourousFloor(boolean bl) {
            this.d_porousFloor = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean getAllowUndersideDroplets() {
            return this.d_allowUndersideDroplets;
        }

        public void setAllowUndersideDroplets(boolean bl) {
            this.d_allowUndersideDroplets = bl;
            this.changedEvt(new Object[0]);
        }

        public int getMaxParticlesPerMesh() {
            return this.d_maxParticlesPerMesh;
        }

        public void setMaxParticlesPerMesh(int n) {
            this.d_maxParticlesPerMesh = n;
            this.changedEvt(new Object[0]);
        }
    }

    public static class FileOutput
    extends APyroObject
    implements Serializable,
    IDirectDependent {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_RANGE_FILE_OUT = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), true);
        public static final IntVR NUM_FRAMES_RANGE = IntVR.above(1, true);
        private boolean d_limitCSVColumns = true;
        private UnitDouble d_dtBoundaryFile = null;
        private UnitDouble d_dtDeviceFiles = null;
        private UnitDouble d_dtHeatReleaseRateFiles = null;
        private UnitDouble d_dtIsofFiles = null;
        private UnitDouble d_dtParticleFiles = null;
        private UnitDouble d_dtProfileDumpInterval = null;
        private UnitDouble d_dtRestartFile = new UnitDouble(300.0, SI.SECOND);
        private UnitDouble d_dtSliceFiles = null;
        private int d_numOutputFrames = 1000;
        private boolean d_visualize3dSmoke = true;
        private IQuantity d_smokeQuantity = null;
        private ExSpec d_smokeSpec;
        private boolean d_writeSpeciesMassFile = false;
        private UnitDouble d_dtMassFiles = null;
        private boolean d_writePlot3dXYZFile = false;
        private UnitDouble d_dtPlot3dFile = null;

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean isMixFracOnly() {
            return this.d_smokeQuantity != null ? this.d_smokeQuantity.get().mixFracOnly : false;
        }

        public boolean isLimitCSVColumns() {
            return this.d_limitCSVColumns;
        }

        public void setLimitCSVColumns(boolean bl) {
            this.d_limitCSVColumns = bl;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtBoundaryFile() {
            return this.d_dtBoundaryFile;
        }

        public void setDtBoundaryFile(UnitDouble unitDouble) {
            this.d_dtBoundaryFile = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtDeviceFiles() {
            return this.d_dtDeviceFiles;
        }

        public void setDtDeviceFiles(UnitDouble unitDouble) {
            this.d_dtDeviceFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtHeatReleaseRateFiles() {
            return this.d_dtHeatReleaseRateFiles;
        }

        public void setDtHeatReleaseRateFiles(UnitDouble unitDouble) {
            this.d_dtHeatReleaseRateFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtIsofFiles() {
            return this.d_dtIsofFiles;
        }

        public void setDtIsofFiles(UnitDouble unitDouble) {
            this.d_dtIsofFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtParticleFiles() {
            return this.d_dtParticleFiles;
        }

        public void setDtParticleFiles(UnitDouble unitDouble) {
            this.d_dtParticleFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtRestartFile() {
            return this.d_dtRestartFile;
        }

        public void setDtRestartFile(UnitDouble unitDouble) {
            this.d_dtRestartFile = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtSliceFiles() {
            return this.d_dtSliceFiles;
        }

        public void setDtSliceFiles(UnitDouble unitDouble) {
            this.d_dtSliceFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtMassFiles() {
            return this.d_dtMassFiles;
        }

        public void setDtMassFiles(UnitDouble unitDouble) {
            this.d_dtMassFiles = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtPlot3dFile() {
            return this.d_dtPlot3dFile;
        }

        public void setDtPlot3dFile(UnitDouble unitDouble) {
            this.d_dtPlot3dFile = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtProfileDumpInterval() {
            return this.d_dtProfileDumpInterval;
        }

        public void setDtProfileDumpInterval(UnitDouble unitDouble) {
            this.d_dtProfileDumpInterval = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public int getNumOutputFrames() {
            return this.d_numOutputFrames;
        }

        public void setNumOutputFrames(int n) {
            this.d_numOutputFrames = n;
            this.changedEvt(new Object[0]);
        }

        public boolean isVisualize3dSmoke() {
            return this.d_visualize3dSmoke;
        }

        public void setVisualize3dSmoke(boolean bl) {
            this.d_visualize3dSmoke = bl;
            this.changedEvt(new Object[0]);
        }

        public IQuantity getSmokeQuantity() {
            return this.d_smokeQuantity;
        }

        public void setSmokeQuantity(IQuantity iQuantity) {
            this.d_smokeQuantity = iQuantity;
            this.changedEvt(new Object[0]);
        }

        public static boolean isValidSmokeQuantity(Quantity quantity) {
            return QuantityUtil.isSpecMassFraction(quantity);
        }

        public static IObjectFilter<Quantity> getSmokeQuantityFilter() {
            return new IObjectFilter<Quantity>(){

                @Override
                public boolean shouldFilter(Quantity quantity) {
                    return !FileOutput.isValidSmokeQuantity(quantity);
                }
            };
        }

        public void convertPre28SpecToQuantity() {
            if (this.d_smokeSpec != null) {
                this.d_smokeQuantity = Quantity.SPEC_MASS_FRACTION.create(this.d_smokeSpec);
                this.d_smokeSpec = null;
            }
        }

        public boolean isWriteSpeciesMassFile() {
            return this.d_writeSpeciesMassFile;
        }

        public void setWriteSpeciesMassFile(boolean bl) {
            this.d_writeSpeciesMassFile = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean isWritePlot3dXYZFile() {
            return this.d_writePlot3dXYZFile;
        }

        public void setWritePlot3dXYZFile(boolean bl) {
            this.d_writePlot3dXYZFile = bl;
            this.changedEvt(new Object[0]);
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
            SmokeQuantReplacer smokeQuantReplacer = new SmokeQuantReplacer((PyroMod)this.getDomain());
            smokeQuantReplacer.removeInvalidReplacements(t, set, this.d_smokeQuantity);
        }

        @Override
        public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
            SmokeQuantReplacer smokeQuantReplacer = new SmokeQuantReplacer((PyroMod)this.getDomain());
            return smokeQuantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_smokeQuantity);
        }

        @Override
        public void takeDepSnapshot(DepList depList) {
            QuantityUtil.takeDepSnapshot(depList, DLink.WEAK, this.d_smokeQuantity);
        }

        private class SmokeQuantReplacer
        extends QuantityReplacer {
            public SmokeQuantReplacer(PyroMod pyroMod) {
                super(pyroMod);
            }

            @Override
            protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
                return FileOutput.isValidSmokeQuantity(iQuantity2.get());
            }

            @Override
            protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
                return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                    @Override
                    protected void set(IQuantity iQuantity) {
                        FileOutput.this.setSmokeQuantity(iQuantity);
                    }
                };
            }
        }
    }

    public static class RadiationTransport
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, SI.KELVIN, true);
        public static final IntVR ANGLE_NUM_RANGE = IntVR.above(0, true);
        public static final IntVR TIME_STEP_RANGE = IntVR.above(1, true);
        public static final IntVR ANGLE_INCREMENT_RANGE = IntVR.above(1, true);
        public static final DoubleVR RADIATIVE_FRACTION_RANGE = DoubleVR.between(0.0, 1.0, true, true);
        private boolean d_radiationOn = true;
        private int d_angleIncrement = 5;
        private boolean d_includeExtraFuelBands = false;
        private UnitDouble d_constAbsorptionCoef = new UnitDouble(0.0, SI.METER.pow(-1));
        private int d_numPolarAngles = 15;
        private int d_numSolidAngles = 100;
        private UnitDouble d_radCalcPathLen = null;
        private double d_radiativeLossFraction = 0.35;
        private UnitDouble d_assumedRadSourceTemp = new UnitDouble(900.0, SI.CELSIUS);
        private int d_timeStepInc = 3;
        private boolean d_nonGrayGasAssumption = false;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isRadiationOn() {
            return this.d_radiationOn;
        }

        public void setRadiationOn(boolean bl) {
            this.d_radiationOn = bl;
            this.changedEvt(new Object[0]);
        }

        public int getAngleIncrement() {
            return this.d_angleIncrement;
        }

        public void setAngleIncrement(int n) {
            this.d_angleIncrement = n;
            this.changedEvt(new Object[0]);
        }

        public boolean isIncludeExtraFuelBands() {
            return this.d_includeExtraFuelBands;
        }

        public void setIncludeExtraFuelBands(boolean bl) {
            this.d_includeExtraFuelBands = bl;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getConstAbsorptionCoef() {
            return this.d_constAbsorptionCoef;
        }

        public void setConstAbsorptionCoef(UnitDouble unitDouble) {
            this.d_constAbsorptionCoef = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public int getNumPolarAngles() {
            return this.d_numPolarAngles;
        }

        public void setNumPolarAngles(int n) {
            this.d_numPolarAngles = n;
            this.changedEvt(new Object[0]);
        }

        public int getNumSolidAngles() {
            return this.d_numSolidAngles;
        }

        public void setNumSolidAngles(int n) {
            this.d_numSolidAngles = n;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getRadCalcPathLen() {
            return this.d_radCalcPathLen;
        }

        public void setRadCalcPathLen(UnitDouble unitDouble) {
            this.d_radCalcPathLen = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public double getRadiativeLossFraction() {
            return this.d_radiativeLossFraction;
        }

        public void setRadiativeLossFraction(double d) {
            this.d_radiativeLossFraction = d;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAssumedRadSourceTemp() {
            return this.d_assumedRadSourceTemp;
        }

        public void setAssumedRadSourceTemp(UnitDouble unitDouble) {
            this.d_assumedRadSourceTemp = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public int getTimeStepInc() {
            return this.d_timeStepInc;
        }

        public void setTimeStepInc(int n) {
            this.d_timeStepInc = n;
            this.changedEvt(new Object[0]);
        }

        public boolean isNonGrayGasAssumption() {
            return this.d_nonGrayGasAssumption;
        }

        public void setNonGrayGasAssumption(boolean bl) {
            this.d_nonGrayGasAssumption = bl;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Environment
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DoubleVR RELATIVE_HUMIDITY_RANGE = DoubleVR.between(0.0, 100.0, true, true);
        public static final UnitDoubleVR AMBIENT_PRESSURE_RANGE = UnitDoubleVR.above(0.0, SI.PASCAL, true);
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, SI.KELVIN, true);
        private double d_relHumidity = 40.0;
        private UnitPoint3D d_ambVel;
        private UnitDouble d_ambTemp;
        private UnitDouble d_ambPressure;
        private UnitDouble d_atmLapseRate;
        private UnitPoint3D d_gravityAccel;
        private UnitDouble d_groundLevel;
        private Variant d_gravityX;
        private Variant d_gravityY;
        private Variant d_gravityZ;

        public Environment() {
            SIUS sIUS = SIUS.getInstance();
            this.d_ambVel = new UnitPoint3D(0.0, 0.0, 0.0, sIUS.getVelocityUnit());
            this.d_ambTemp = new UnitDouble(20.0, sIUS.getTempUnit());
            this.d_ambPressure = new UnitDouble(101325.0, SI.PASCAL);
            this.d_atmLapseRate = new UnitDouble(0.0, sIUS.getAtmGradUnit());
            this.d_groundLevel = new UnitDouble(0.0, SI.METER);
            this.d_gravityAccel = null;
            this.d_gravityX = new Variant.UnitDoubleVar(new UnitDouble(0.0, sIUS.getAccelUnit()));
            this.d_gravityY = new Variant.UnitDoubleVar(new UnitDouble(0.0, sIUS.getAccelUnit()));
            this.d_gravityZ = new Variant.UnitDoubleVar(new UnitDouble(-9.81, sIUS.getAccelUnit()));
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 31) {
                this.d_groundLevel = new UnitDouble(0.0, SI.METER);
            }
            if (this.d_gravityAccel != null) {
                this.setGravityAccel(this.d_gravityAccel);
                this.d_gravityAccel = null;
            }
        }

        public double getRelHumidity() {
            return this.d_relHumidity;
        }

        public void setRelHumidity(double d) {
            this.d_relHumidity = d;
            this.changedEvt(new Object[0]);
        }

        public UnitPoint3D getGravityAccel() {
            return this.d_gravityAccel;
        }

        public void setGravityAccel(UnitPoint3D unitPoint3D) {
            this.d_gravityX = new Variant.UnitDoubleVar(unitPoint3D.xu());
            this.d_gravityY = new Variant.UnitDoubleVar(unitPoint3D.yu());
            this.d_gravityZ = new Variant.UnitDoubleVar(unitPoint3D.zu());
        }

        public void setGravityAccel(Variant variant, Variant variant2, Variant variant3) {
            this.d_gravityX = variant;
            this.d_gravityY = variant2;
            this.d_gravityZ = variant3;
            this.changedEvt(new Object[0]);
        }

        public Variant getGravityX() {
            return this.d_gravityX;
        }

        public Variant getGravityY() {
            return this.d_gravityY;
        }

        public Variant getGravityZ() {
            return this.d_gravityZ;
        }

        public UnitDouble getAmbPressure() {
            return this.d_ambPressure;
        }

        public void setAmbPressure(UnitDouble unitDouble) {
            this.d_ambPressure = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAmbTemp() {
            return this.d_ambTemp;
        }

        public void setAmbTemp(UnitDouble unitDouble) {
            this.d_ambTemp = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitPoint3D getAmbVel() {
            return this.d_ambVel;
        }

        public void setAmbVel(UnitPoint3D unitPoint3D) {
            this.d_ambVel = unitPoint3D;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAtmLapseRate() {
            return this.d_atmLapseRate;
        }

        public void setAtmLapseRate(UnitDouble unitDouble) {
            this.d_atmLapseRate = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getGroundLevel() {
            return this.d_groundLevel;
        }

        public void setGroundLevel(UnitDouble unitDouble) {
            this.d_groundLevel = unitDouble;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Calculations
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DoubleVR SC_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR PR_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR CSMAG_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_FORCED_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_HORIZONTAL_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_VERTICAL_RANGE = DoubleVR.UNBOUNDED;
        private boolean d_correctBaroclinicTorque = true;
        private boolean d_useMLTurbulentModel = false;
        private boolean d_calcDNS = false;
        private boolean d_calcIsothermal = false;
        private boolean d_gpFlameExtinction = true;
        private double d_cflMin = 0.8;
        private double d_cflMax = 1.0;
        private double d_vnMin = 0.8;
        private double d_vnMax = 1.0;
        private double d_csmag = 0.2;
        private double d_prandtlNum = 0.5;
        private double d_schmidtNum = 0.5;
        private double d_cForced = 0.037;
        private double d_cHorizontal = 1.52;
        private double d_cVertical = 1.31;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (PyroSimObjectInputStream.getVersion(objectInputStream) < 38) {
                this.d_useMLTurbulentModel = false;
                this.d_cForced = 0.037;
                this.d_cHorizontal = 1.52;
                this.d_cVertical = 1.31;
            }
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean calcDNS() {
            return this.d_calcDNS;
        }

        public void setCalcDNS(boolean bl) {
            this.d_calcDNS = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean calcIsothermal() {
            return this.d_calcIsothermal;
        }

        public void setCalcIsothermal(boolean bl) {
            this.d_calcIsothermal = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean getGPFlameExtinction() {
            return this.d_gpFlameExtinction;
        }

        public void setGPFlameExtinction(boolean bl) {
            this.d_gpFlameExtinction = bl;
            this.changedEvt(new Object[0]);
        }

        public double[] getCflRange() {
            return new double[]{this.d_cflMin, this.d_cflMax};
        }

        public void setCflRange(double d, double d2) {
            this.d_cflMin = d;
            this.d_cflMax = d2;
            this.changedEvt(new Object[0]);
        }

        public boolean isCorrectBaroclinicTorque() {
            return this.d_correctBaroclinicTorque;
        }

        public void setCorrectBaroclinicTorque(boolean bl) {
            this.d_correctBaroclinicTorque = bl;
            this.changedEvt(new Object[0]);
        }

        public boolean getUseMLTurbulentModel() {
            return this.d_useMLTurbulentModel;
        }

        public void setUseMLTurbulentModel(boolean bl) {
            this.d_useMLTurbulentModel = bl;
            this.changedEvt(new Object[0]);
        }

        public double getCsmag() {
            return this.d_csmag;
        }

        public void setCsmag(double d) {
            this.d_csmag = d;
            this.changedEvt(new Object[0]);
        }

        public double getPrandtlNum() {
            return this.d_prandtlNum;
        }

        public void setPrandtlNum(double d) {
            this.d_prandtlNum = d;
            this.changedEvt(new Object[0]);
        }

        public double getSchmidtNum() {
            return this.d_schmidtNum;
        }

        public void setSchmidtNum(double d) {
            this.d_schmidtNum = d;
            this.changedEvt(new Object[0]);
        }

        public double getCForced() {
            return this.d_cForced;
        }

        public void setCForced(double d) {
            this.d_cForced = d;
            this.changedEvt(new Object[0]);
        }

        public double getCHorizontal() {
            return this.d_cHorizontal;
        }

        public void setCHorizontal(double d) {
            this.d_cHorizontal = d;
            this.changedEvt(new Object[0]);
        }

        public double getCVertical() {
            return this.d_cVertical;
        }

        public void setCVertical(double d) {
            this.d_cVertical = d;
            this.changedEvt(new Object[0]);
        }

        public double[] getVnRange() {
            return new double[]{this.d_vnMin, this.d_vnMax};
        }

        public void setVnRange(double d, double d2) {
            this.d_vnMin = d;
            this.d_vnMax = d2;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Time
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_STEP_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);
        public static final IntVR WALL_INC_RANGE = IntVR.above(1, true);
        private UnitDouble d_startTime = new UnitDouble(0.0, SI.SECOND);
        private UnitDouble d_stopTime = new UnitDouble(10.0, SI.SECOND);
        private UnitDouble d_dt = null;
        private int d_wallIncrement = 2;
        private boolean d_lockTimeStep = false;
        private boolean d_restrictTimeStep = true;
        private Map<String, Object> d_evacProps = Time.initEvacProps();

        @Override
        public Object clone() {
            Time time = (Time)super.clone();
            time.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return time;
        }

        private static Map<String, Object> initEvacProps() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("EVAC_DT_FLOWFIELD", new UnitDouble(0.01, SI.SECOND));
            hashMap.put("EVAC_DT_STEADY_STATE", new UnitDouble(0.05, SI.SECOND));
            return hashMap;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 31) {
                this.d_restrictTimeStep = true;
                this.d_evacProps = Time.initEvacProps();
            }
        }

        public void setTimeStepLocks(boolean bl, boolean bl2) {
            this.d_lockTimeStep = bl;
            this.d_restrictTimeStep = bl2;
            this.changedEvt(new Object[0]);
        }

        public boolean lockTimeSteps() {
            return this.d_lockTimeStep;
        }

        public boolean restrictTimeSteps() {
            return this.d_restrictTimeStep;
        }

        public int getWallIncrement() {
            return this.d_wallIncrement;
        }

        public void setWallIncrement(int n) {
            this.d_wallIncrement = n;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStartTime() {
            return this.d_startTime;
        }

        public void setStartTime(UnitDouble unitDouble) {
            this.d_startTime = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStopTime() {
            return this.d_stopTime;
        }

        public void setStopTime(UnitDouble unitDouble) {
            this.d_stopTime = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getInitTimeStep() {
            return this.d_dt;
        }

        public void setInitTimeStep(UnitDouble unitDouble) {
            this.d_dt = unitDouble;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProp(String string, Object object) {
            if (this.d_evacProps.get(string) != object) {
                this.d_evacProps.put(string, object);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String string) {
            return this.d_evacProps.get(string);
        }

        public Map<String, Object> getEvacProps() {
            return this.d_evacProps;
        }
    }
}

