/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2012_1.domain.APyroObject;

public class ResultsArchive
extends APyroObject {
    static final long serialVersionUID = 1L;
    public static final Directory DIRECTORY = new Directory();
    public static final Compressed COMPRESSED = new Compressed();
    public static final Uncompressed UNCOMPRESSED = new Uncompressed();
    public static final List<IMethod> ALL_METHODS = Arrays.asList(DIRECTORY, UNCOMPRESSED, COMPRESSED);
    private final Map<String, Record> d_records = new HashMap<String, Record>();

    public void addArchive(Record record) {
        this.d_records.put(record.name, record);
        this.changedEvt(new Object[0]);
    }

    public void deleteArchive(Record record) {
        this.d_records.remove(record.name);
        this.changedEvt(new Object[0]);
    }

    public Collection<Record> getAllRecords() {
        return this.d_records.values();
    }

    public List<Record> getActiveArchives(File file) {
        ArrayList<Record> arrayList = new ArrayList<Record>(this.d_records.size());
        for (Record record : this.d_records.values()) {
            if (!record.method.exists(file, record.name)) continue;
            arrayList.add(record);
        }
        return arrayList;
    }

    public static class CompressedOptions {
        public final int compressionLevel;

        public CompressedOptions(int n) {
            this.compressionLevel = n;
        }
    }

    public static class Compressed
    extends Zipped {
        static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return Intl.intl("Store in compressed ZIP");
        }

        @Override
        protected void zip(File file, File file2, Object object) throws IOException {
            assert (object instanceof CompressedOptions);
            CompressedOptions compressedOptions = (CompressedOptions)object;
            IOUtil.zip(file, file2, true, compressedOptions.compressionLevel);
        }

        private Object readResolve() throws ObjectStreamException {
            return COMPRESSED;
        }
    }

    public static class Uncompressed
    extends Zipped {
        static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return Intl.intl("Store in uncompressed ZIP");
        }

        @Override
        protected void zip(File file, File file2, Object object) throws IOException {
            IOUtil.zip(file, file2, false, 0);
        }

        private Object readResolve() throws ObjectStreamException {
            return UNCOMPRESSED;
        }
    }

    private static abstract class Zipped
    implements IMethod {
        static final long serialVersionUID = 1L;

        protected abstract void zip(File var1, File var2, Object var3) throws IOException;

        private Zipped() {
        }

        @Override
        public void archive(File file, File file2, String string, boolean bl, Object object) throws IOException {
            File file3 = Zipped.getResultFile(file2, string);
            if (file3.exists()) {
                throw new IOException(String.format(Intl.intl("%s already exists."), file3.getAbsolutePath()));
            }
            this.zip(file, file3, object);
            IOUtil.checkZippedFile(file, file3);
            if (!bl) {
                IOUtil.delete(file);
            }
        }

        @Override
        public boolean exists(File file, String string) {
            File file2 = Zipped.getResultFile(file, string);
            return file2.exists() && file2.isFile();
        }

        protected static File getResultFile(File file, String string) {
            return new File(file, string + ".zip");
        }

        @Override
        public void restore(File file, String string, File file2, boolean bl) throws IOException {
            File file3 = Zipped.getResultFile(file, string);
            IOUtil.unzip(file3, file2);
            IOUtil.checkUnzippedFile(file3, file2);
            if (!bl) {
                IOUtil.delete(file3);
            }
        }
    }

    public static class Directory
    implements IMethod {
        static final long serialVersionUID = 1L;

        private Directory() {
        }

        @Override
        public String toString() {
            return Intl.intl("Store in new results directory");
        }

        @Override
        public void archive(File file, File file2, String string, boolean bl, Object object) throws IOException {
            File file3 = new File(file2, string);
            this.exchange(file, file3, bl);
        }

        @Override
        public void restore(File file, String string, File file2, boolean bl) throws IOException {
            File file3 = new File(file, string);
            this.exchange(file3, file2, bl);
        }

        private void exchange(File file, File file2, boolean bl) throws IOException {
            if (file2.exists()) {
                throw new IOException(String.format(Intl.intl("%s already exists."), file2.getAbsolutePath()));
            }
            if (!bl) {
                if (!file.renameTo(file2)) {
                    IOUtil.copyDir(file, file2);
                    IOUtil.delete(file);
                }
            } else {
                IOUtil.copyDir(file, file2);
            }
        }

        @Override
        public boolean exists(File file, String string) {
            File file2 = new File(file, string);
            return file2.exists() && file2.isDirectory();
        }

        private Object readResolve() throws ObjectStreamException {
            return DIRECTORY;
        }
    }

    public static interface IMethod
    extends Serializable {
        public void archive(File var1, File var2, String var3, boolean var4, Object var5) throws IOException;

        public void restore(File var1, String var2, File var3, boolean var4) throws IOException;

        public boolean exists(File var1, String var2);

        public String toString();
    }

    public static class Record
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final IMethod method;
        public final String name;
        public final long dateCreated;

        public Record(String string, IMethod iMethod, long l) {
            this.name = string;
            this.method = iMethod;
            this.dateCreated = l;
        }
    }
}

