/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridMergeUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.util.Util;

public class GridUtil {
    public static List<Pair<Grid, List<Vent>>> constructVents(Collection<? extends Grid> collection, Map<Grid, GridMergeUtil.BoundaryInfo> map, Surface surface, GridFace ... gridFaceArray) {
        ArrayList<Pair<Grid, List<Vent>>> arrayList = new ArrayList<Pair<Grid, List<Vent>>>();
        for (Grid grid : collection) {
            GridMergeUtil.BoundaryInfo boundaryInfo = map.get(grid);
            if (boundaryInfo == null) continue;
            List<Vent> list = new ArrayList();
            block1: for (Face face : boundaryInfo.faces) {
                for (GridFace gridFace : gridFaceArray) {
                    if (!GridUtil.equal(face.plane, gridFace.getPlane(grid), 1.0E-9)) continue;
                    Collection<Face> collection2 = GridUtil.divideFaces(face);
                    for (Face face2 : collection2) {
                        AABox aABox = face2.getBounds();
                        AARectangle aARectangle = AARectangle.construct(aABox.getMin(), aABox.getMax());
                        if (aARectangle == null) {
                            System.err.println("Could not construct vent face from mesh boundary.");
                            continue;
                        }
                        String string = String.format(Intl.intl("Mesh Vent: %1$s [%2$s]"), grid.getName(), gridFace.name());
                        Vent vent = new Vent(string, surface, aARectangle);
                        list.add(vent);
                    }
                    continue block1;
                }
            }
            if (list.isEmpty()) continue;
            list = Util.sort(list);
            arrayList.add(new Pair(grid, list));
        }
        return arrayList;
    }

    private static Collection<Face> divideFaces(Face face) {
        Vector3d vector3d;
        int n = Util3D.getClosestAxis(face.plane.getNormal());
        int n2 = n == 2 ? 0 : 2;
        ArrayList<LineSeg> arrayList = new ArrayList<LineSeg>();
        for (FaceLoop serializable2 : face.edgeLoops) {
            for (EdgeUse edgeUse : serializable2.edges) {
                vector3d = edgeUse.getTangent(0.0);
                int n3 = Util3D.getClosestAxis(vector3d);
                if (n3 != n2) continue;
                arrayList.add(new LineSeg(edgeUse.v1().loc, edgeUse.v2().loc));
            }
        }
        if (arrayList.isEmpty()) {
            return Arrays.asList(face);
        }
        AABox aABox = face.getBounds();
        Model model = new Model();
        model.addFace(face, 0);
        for (LineSeg lineSeg : arrayList) {
            vector3d = lineSeg.getTangent(0.0, ICurve.Orient.POSITIVE, false);
            double[] dArray = Inter3D.lineAABoxIsect(lineSeg.p1, vector3d, aABox.getMin(), aABox.getMax(), 1.0E-9);
            if (dArray == null) continue;
            Point3d point3d = lineSeg.evaluate(dArray[0]);
            Point3d point3d2 = lineSeg.evaluate(dArray[1]);
            model.addEdge(0, new LineSeg3D(point3d, point3d2));
        }
        return model.getFaces();
    }

    protected static boolean equal(Plane3d plane3d, Plane3d plane3d2, double d) {
        return plane3d.epsilonEquals(plane3d2, d) || plane3d.epsilonEquals(plane3d2.negate(), d);
    }

    public static final class GridFace
    extends Enum<GridFace> {
        public static final /* enum */ GridFace XMIN = new GridFace();
        public static final /* enum */ GridFace XMAX = new GridFace();
        public static final /* enum */ GridFace YMIN = new GridFace();
        public static final /* enum */ GridFace YMAX = new GridFace();
        public static final /* enum */ GridFace ZMIN = new GridFace();
        public static final /* enum */ GridFace ZMAX = new GridFace();
        private static final /* synthetic */ GridFace[] $VALUES;

        public static GridFace[] values() {
            return (GridFace[])$VALUES.clone();
        }

        public static GridFace valueOf(String string) {
            return Enum.valueOf(GridFace.class, string);
        }

        public Plane3d getPlane(Grid grid) {
            AABox aABox = grid.getBounds();
            switch (this) {
                case XMIN: {
                    return new Plane3d(-1.0, 0.0, 0.0, aABox.getMinX());
                }
                case XMAX: {
                    return new Plane3d(1.0, 0.0, 0.0, -aABox.getMaxX());
                }
                case YMIN: {
                    return new Plane3d(0.0, -1.0, 0.0, aABox.getMinY());
                }
                case YMAX: {
                    return new Plane3d(0.0, 1.0, 0.0, -aABox.getMaxY());
                }
                case ZMIN: {
                    return new Plane3d(0.0, 0.0, -1.0, aABox.getMinZ());
                }
                case ZMAX: {
                    return new Plane3d(0.0, 0.0, 1.0, -aABox.getMaxZ());
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new GridFace[]{XMIN, XMAX, YMIN, YMAX, ZMIN, ZMAX};
        }
    }
}

