/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomUtil {
    public static AABox getBounds(IGeom iGeom) {
        AABox aABox = new AABox();
        iGeom.getBoundingBox(aABox);
        return aABox;
    }

    public static AABox getBounds(IGeomSource iGeomSource) {
        return iGeomSource.getBounds();
    }

    public static AABox getBounds(Collection<? extends IGeomSource> collection) {
        AABox aABox = new AABox();
        for (IGeomSource iGeomSource : collection) {
            aABox.add(iGeomSource.getBounds());
        }
        return aABox;
    }

    public static UnitAABox getUnitBounds(IGeomSource iGeomSource) {
        return new UnitAABox(GeomUtil.getBounds(iGeomSource), Geometry.LU);
    }

    public static UnitAABox getUnitBounds(IGeom iGeom) {
        return new UnitAABox(GeomUtil.getBounds(iGeom), Geometry.LU);
    }

    public static boolean isUniform(Surface[] surfaceArray) {
        if (surfaceArray.length == 0) {
            return false;
        }
        Surface surface = surfaceArray[0];
        for (int i = 1; i < surfaceArray.length; ++i) {
            if (surfaceArray[i] == surface) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniform(Color[] colorArray) {
        if (colorArray.length == 0) {
            return false;
        }
        Color color = colorArray[0];
        for (int i = 1; i < colorArray.length; ++i) {
            if (theUtil.equal(color, colorArray[i])) continue;
            return false;
        }
        return true;
    }

    public static DisplayGeom convertToOutline(DisplayGeom displayGeom) {
        Serializable serializable;
        List<Pair<ICurve, Integer>> list = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.getFaceOutlines(displayGeom.geom);
        ArrayList arrayList = new ArrayList(list.size());
        PropsBuilder propsBuilder = new PropsBuilder();
        for (int i = 0; i < list.size(); ++i) {
            serializable = list.get(i);
            IPrimProps iPrimProps = displayGeom.props.get((Integer)serializable.v2);
            arrayList.add(serializable.v1);
            propsBuilder.add(iPrimProps, false);
        }
        IPropsSrc iPropsSrc = propsBuilder.finalizeProps();
        serializable = new GeomGroup(arrayList);
        return new DisplayGeom((IGeom)serializable, displayGeom.texuv, iPropsSrc);
    }

    public static boolean isCullGeom(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            return true;
        }
        if (iGeom instanceof IProxyGeom) {
            return GeomUtil.isCullGeom(((IProxyGeom)iGeom).getBase());
        }
        if (iGeom instanceof GeomGroup) {
            for (IGeom iGeom2 : ((GeomGroup)iGeom).children) {
                if (GeomUtil.isCullGeom(iGeom2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<IPolygon> toPolys(IFace iFace, double d, boolean bl) {
        ArrayList<IPolygon> arrayList = new ArrayList<IPolygon>();
        GeomUtil.toPolys(iFace, d, bl, arrayList);
        return arrayList;
    }

    public static void toPolys(IFace iFace, double d, boolean bl, List<IPolygon> list) {
        if (iFace instanceof IPolygon) {
            IPolygon iPolygon = (IPolygon)iFace;
            if (!bl || iPolygon.getNumLoops() <= 1) {
                list.add(iPolygon);
                return;
            }
        }
        list.addAll(pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.getTriangles(d, iFace));
    }
}

