/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.GeomLocator;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.util.LWIdentityHashSet;

public class GeomProximity {
    private boolean d_enabled = true;
    private final PyroMod d_domain;
    private final Map<IGeomSource, LWIdentityHashSet<IGeomSource>> d_proximityMap;
    private Set<IGeomSource> d_dirty;
    private static final IObjectFilter<FDSObject> s_holeTargetFilter = new IObjectFilter<FDSObject>(){

        @Override
        public boolean shouldFilter(FDSObject fDSObject) {
            return !(fDSObject instanceof IObstruction);
        }
    };
    private static final IObjectFilter<FDSObject> s_holeFilter = new IObjectFilter<FDSObject>(){

        @Override
        public boolean shouldFilter(FDSObject fDSObject) {
            return !(fDSObject instanceof IHole);
        }
    };

    public GeomProximity(PyroMod pyroMod) {
        this.d_domain = pyroMod;
        this.d_proximityMap = new IdentityHashMap<IGeomSource, LWIdentityHashSet<IGeomSource>>();
        this.d_dirty = GeomProximity.newDirtySet();
    }

    private static Set<IGeomSource> newDirtySet() {
        return new LinkedIdentityHashSet<IGeomSource>();
    }

    public void setEnabled(boolean bl) {
        if (bl == this.d_enabled) {
            return;
        }
        this.d_enabled = bl;
        if (!this.d_enabled) {
            this.d_proximityMap.clear();
            this.d_dirty = GeomProximity.newDirtySet();
        }
    }

    public void add(IGeomSource iGeomSource) {
        if (!this.d_enabled) {
            return;
        }
        this.d_dirty.add(iGeomSource);
    }

    public void remove(IGeomSource iGeomSource) {
        if (!this.d_enabled) {
            return;
        }
        this.disconnect(iGeomSource);
        this.d_dirty.remove(iGeomSource);
    }

    public void update(IGeomSource iGeomSource) {
        if (!this.d_enabled) {
            return;
        }
        this.disconnect(iGeomSource);
        this.d_dirty.add(iGeomSource);
    }

    private void disconnect(IGeomSource iGeomSource) {
        LWIdentityHashSet<IGeomSource> lWIdentityHashSet = this.d_proximityMap.get(iGeomSource);
        if (lWIdentityHashSet == null) {
            return;
        }
        for (IGeomSource iGeomSource2 : lWIdentityHashSet) {
            LWIdentityHashSet<IGeomSource> lWIdentityHashSet2 = this.d_proximityMap.get(iGeomSource2);
            assert (lWIdentityHashSet2 != null);
            lWIdentityHashSet2.remove(iGeomSource);
            if (lWIdentityHashSet2.isEmpty()) {
                this.d_proximityMap.remove(iGeomSource2);
            }
            this.fireUpdate(iGeomSource2);
        }
        this.d_proximityMap.remove(iGeomSource);
        this.fireUpdate(iGeomSource);
    }

    private void fireUpdate(IGeomSource iGeomSource) {
        if (iGeomSource instanceof IObstruction) {
            ((IObstruction)iGeomSource).changedEvt(PyroMod.EVT_APPEARANCE);
        }
    }

    public void update() {
        if (this.d_dirty.isEmpty()) {
            return;
        }
        this.d_domain.getGeomLocator().updateDirty();
        theTimer theTimer2 = new theTimer();
        this.d_domain.pauseUpdates();
        for (IGeomSource iGeomSource : this.d_dirty) {
            if (!(iGeomSource instanceof FDSObject)) continue;
            FDSObject fDSObject = (FDSObject)iGeomSource;
            Collection<? extends IGeomSource> collection = null;
            if (fDSObject instanceof IHole) {
                collection = this.findHoleTargets(fDSObject);
            } else if (fDSObject instanceof IObstruction) {
                collection = this.findNearHoles(fDSObject);
            }
            if (collection == null || collection.isEmpty()) continue;
            LWIdentityHashSet lWIdentityHashSet = this.getNearObjsForAdd(fDSObject);
            lWIdentityHashSet.addAll(collection);
            for (IGeomSource iGeomSource2 : collection) {
                this.getNearObjsForAdd(iGeomSource2).add(fDSObject);
                this.fireUpdate(iGeomSource2);
            }
            this.fireUpdate(fDSObject);
        }
        this.d_dirty = GeomProximity.newDirtySet();
        System.out.println("updated geom prox " + theTimer2.curr());
        this.d_domain.resumeUpdates();
    }

    private Collection<? extends IGeomSource> findHoleTargets(IGeomSource iGeomSource) {
        return this.findNearObjs(iGeomSource, s_holeTargetFilter);
    }

    private Collection<? extends IGeomSource> findNearHoles(IGeomSource iGeomSource) {
        return this.findNearObjs(iGeomSource, s_holeFilter);
    }

    private Collection<FDSObject> findNearObjs(IGeomSource iGeomSource, IObjectFilter<FDSObject> iObjectFilter) {
        AABox aABox = GeomUtil.getBounds(iGeomSource);
        GeomLocator.Collector<FDSObject> collector = new GeomLocator.Collector<FDSObject>(FDSObject.class, iObjectFilter);
        this.d_domain.getGeomLocator().findf(aABox.toAABoxf(), collector, true);
        return collector.coll;
    }

    private LWIdentityHashSet getNearObjsForAdd(IGeomSource iGeomSource) {
        LWIdentityHashSet<IGeomSource> lWIdentityHashSet = this.d_proximityMap.get(iGeomSource);
        if (lWIdentityHashSet == null) {
            lWIdentityHashSet = new LWIdentityHashSet();
            this.d_proximityMap.put(iGeomSource, lWIdentityHashSet);
        }
        return lWIdentityHashSet;
    }

    public Collection<? extends IGeomSource> getNearObjs(IGeomSource iGeomSource) {
        LWIdentityHashSet<IGeomSource> lWIdentityHashSet = this.d_proximityMap.get(iGeomSource);
        if (lWIdentityHashSet == null) {
            return Collections.EMPTY_LIST;
        }
        return lWIdentityHashSet;
    }
}

