/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABoxf;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.RTreef;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.CollResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;

public class GeomLocator {
    private Set<IGeomSource> d_dirtyGeom = GeomLocator.newDirtySet();
    private final RTreef<IGeomSource> d_finite = new RTreef(2, 16);
    private final Set<IGeomSource> d_infinite = new LinkedIdentityHashSet<IGeomSource>();

    private static Set<IGeomSource> newDirtySet() {
        return new LinkedIdentityHashSet<IGeomSource>();
    }

    public void add(IGeomSource iGeomSource) {
        this.d_dirtyGeom.add(iGeomSource);
    }

    public void remove(IGeomSource iGeomSource) {
        this.d_finite.remove(iGeomSource);
        this.d_infinite.remove(iGeomSource);
        this.d_dirtyGeom.remove(iGeomSource);
    }

    public void update(IGeomSource iGeomSource) {
        this.d_dirtyGeom.add(iGeomSource);
    }

    public void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        theTimer theTimer2 = new theTimer();
        for (IGeomSource iGeomSource : this.d_dirtyGeom) {
            this.removeGeometry(iGeomSource);
            this.addGeometry(iGeomSource);
        }
        this.d_dirtyGeom = GeomLocator.newDirtySet();
        System.out.println("updated geom search " + theTimer2.curr());
    }

    private void addGeometry(IGeomSource iGeomSource) {
        AABox aABox = iGeomSource.getBounds();
        if (aABox.isInfinite()) {
            this.d_infinite.add(iGeomSource);
        } else {
            this.d_finite.insert(aABox.toAABoxf(), iGeomSource);
        }
    }

    private void addGeometry(Collection<? extends IGeomSource> collection) {
        for (IGeomSource iGeomSource : collection) {
            this.addGeometry(iGeomSource);
        }
    }

    private boolean removeGeometry(IGeomSource iGeomSource) {
        this.d_finite.remove(iGeomSource);
        this.d_infinite.remove(iGeomSource);
        return true;
    }

    private boolean removeGeometry(Collection<? extends IGeomSource> collection) {
        boolean bl = true;
        for (IGeomSource iGeomSource : collection) {
            bl &= this.removeGeometry(iGeomSource);
        }
        return bl;
    }

    public void find(final ITest<AABox> iTest, IResult<? super IGeomSource> iResult, boolean bl) {
        ITest<AABoxf> iTest2 = new ITest<AABoxf>(){

            @Override
            public Containment test(AABoxf aABoxf) {
                return iTest.test(new AABox(aABoxf.getMinX(), aABoxf.getMinY(), aABoxf.getMinZ(), aABoxf.getMaxX(), aABoxf.getMaxY(), aABoxf.getMaxZ()));
            }
        };
        this.findf(iTest2, iResult, bl);
    }

    public void findf(ITest<AABoxf> iTest, IResult<? super IGeomSource> iResult, boolean bl) {
        this.updateDirty();
        this.find(iTest, iResult, this.d_finite, bl);
        this.find(iResult, this.d_infinite, bl);
    }

    private void find(ITest<AABoxf> iTest, final IResult<? super IGeomSource> iResult, RTreef<IGeomSource> rTreef, boolean bl) {
        IResult<IGeomSource> iResult2 = iResult;
        if (!bl) {
            iResult2 = new IResult<IGeomSource>(){

                @Override
                public void mark(IGeomSource iGeomSource, Containment containment) {
                    if (!iGeomSource.isVisible()) {
                        return;
                    }
                    iResult.mark(iGeomSource, containment);
                }
            };
        }
        rTreef.find(iTest, iResult2);
    }

    private void find(IResult<? super IGeomSource> iResult, Set<IGeomSource> set, boolean bl) {
        for (IGeomSource iGeomSource : set) {
            if (!bl && !iGeomSource.isVisible()) continue;
            iResult.mark(iGeomSource, Containment.INTERSECTS);
        }
    }

    public static class Collector<T extends IGeomSource>
    extends CollResult<IGeomSource, T> {
        public Collector(Class<T> clazz) {
            this(clazz, (IObjectFilter<T>)AcceptAllFilter.INSTANCE);
        }

        public Collector(Class<T> clazz, IObjectFilter<T> iObjectFilter) {
            super(clazz, iObjectFilter);
        }
    }
}

