/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.Comparator;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.texture.ModelImage;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Floor
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    private UnitDouble d_elevation;
    private UnitDouble d_slabThickness;
    private UnitDouble d_wallHeight;
    private ModelImage d_bgImage;

    public Floor(String string) {
        this(string, new UnitDouble(0.0, SI.METER), new UnitDouble(0.25, SI.METER), new UnitDouble(2.75, SI.METER), null);
    }

    public Floor(String string, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, ModelImage modelImage) {
        super(string);
        this.d_elevation = unitDouble;
        this.d_slabThickness = unitDouble2;
        this.d_wallHeight = unitDouble3;
        this.setBgImage(modelImage);
    }

    public void setElevation(UnitDouble unitDouble) {
        if (this.d_elevation.equals(unitDouble)) {
            return;
        }
        this.d_elevation = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getElevation() {
        return this.d_elevation;
    }

    public void setSlabThickness(UnitDouble unitDouble) {
        if (this.d_slabThickness.equals(unitDouble)) {
            return;
        }
        this.d_slabThickness = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getSlabThickness() {
        return this.d_slabThickness;
    }

    public void setWallHeight(UnitDouble unitDouble) {
        if (this.d_wallHeight.equals(unitDouble)) {
            return;
        }
        this.d_wallHeight = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getWallHeight() {
        return this.d_wallHeight;
    }

    public UnitDouble getCeilingLoc() {
        return this.d_elevation.add(this.d_wallHeight);
    }

    public UnitDouble getSlabBottom() {
        return this.d_elevation.sub(this.d_slabThickness);
    }

    public void setBgImage(ModelImage modelImage) {
        this.d_bgImage = modelImage;
        if (this.d_bgImage != null) {
            BGImageXform bGImageXform = this.d_bgImage.getLWTransform();
            bGImageXform = new BGImageXform(bGImageXform.anchorImage, new Point3d(bGImageXform.anchorModel.x, bGImageXform.anchorModel.y, this.d_elevation.getValue(SI.METER)), bGImageXform.aImage, bGImageXform.bImage, bGImageXform.distABModel, bGImageXform.abAngle);
            this.d_bgImage.setLWTransform(bGImageXform);
        }
        this.changedEvt(new Object[0]);
    }

    public ModelImage getBgImage() {
        return this.d_bgImage;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof Floor && super.equals(object) && ((Floor)object).d_elevation.equals(this.d_elevation) && ((Floor)object).d_slabThickness.equals(this.d_slabThickness) && ((Floor)object).d_wallHeight.equals(this.d_wallHeight) && theUtil.equal(((Floor)object).d_bgImage, this.d_bgImage);
    }

    public boolean intersects(Floor floor) {
        double d = this.getSlabBottom().getValue(Geometry.LU);
        double d2 = this.getCeilingLoc().getValue(Geometry.LU);
        double d3 = floor.getSlabBottom().getValue(Geometry.LU);
        double d4 = floor.getCeilingLoc().getValue(Geometry.LU);
        return theUtil.lt(d3, d2, 1.0E-9) && theUtil.gt(d4, d, 1.0E-9);
    }

    public static class CompareLevel
    implements Comparator<Floor> {
        @Override
        public int compare(Floor floor, Floor floor2) {
            return floor.d_elevation.compareTo(floor2.d_elevation);
        }
    }
}

