/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;
    public static final ExSpec[] MIXFRAC_EXSPECS;
    public static final Map<String, ExSpec> PREDEFINED;

    public ExSpecList() {
        this(Intl.intl("Extra Species"));
    }

    public ExSpecList(String string) {
        super(string, ExSpec.class);
    }

    public List<String> getPredefinedSpeciesNamesFree() {
        ArrayList<String> arrayList = new ArrayList<String>(PREDEFINED.keySet());
        for (ExSpec exSpec : this.flatten()) {
            String string = exSpec.getName();
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static boolean isPredefinedSpecies(String string) {
        return PREDEFINED.containsKey(string);
    }

    public static ExSpec getPredefinedSpecies(String string) {
        assert (ExSpecList.isPredefinedSpecies(string));
        return PREDEFINED.get(string);
    }

    @Override
    public boolean add(IPyroObject iPyroObject) {
        if (iPyroObject instanceof ExSpec && ((ExSpec)iPyroObject).isMixFracOnly()) {
            return false;
        }
        return super.add(iPyroObject);
    }

    @Override
    public boolean remove(IPyroObject iPyroObject) {
        if (iPyroObject instanceof ExSpec && ((ExSpec)iPyroObject).isMixFracOnly()) {
            return false;
        }
        return super.remove(iPyroObject);
    }

    static {
        PREDEFINED = new LinkedHashMap<String, ExSpec>();
        for (Predefined predefined : Predefined.values()) {
            PREDEFINED.put(predefined.spec.getName(), predefined.spec);
        }
        Enum[] enumArray = MixFrac.values();
        MIXFRAC_EXSPECS = new ExSpec[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            ExSpecList.MIXFRAC_EXSPECS[i] = ((MixFrac)enumArray[i]).spec;
        }
    }

    public static enum MixFrac {
        FUEL(1, "fuel"),
        OXYGEN(2, "oxygen"),
        NITROGEN(3, "nitrogen"),
        WATER_VAPOR(4, "water vapor"),
        CARBON_DIOXIDE(5, "carbon dioxide"),
        CARBON_MONOXIDE(6, "carbon monoxide"),
        HYDROGEN(7, "hydrogen"),
        SOOT(8, "soot"),
        OTHER(9, "other");

        public final ExSpec spec;
        public final String name;

        private MixFrac(int n2, String string2) {
            this.spec = new ExSpec(n2);
            this.name = string2;
        }
    }

    public static enum Predefined {
        AIR("AIR", 29.0, 3.711, 78.6),
        ARGON("ARGON", 40.0, 3.42, 124.0),
        CARBON_DIOXIDE("CARBON DIOXIDE", 44.0, 3.941, 195.2),
        CARBON_MONOXIDE("CARBON MONOXIDE", 28.0, 3.69, 91.7),
        ETHANOL("ETHANOL", 46.0, 4.53, 362.6),
        ETHYLENE("ETHYLENE", 28.0, 4.163, 224.7),
        HELIUM("HELIUM", 4.0, 2.551, 10.22),
        HYDROGEN("HYDROGEN", 2.0, 2.827, 59.7),
        HYDROGEN_BROMIDE("HYDROGEN BROMIDE", 81.0, 3.353, 449.0),
        HYDROGEN_CHLORIDE("HYDROGEN CHLORIDE", 36.0, 3.339, 344.7),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", 26.0, 3.63, 569.1),
        HYDROGEN_FLOURIDE("HYDROGEN FLOURIDE", 20.0, 3.148, 330.0),
        METHANE("METHANE", 16.0, 3.758, 148.6),
        METHANOL("METHANOL", 32.0, 3.626, 481.8),
        N_HEXANE("N-HEXANE", 86.0, 4.524, 199.41),
        N_HEPTANE("N-HEPTANE", 100.0, 4.701, 205.75),
        N_OCTANE("N-OCTANE", 114.0, 4.892, 231.16),
        N_DECANE("N-DECANE", 142.0, 5.233, 226.46),
        NITROGEN("NITROGEN", 28.0, 3.798, 71.4),
        OXYGEN("OXYGEN", 32.0, 3.467, 106.7),
        PROPANE("PROPANE", 44.0, 5.118, 237.1),
        TOLUENE("TOLUENE", 92.0, 5.698, 480.0),
        WATER_VAPOR("WATER VAPOR", 18.0, 2.641, 809.1);

        public final ExSpec spec;

        private Predefined(String string2, double d, double d2, double d3) {
            this.spec = new ExSpec(string2, true);
            this.spec.setMolWt(new UnitDouble(d, SI.GRAM.divide(SI.MOLE)));
            this.spec.setDNSLJ(new UnitDouble(d2, NonSI.ANGSTROM), new UnitDouble(d3, SI.KELVIN));
        }

        public String getName() {
            return this.spec.getName();
        }
    }
}

