/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class ExSpec
extends NamedPyroObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int ID_NONE = 0;
    public static final int DNS_NONE = 0;
    public static final int DNS_LJ = 1;
    public static final int DNS_ALT = 2;
    private int d_id;
    private String d_fyi;
    private boolean d_isPredefined;
    private double d_massFrac0;
    private UnitDouble d_molWt;
    private boolean d_absorb;
    private int d_dnsType;
    private UnitDouble d_sigma;
    private UnitDouble d_epsilonK;
    private UnitDouble d_visc;
    private UnitDouble d_con;
    private UnitDouble d_diff;
    private UnitDouble d_massExtCoeff;

    public ExSpec(String string, boolean bl) {
        this(string, bl, 0);
    }

    protected ExSpec(String string, boolean bl, int n) {
        super(string);
        SIUS sIUS = SIUS.getInstance();
        this.d_id = n;
        this.d_isPredefined = bl;
        this.d_massFrac0 = 0.0;
        this.d_molWt = new UnitDouble(29.0, sIUS.getMolecularWeightUnit());
        this.d_absorb = false;
        this.d_dnsType = 0;
        this.d_sigma = new UnitDouble(0.0, sIUS.getLJSigmaUnit());
        this.d_epsilonK = new UnitDouble(0.0, sIUS.getLJEpsilonKUnit());
        this.d_visc = new UnitDouble(0.0, sIUS.getViscosityUnit());
        this.d_con = new UnitDouble(0.0, sIUS.getConductivityUnit());
        this.d_diff = new UnitDouble(0.0, sIUS.getDiffusionUnit());
        this.d_massExtCoeff = null;
    }

    public ExSpec(int n) {
        this("", false, n);
    }

    public ExSpec(ExSpec exSpec) {
        this.setName(exSpec.getName());
        this.d_id = exSpec.d_id;
        this.d_isPredefined = exSpec.d_isPredefined;
        this.d_massFrac0 = exSpec.d_massFrac0;
        this.d_molWt = exSpec.d_molWt;
        this.d_absorb = exSpec.d_absorb;
        this.d_dnsType = exSpec.d_dnsType;
        this.d_sigma = exSpec.d_sigma;
        this.d_epsilonK = exSpec.d_epsilonK;
        this.d_visc = exSpec.d_visc;
        this.d_con = exSpec.d_con;
        this.d_diff = exSpec.d_diff;
        this.d_massExtCoeff = exSpec.d_massExtCoeff;
    }

    public int hashCode() {
        if (this.d_id == 0) {
            return super.hashCode();
        }
        return 2330621 + this.d_id;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_id != 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream) {
            int n = ((PyroSimObjectInputStream)objectInputStream).getVersion();
            if (n < 28 && this.d_massExtCoeff != null && this.d_massExtCoeff.getValueNoUnit() == 0.0) {
                this.d_massExtCoeff = null;
            }
            if (n < 30) {
                this.d_id = 0;
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.d_id != 0) {
            for (ExSpec exSpec : ExSpecList.MIXFRAC_EXSPECS) {
                if (exSpec.d_id != this.d_id) continue;
                return exSpec;
            }
        }
        return this;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        return new ExSpec(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExSpec)) {
            return false;
        }
        ExSpec exSpec = (ExSpec)object;
        if (this.d_id != 0) {
            return exSpec.d_id == this.d_id;
        }
        return this.getName().equals(exSpec.getName()) && this.d_isPredefined == exSpec.d_isPredefined && this.d_massFrac0 == exSpec.d_massFrac0 && this.d_molWt.equals(exSpec.d_molWt) && this.d_absorb == exSpec.d_absorb && this.d_dnsType == exSpec.d_dnsType && this.d_sigma.equals(exSpec.d_sigma) && this.d_epsilonK.equals(exSpec.d_epsilonK) && this.d_visc.equals(exSpec.d_visc) && this.d_con.equals(exSpec.d_con) && this.d_diff.equals(exSpec.d_diff) && theUtil.equal(this.d_massExtCoeff, exSpec.d_massExtCoeff);
    }

    public int getID() {
        return this.d_id;
    }

    public ExSpecList.MixFrac getMFSpec() {
        if (this.d_id == 0) {
            return null;
        }
        for (ExSpecList.MixFrac mixFrac : ExSpecList.MixFrac.values()) {
            if (mixFrac.spec.getID() != this.d_id) continue;
            return mixFrac;
        }
        return null;
    }

    @Override
    public String getName() {
        ExSpecList.MixFrac mixFrac = this.getMFSpec();
        if (mixFrac == null) {
            return super.getName();
        }
        return mixFrac.name;
    }

    public boolean getAbsorb() {
        return this.d_absorb;
    }

    public void setAbsorb(boolean bl) {
        if (this.d_absorb != bl) {
            this.d_absorb = bl;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getConductivity() {
        return this.d_con;
    }

    public UnitDouble getDiffusivity() {
        return this.d_diff;
    }

    public UnitDouble getEpsilonK() {
        return this.d_epsilonK;
    }

    public boolean isPredefined() {
        return this.d_isPredefined;
    }

    public double getMassFrac0() {
        return this.d_massFrac0;
    }

    public UnitDouble getMolWt() {
        return this.d_molWt;
    }

    public UnitDouble getSigma() {
        return this.d_sigma;
    }

    public UnitDouble getViscosity() {
        return this.d_visc;
    }

    public int getDNSType() {
        return this.d_dnsType;
    }

    public void setMassFraction0(double d) {
        this.d_massFrac0 = d;
        this.changedEvt(new Object[0]);
    }

    public void setMolWt(UnitDouble unitDouble) {
        this.d_molWt = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public void setDNSNone() {
        this.d_dnsType = 0;
        this.changedEvt(new Object[0]);
    }

    public void setDNSLJ(UnitDouble unitDouble, UnitDouble unitDouble2) {
        this.d_dnsType = 1;
        this.d_sigma = unitDouble;
        this.d_epsilonK = unitDouble2;
        this.changedEvt(new Object[0]);
    }

    public void setDNSAlt(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        this.d_dnsType = 2;
        this.d_visc = unitDouble;
        this.d_con = unitDouble2;
        this.d_diff = unitDouble3;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getMassExtinctionCoeff() {
        return this.d_massExtCoeff;
    }

    public void setMassExtinctionCoeff(UnitDouble unitDouble) {
        this.d_massExtCoeff = unitDouble;
        this.changedEvt(new Object[0]);
    }
}

