/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class Composite<DataT extends IPyroObject>
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object NON_UNIFORM = new Object();
    public static final Object NOT_SUPPORTED = new Object();
    private Class<DataT> d_type;
    private Set<IPyroObject> d_members;

    public Composite(String string, Class<DataT> clazz) {
        super(string);
        this.d_type = clazz;
        this.d_members = new LinkedIdentityHashSet<IPyroObject>();
    }

    public Class<DataT> getType() {
        return this.d_type;
    }

    protected boolean addDefault(DataT DataT) {
        if (this.get(Util.getName(DataT)) == null) {
            this.add((IPyroObject)DataT);
            return true;
        }
        return false;
    }

    public Composite newGroup(String string) {
        Composite composite = (Composite)super.clone();
        composite.d_members = new LinkedIdentityHashSet<IPyroObject>();
        composite.setName(string);
        return composite;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public Composite<DataT> clone() {
        return this.clone(true);
    }

    public Composite<DataT> clone(boolean bl) {
        Composite composite = (Composite)super.clone();
        if (bl) {
            composite.d_members = new LinkedIdentityHashSet<IPyroObject>(this.d_members.size());
            for (IPyroObject iPyroObject : this.d_members) {
                IPyroObject iPyroObject2 = (IPyroObject)iPyroObject.clone();
                iPyroObject2.setDomain(null, composite);
                composite.d_members.add(iPyroObject2);
            }
        } else {
            composite.d_members = new LinkedIdentityHashSet<IPyroObject>();
        }
        return composite;
    }

    public DataT get(String string) {
        return this.find(string, this.d_type, true);
    }

    public List<DataT> getAll(String string) {
        return this.findAll(string, this.d_type, true);
    }

    public <T extends IPyroObject> T find(String string, Class<T> clazz, boolean bl) {
        Collection<T> collection = bl ? ((APyroObject)this).flatten(clazz) : this.getMembers(clazz);
        for (IPyroObject iPyroObject : collection) {
            if (!Util.getName(iPyroObject).equals(string)) continue;
            return (T)iPyroObject;
        }
        return null;
    }

    public <T extends IPyroObject> List<T> findAll(String string, Class<T> clazz, boolean bl) {
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        Collection<T> collection = bl ? ((APyroObject)this).flatten(clazz) : this.getMembers(clazz);
        for (IPyroObject iPyroObject : collection) {
            if (!Util.getName(iPyroObject).equals(string)) continue;
            arrayList.add(iPyroObject);
        }
        return arrayList;
    }

    public boolean accept(IPyroObject iPyroObject) {
        return iPyroObject instanceof Composite ? this.d_type.isAssignableFrom(((Composite)iPyroObject).getType()) : this.d_type.isInstance(iPyroObject);
    }

    public void reorder(Collection<? extends IPyroObject> collection) {
        assert (this.d_members.containsAll(collection) && this.d_members.size() == collection.size());
        this.d_members.clear();
        this.d_members.addAll(collection);
        this.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
    }

    public boolean containsAny(Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            if (!this.d_members.contains(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    public void insert(Collection<? extends IPyroObject> collection, int n) {
        if (collection.isEmpty()) {
            return;
        }
        assert (!this.containsAny(collection));
        if (n == this.d_members.size()) {
            this.addAll(collection);
            return;
        }
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(this.d_members);
        arrayList.addAll(n, collection);
        this.d_members.clear();
        this.d_members.addAll(arrayList);
        this.addChildren(collection);
    }

    public void insert(IPyroObject[] iPyroObjectArray, int[] nArray) {
        if (iPyroObjectArray.length == 0) {
            return;
        }
        assert (!this.containsAny(Arrays.asList(iPyroObjectArray)));
        assert (iPyroObjectArray.length <= nArray.length);
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(this.d_members);
        for (int i = 0; i < iPyroObjectArray.length; ++i) {
            arrayList.add(nArray[i], iPyroObjectArray[i]);
        }
        this.d_members.clear();
        this.d_members.addAll(arrayList);
        this.addChildren(iPyroObjectArray);
    }

    public int indexOf(IPyroObject iPyroObject) {
        int n = 0;
        for (IPyroObject iPyroObject2 : this.d_members) {
            if (iPyroObject2 == iPyroObject) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> iObjectProp) {
        return Composite.getProperty(iObjectProp, this.d_members);
    }

    public static <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> iObjectProp, Collection<? extends IPyroObject> collection) {
        if (collection.isEmpty()) {
            return NOT_SUPPORTED;
        }
        Object object = NOT_SUPPORTED;
        for (IPyroObject iPyroObject : collection) {
            Object object2;
            if (iObjectProp.getType().isInstance(iPyroObject)) {
                IPyroObject iPyroObject2 = iPyroObject;
                object2 = iObjectProp.get(iPyroObject2);
            } else {
                if (!(iPyroObject instanceof Composite)) continue;
                object2 = ((Composite)iPyroObject).getProperty(iObjectProp);
            }
            if (object2 == NON_UNIFORM) {
                return NON_UNIFORM;
            }
            if (object2 == NOT_SUPPORTED) continue;
            if (object == NOT_SUPPORTED) {
                object = object2;
                continue;
            }
            if (iObjectProp.equal(object, object2)) continue;
            return NON_UNIFORM;
        }
        return object;
    }

    public <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> iObjectProp, PropT PropT) {
        this.pauseUpdates();
        Composite.setProperty(iObjectProp, PropT, this.d_members);
        this.resumeUpdates();
    }

    public static <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> iObjectProp, PropT PropT, Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            if (iObjectProp.getType().isInstance(iPyroObject)) {
                iObjectProp.set(iPyroObject, PropT);
                continue;
            }
            if (!(iPyroObject instanceof Composite)) continue;
            ((Composite)iPyroObject).setProperty(iObjectProp, PropT);
        }
    }

    public boolean contains(IPyroObject iPyroObject) {
        return this.d_members.contains(iPyroObject);
    }

    public boolean containsDeep(IPyroObject iPyroObject) {
        if (this.d_members.contains(iPyroObject)) {
            return true;
        }
        for (Composite composite : this.getNodes()) {
            if (!composite.containsDeep(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    public Collection<IPyroObject> getMembers() {
        return this.d_members;
    }

    public Collection<Composite> getNodes() {
        return this.getMembers(Composite.class);
    }

    public Collection<DataT> flatten() {
        return ((APyroObject)this).flatten(this.d_type);
    }

    public Collection<DataT> flatten(IObjectFilter<DataT> iObjectFilter) {
        return Hierarchy.flatten(this.d_members, this.d_type, iObjectFilter);
    }

    public Collection<Composite> flattenNodes() {
        return ((APyroObject)this).flatten(Composite.class);
    }

    public void clear() {
        this.pauseUpdates();
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(this.d_members);
        this.d_members.clear();
        this.removeChildren((Collection)arrayList);
        this.resumeUpdates();
    }

    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public void prune() {
        this.pauseUpdates();
        for (Composite composite : new ArrayList<Composite>(this.getNodes())) {
            composite.prune();
            if (!composite.isEmpty()) continue;
            this.remove(composite);
        }
        this.resumeUpdates();
    }

    public Collection<? extends IPyroObject> getChildren() {
        return this.d_members;
    }

    public boolean add(IPyroObject iPyroObject) {
        if (!this.accept(iPyroObject)) {
            System.err.println("Adding non-accepted object to group: [group=" + this.getName() + "], [object=" + Util.getName(iPyroObject) + "]");
        }
        boolean bl = this.d_members.add(iPyroObject);
        this.addChild(iPyroObject);
        return bl;
    }

    public boolean addAll(Collection<? extends IPyroObject> collection) {
        boolean bl = true;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : collection) {
            bl &= this.add(iPyroObject);
        }
        this.resumeUpdates();
        return bl;
    }

    public boolean remove(IPyroObject iPyroObject) {
        boolean bl = this.d_members.remove(iPyroObject);
        if (bl) {
            this.removeChild(iPyroObject);
        }
        return bl;
    }

    public boolean removeAll(Collection<? extends IPyroObject> collection) {
        boolean bl = false;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : collection) {
            bl |= this.remove(iPyroObject);
        }
        this.resumeUpdates();
        return bl;
    }

    protected <T extends IPyroObject> void addChild(T t) {
        t.setDomain((PyroMod)this.getDomain(), this);
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
    }

    protected <T extends IPyroObject> void addChildren(T ... TArray) {
        this.addChildren((Collection<T>)Arrays.asList(TArray));
    }

    protected <T extends IPyroObject> void addChildren(Collection<T> collection) {
        this.pauseUpdates();
        for (IPyroObject iPyroObject : collection) {
            iPyroObject.setDomain((PyroMod)this.getDomain(), this);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
        this.resumeUpdates();
    }

    protected <T extends IPyroObject> void removeChild(T t) {
        t.setDomain(null, null);
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
    }

    protected <T extends IPyroObject> void removeChildren(T ... TArray) {
        this.removeChildren((Collection<T>)Arrays.asList(TArray));
    }

    protected <T extends IPyroObject> void removeChildren(Collection<T> collection) {
        this.pauseUpdates();
        for (IPyroObject iPyroObject : collection) {
            iPyroObject.setDomain(null, null);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
        this.resumeUpdates();
    }

    public static abstract class AObjectProp<ObjT, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final Class<ObjT> d_type;

        public AObjectProp(Class<ObjT> clazz) {
            this.d_type = clazz;
        }

        @Override
        public Class<ObjT> getType() {
            return this.d_type;
        }

        @Override
        public boolean equal(PropT PropT, PropT PropT2) {
            return theUtil.equal(PropT, PropT2);
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public Class<ObjT> getType();

        public void set(ObjT var1, PropT var2);

        public Object get(ObjT var1);

        public boolean equal(PropT var1, PropT var2);
    }
}

