/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.io.ExampleFileFilter;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class TextureDBMgr {
    private static final long serialVersionUID = 1L;
    private static final String TEX_DIR_NAME = "textures";
    private static final String INFO_EXTN = ".xml";
    private File d_dbDir;
    private TextureDB d_db;

    public TextureDBMgr() {
        this(null);
    }

    public TextureDBMgr(File file) {
        this.d_dbDir = file;
        this.init();
    }

    private void init() {
        this.d_db = new TextureDB();
        File file = this.getTexDir();
        if (file != null) {
            this.scanDir(file);
        }
    }

    public TextureDB getDatabase() {
        return this.d_db;
    }

    public FileFilter[] getFileFilters() {
        return new FileFilter[]{new ExampleFileFilter(new String[]{"bmp", "gif", "jpg", "jpeg", "png"}, "All Supported Formats"), new ExampleFileFilter(new String[]{"bmp"}, "Windows Bitmap"), new ExampleFileFilter(new String[]{"gif"}, "Graphics Interchange Format"), new ExampleFileFilter(new String[]{"jpg", "jpeg"}, "JPEG File Interchange Format"), new ExampleFileFilter(new String[]{"png"}, "Portable Network Graphics")};
    }

    public void setTextureDB(TextureDB textureDB) {
        Serializable serializable;
        Texture texture;
        if (textureDB == this.d_db) {
            return;
        }
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(textureDB.names());
        for (String string : this.d_db.names()) {
            texture = textureDB.getTexture(string);
            serializable = textureDB.getDefaultInfo(string);
            if (texture == null) {
                textureDB.setTexture(string, this.d_db.getTexture(string));
            }
            if (serializable != null) continue;
            textureDB.setDefaultInfo(string, this.d_db.getDefaultInfo(string));
        }
        for (String string : arrayList) {
            File file;
            texture = this.d_db.getTexture(string);
            serializable = textureDB.getTexture(string);
            TextureInfo textureInfo = textureDB.getDefaultInfo(string);
            assert (serializable != null);
            if (textureInfo == null) {
                textureInfo = new TextureInfo(string);
                textureDB.setDefaultInfo(string, textureInfo);
            }
            if ((file = this.getTexDir()) != null && texture == null) {
                File file2 = new File(file, string);
                if (!((Texture)serializable).getImage().save(file2.getAbsolutePath())) continue;
                Image image = Image.loadUncached(file2.getAbsolutePath());
                Texture texture2 = new Texture(string, image);
                textureDB.setTexture(string, texture2);
                TextureDBMgr.store(file, string, textureInfo);
                continue;
            }
            if ((texture == null || texture.getImage().isCached() || !((Texture)serializable).getImage().isCached() || !TextureDBMgr.sudoCompare(texture.getImage(), ((Texture)serializable).getImage())) && (texture == null || ((Texture)serializable).isValid())) continue;
            textureDB.setTexture(string, texture);
        }
        this.d_db = textureDB;
    }

    private static boolean sudoCompare(Image image, Image image2) {
        return TextureDBMgr.size(image) == TextureDBMgr.size(image2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long size(Image image) {
        if (image.isCached()) {
            return image.getBuffer().capacity();
        }
        File file = new File(image.getFilename());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long l = fileInputStream.getChannel().size();
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public File getTexDir() {
        if (this.d_dbDir == null) {
            return null;
        }
        File file = new File(this.d_dbDir, TEX_DIR_NAME);
        if (!file.isDirectory()) {
            if (file.exists()) {
                file.delete();
            }
            file.mkdir();
        }
        return file;
    }

    public void setDefaultInfo(String string, TextureInfo textureInfo) {
        this.d_db.setDefaultInfo(string, textureInfo);
        File file = this.getTexDir();
        if (file != null) {
            this.store(file, string);
        }
    }

    public boolean contains(File file) {
        String string = file.getName();
        return this.d_db.names().contains(string);
    }

    public TextureInfo addToDB(File file) throws IOException {
        Image image;
        ILegacy_2012_1 iLegacy_2012_1;
        Comparable<File> comparable;
        String string = file.getName();
        if (this.d_db.names().contains(string)) {
            return this.d_db.getDefaultInfo(string);
        }
        File file2 = this.getTexDir();
        if (file2 != null) {
            comparable = new File(this.getTexDir(), string);
            iLegacy_2012_1 = Image.load(file.getAbsolutePath());
            image = iLegacy_2012_1 != null && iLegacy_2012_1.save(comparable.getAbsolutePath()) ? Image.loadUncached(comparable.getAbsolutePath()) : Image.loadUncached(file.getAbsolutePath());
        } else {
            image = Image.loadUncached(file.getAbsolutePath());
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        if (n > n2) {
            comparable = new UnitDouble(1.0, SI.METER);
            iLegacy_2012_1 = new UnitDouble((double)n2 / (double)n, SI.METER);
        } else if (n2 > n) {
            iLegacy_2012_1 = new UnitDouble(1.0, SI.METER);
            comparable = new UnitDouble((double)n / (double)n2, SI.METER);
        } else {
            comparable = new UnitDouble(1.0, SI.METER);
            iLegacy_2012_1 = new UnitDouble(1.0, SI.METER);
        }
        TextureInfo textureInfo = new TextureInfo(string, (UnitDouble)comparable, (UnitDouble)iLegacy_2012_1);
        Texture texture = new Texture(string, image);
        this.d_db.setTexture(string, texture);
        this.setDefaultInfo(string, textureInfo);
        return textureInfo;
    }

    private File getTexFile(String string) {
        File file = this.getTexDir();
        return file == null ? null : new File(file, string);
    }

    private File getPropsFile(String string) {
        File file = this.getTexDir();
        if (file == null) {
            return null;
        }
        return TextureDBMgr.getPropsFile(file, string);
    }

    private static File getPropsFile(File file, String string) {
        String string2 = string + INFO_EXTN;
        return new File(file, string2);
    }

    private void store(File file, String string) {
        TextureInfo textureInfo = this.d_db.getDefaultInfo(string);
        TextureDBMgr.store(file, string, textureInfo);
    }

    private static void store(File file, String string, TextureInfo textureInfo) {
        System.out.print("storing defaults for \"" + string + "\"...");
        TexturePrefs texturePrefs = new TexturePrefs();
        UnitDouble unitDouble = textureInfo.getWidth();
        UnitDouble unitDouble2 = textureInfo.getHeight();
        Unit unit = unitDouble.getUnit();
        texturePrefs.setLenUnit(unitDouble.getUnit());
        texturePrefs.setProperty("width", Double.toString(unitDouble.getValue(unit)));
        texturePrefs.setProperty("height", Double.toString(unitDouble2.getValue(unit)));
        try {
            File file2 = TextureDBMgr.getPropsFile(file, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            texturePrefs.storeToXML(fileOutputStream, string);
            fileOutputStream.close();
            System.out.println("done");
        }
        catch (IOException iOException) {
            System.out.println("failed");
            iOException.printStackTrace();
        }
    }

    public FilenameFilter getFilenameFilter() {
        final FileFilter[] fileFilterArray = this.getFileFilters();
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                for (FileFilter fileFilter : fileFilterArray) {
                    if (!fileFilter.accept(file2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void scanDir(File file) {
        List<File> list = IOUtil.listFiles(file, this.getFilenameFilter());
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Serializable serializable;
            String string = list.get(i).getAbsolutePath();
            stringArray[i] = list.get(i).getName();
            String string2 = list.get(i).getName();
            Texture texture = new Texture(string2, Image.loadUncached(string));
            File file2 = new File(file, stringArray[i] + INFO_EXTN);
            if (file2.exists()) {
                Object object;
                serializable = new TexturePrefs();
                try {
                    object = new FileInputStream(file2);
                    ((Properties)serializable).loadFromXML((InputStream)object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    serializable = null;
                }
                if (serializable != null) {
                    object = new TextureInfo(string2);
                    Unit unit = ((TexturePrefs)serializable).getLenUnit();
                    double d = ((TexturePrefs)serializable).getDouble("width", 1.0);
                    double d2 = ((TexturePrefs)serializable).getDouble("height", 1.0);
                    ((TextureInfo)object).setWidth(new UnitDouble(d, unit));
                    ((TextureInfo)object).setHeight(new UnitDouble(d2, unit));
                    this.d_db.setTexture(string2, texture);
                    this.d_db.setDefaultInfo(string2, (TextureInfo)object);
                }
            }
            if (this.d_db.names().contains(string2)) continue;
            serializable = new TextureInfo(string2);
            this.d_db.setTexture(string2, texture);
            this.setDefaultInfo(string2, (TextureInfo)serializable);
        }
    }

    private static class TexturePrefs
    extends Properties {
        private static final long serialVersionUID = 3381148438110254373L;
        public static final int UNIT_METERS = 0;
        public static final int UNIT_FEET = 1;
        private static final String KEY_WID = "width";
        private static final String KEY_HT = "height";
        private static final String KEY_UNITS = "length_unit";

        private TexturePrefs() {
        }

        public double getDouble(String string, double d) {
            String string2 = this.getProperty(string);
            if (string2 != null) {
                return Double.parseDouble(this.getProperty(string));
            }
            return d;
        }

        public void setLenUnit(Unit unit) {
            BaseUnit baseUnit = SI.METER;
            Unit unit2 = NonSI.FOOT;
            if (((Unit)baseUnit).equals(unit)) {
                this.setProperty(KEY_UNITS, Integer.toString(0));
            } else if (unit2.equals(unit)) {
                this.setProperty(KEY_UNITS, Integer.toString(1));
            } else {
                throw new IllegalArgumentException(unit.toString());
            }
        }

        public Unit getLenUnit() {
            String string = this.getProperty(KEY_UNITS);
            if (string != null && string.equals(Integer.toString(0))) {
                return SI.METER;
            }
            if (string != null && string.equals(Integer.toString(1))) {
                return NonSI.FOOT;
            }
            return null;
        }
    }
}

