/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.TypeFilter;

public class PyroSimSelectionModel {
    private final Set<Object> d_selectionSet = new LinkedIdentityHashSet<Object>();
    private final PyroMod d_pyMod;

    public PyroSimSelectionModel(PyroMod pyroMod) {
        this.d_pyMod = pyroMod;
    }

    protected void pauseUpdates() {
        this.d_pyMod.pauseUpdates();
    }

    protected void resumeUpdates() {
        this.d_pyMod.resumeUpdates();
    }

    public void setSelection(Object ... objectArray) {
        this.setSelection(Arrays.asList(objectArray));
    }

    public void setSelection(Collection<?> collection) {
        this.pauseUpdates();
        this.clearSelection();
        this.selectAll(collection);
        this.resumeUpdates();
    }

    private <T> void fireHierarchySelEvt(T t) {
        PyroMod pyroMod = t instanceof IPyroObject ? (PyroMod)((IPyroObject)t).getDomain() : this.d_pyMod;
        if (pyroMod != null) {
            pyroMod.getEvents().changed(t, PyroMod.EVT_SEL);
            if (t instanceof IPyroObject) {
                for (IPyroObject iPyroObject : ((IPyroObject)t).getMembers()) {
                    this.fireHierarchySelEvt(iPyroObject);
                }
            }
        }
    }

    private <T> void deselectChildren(T t) {
        if (t instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)t).getMembers()) {
                this.d_selectionSet.remove(iPyroObject);
                this.deselectChildren(iPyroObject);
            }
        }
    }

    public <T> void select(T t) {
        this.pauseUpdates();
        if (!this.isSelected(t) && this.d_selectionSet.add(t)) {
            this.deselectChildren(t);
            this.fireHierarchySelEvt(t);
        }
        this.resumeUpdates();
    }

    public <T> void select(T ... TArray) {
        this.select((T)Arrays.asList(TArray));
    }

    public <T> void selectAll(Collection<? extends T> collection) {
        this.pauseUpdates();
        for (T t : collection) {
            this.select(t);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T t) {
        this.pauseUpdates();
        if (this.d_selectionSet.remove(t)) {
            this.fireHierarchySelEvt(t);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T ... TArray) {
        this.deselect((T)Arrays.asList(TArray));
    }

    public <T> void deselectAll(Collection<? extends T> collection) {
        this.pauseUpdates();
        for (T t : collection) {
            this.deselect(t);
        }
        this.resumeUpdates();
    }

    public void clearSelection() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.d_selectionSet);
        this.deselectAll(arrayList);
    }

    private boolean isHierarchySelected(Object object) {
        IPyroObject iPyroObject = object instanceof IPyroObject ? ((IPyroObject)object).getParent() : null;
        return iPyroObject != null ? this.isSelected(iPyroObject) : false;
    }

    public boolean isSelected(Object object) {
        if (object == null) {
            return this.isEmpty();
        }
        return this.d_selectionSet.contains(object) || this.isHierarchySelected(object);
    }

    private <T> void collectChildren(Collection<T> collection, T t, Class<T> clazz) {
        collection.add(t);
        if (t instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)t).getMembers()) {
                if (!clazz.isInstance(iPyroObject)) continue;
                IPyroObject iPyroObject2 = iPyroObject;
                this.collectChildren(collection, iPyroObject2, clazz);
            }
        }
    }

    public Set<?> getSelection() {
        return this.d_selectionSet;
    }

    public <T> FilteredSet<T> getSelected(Class<T> clazz) {
        return new FilteredSet<T>(this.d_selectionSet, clazz);
    }

    public <T> FilteredSet<T> getSelected(Class<? extends T> ... classArray) {
        TypeFilter<? extends T> typeFilter = new TypeFilter<T>(classArray);
        return new FilteredSet<T>(this.d_selectionSet, Object.class, typeFilter);
    }

    public <T> FilteredSet<T> getSelected(Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        return new FilteredSet<T>(this.d_selectionSet, clazz, iObjectFilter);
    }

    public <T> Collection<T> flatten(Class<T> clazz) {
        return Hierarchy.flatten(this.d_selectionSet, clazz);
    }

    public <T> Collection<T> flatten(Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        return Hierarchy.flatten(this.d_selectionSet, clazz, iObjectFilter);
    }

    public int getNum(Class clazz) {
        return this.getSelected((Class<T>)clazz).size();
    }

    public boolean isEmpty() {
        return this.d_selectionSet.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PyroSimSelectionModel:" + this.hashCode() + " {\n");
        stringBuffer.append("   Object.class         -->> " + this.getSelection().size() + "\n");
        stringBuffer.append("   GridList.class       -->> " + this.getSelected((Class<T>)GridList.class).size() + "\n");
        stringBuffer.append("   Grid.class           -->> " + this.getSelected((Class<T>)Grid.class).size() + "\n");
        stringBuffer.append("   MaterialManager.class-->> " + this.getSelected((Class<T>)MaterialManager.class).size() + "\n");
        stringBuffer.append("   Material.class       -->> " + this.getSelected((Class<T>)Material.class).size() + "\n");
        stringBuffer.append("   SurfaceManager.class -->> " + this.getSelected((Class<T>)SurfaceManager.class).size() + "\n");
        stringBuffer.append("   ISurface.class       -->> " + this.getSelected((Class<T>)Isosurface.class).size() + "\n");
        stringBuffer.append("   ReactionList.class   -->> " + this.getSelected((Class<T>)ReactionList.class).size() + "\n");
        stringBuffer.append("   Reaction.class       -->> " + this.getSelected((Class<T>)Reaction.class).size() + "\n");
        stringBuffer.append("   GenericGeomSrc.class -->> " + this.getSelected((Class<T>)GenericGeomSrc.class).size() + "\n");
        stringBuffer.append("   FDSObject.class      -->> " + this.getSelected((Class<T>)FDSObject.class).size() + "\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

