/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroSimSelectionModel;
import pyrosim.legacy_2012_1.PyroTaskManager;
import pyrosim.legacy_2012_1.TextureDBMgr;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FDSClusterOptions;
import pyrosim.legacy_2012_1.domain.FDSRun;
import pyrosim.legacy_2012_1.domain.FloorManager;
import pyrosim.legacy_2012_1.domain.GeomLocator;
import pyrosim.legacy_2012_1.domain.GeomProximity;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.ResultsArchive;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.domain.evac.EvssList;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.SliceList;
import pyrosim.legacy_2012_1.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.zones.LeakMgr;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.io.BimImporter;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.io.fds.FDSParseResult;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5Parser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.EventChannel;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PyroMod
extends Mediator
implements Serializable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object EVT_CHANGED = new Object();
    public static final Object EVT_SEL = new Object();
    public static final Object EVT_CHILDREN_CHANGED = new Object();
    public static final Object EVT_PARENT_CHANGED = "PARENT_CHANGED";
    public static final Object EVT_ENABLED_CHANGED = new Object();
    public static final Object EVT_VISIBILITY_CHANGED = new Object();
    public static final Object EVT_CHILDREN_ADDED = new Object();
    public static final Object EVT_CHILDREN_REMOVED = new Object();
    public static final Object EVT_FILENAME_CHANGED = new Object();
    public static final Object EVT_FDS_RUN_CHANGED = new Object();
    public static final Object EVT_FDS_CLUSTER_OPTIONS_CHANGED = new Object();
    public static final Object EVT_MODEL_CHANGED = new Object();
    public static final Object EVT_PREFS_CHANGED = new Object();
    public static final Object EVT_UNITSYSTEM_CHANGED = new Object();
    public static final Object EVT_UNPROC_RECS_CHANGED = new Object();
    public static final Object EVT_APPEARANCE = new Object();
    public static final Object EVT_FDS_EVAC_CHANGED = new Object();
    public static final Object EVT_RAST_PROPS = new Object();
    public Serialized ser;
    private final transient PyroTaskManager d_taskMan;
    private transient PyroSimSelectionModel d_selModel;
    private final transient FDSRasterization d_rasterizations = new FDSRasterization(this);
    private boolean d_autoProxUpdate = true;
    private final transient GeomProximity d_geomProx;
    private final transient GeomLocator d_geomLocator;
    private transient TextureDBMgr d_texdbMgr;

    public PyroMod() {
        this(false);
    }

    public PyroMod(boolean bl) {
        this(null, bl, true);
    }

    public PyroMod(Serialized serialized) {
        this(serialized, false, true);
    }

    public PyroMod(Serialized serialized, boolean bl, boolean bl2) {
        if (bl2) {
            this.setEvents(new PyroEvents());
        } else {
            this.setEvents(new NilEvents());
        }
        this.d_selModel = new PyroSimSelectionModel(this);
        this.d_taskMan = new PyroTaskManager(this);
        this.d_geomLocator = new GeomLocator();
        this.d_geomProx = new GeomProximity(this);
        this.d_texdbMgr = new TextureDBMgr();
        if (serialized == null) {
            this.setSerialized(new Serialized(bl));
        } else {
            this.setSerialized(serialized);
        }
        this.ser.setDomain(this);
    }

    private static Point3d p3d(double d, double d2, double d3) {
        return new Point3d(d, d2, d3);
    }

    private static Point3d p3d(double d, double d2) {
        return new Point3d(d, d2, 0.0);
    }

    private void add(String string, IGeom iGeom) {
        Surface[] surfaceArray = new Surface[]{(Surface)this.ser.surfmgr.get(PredefSurf.INERT.name())};
        this.ser.obstructions.add(new Obstruction(string, iGeom, surfaceArray));
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return PyroMod.getMembers(this.ser, this.getFdsEvacEnabled());
    }

    public static Collection<? extends IPyroObject> getMembers(Serialized serialized, boolean bl) {
        ArrayList<APyroObject> arrayList = new ArrayList<APyroObject>();
        List<APyroObject> list = Arrays.asList(serialized.boundaryOutput, serialized.controls, serialized.devices, serialized.exSpecs, serialized.floors, serialized.grids, serialized.heatLinkModels, serialized.hvacSystem, serialized.isosurfaces, serialized.matmgr, serialized.msrStats, serialized.obstructions, serialized.particles, serialized.plot3d, serialized.profs, serialized.reactions, serialized.simParams, serialized.slices, serialized.smokeLinkModels, serialized.sprayModels, serialized.sprkLinkModels, serialized.surfmgr, serialized.zoneLeaks, serialized.zones);
        arrayList.addAll(list);
        if (bl) {
            List<Composite> list2 = Arrays.asList(serialized.corrs, serialized.doors, serialized.entrs, serialized.evacs, serialized.evhos, serialized.evsss, serialized.exits, serialized.perss);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public void setTextureDBMgr(TextureDBMgr textureDBMgr) {
        this.d_texdbMgr = textureDBMgr;
        this.d_texdbMgr.setTextureDB(this.ser.textures);
    }

    public TextureDBMgr getTextureDBMgr() {
        return this.d_texdbMgr;
    }

    public void setAutoProxUpdate(boolean bl) {
        this.d_autoProxUpdate = bl;
    }

    public GeomLocator getGeomLocator() {
        return this.d_geomLocator;
    }

    public GeomProximity getGeomProx() {
        return this.d_geomProx;
    }

    public void updateGeomSearchesEnabled(boolean bl) {
        this.d_geomProx.setEnabled(bl);
        if (bl) {
            Collection<? extends IPyroGeomSrc> collection = this.getAllGeom();
            for (IPyroGeomSrc iPyroGeomSrc : collection) {
                this.d_geomProx.add(iPyroGeomSrc);
            }
            this.pauseUpdates(false);
            this.d_geomProx.update();
            this.resumeUpdates();
        }
    }

    public FDSRasterization getRasterizations() {
        return this.d_rasterizations;
    }

    public PyroTaskManager getTaskManager() {
        return this.d_taskMan;
    }

    public PyroSimSelectionModel getSelectionModel() {
        return this.d_selModel;
    }

    public void resetModel() {
        this.pauseUpdates(false);
        this.d_selModel.clearSelection();
        this.setSerialized(new Serialized(true));
        this.resumeUpdates();
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public RasterizationOptions getRastOptions() {
        return this.ser.rastProps;
    }

    public void setRastProps(RasterizationOptions rasterizationOptions) {
        if (this.ser.rastProps.equals(rasterizationOptions)) {
            return;
        }
        this.ser.rastProps = rasterizationOptions;
        this.getEvents().changed(this, EVT_RAST_PROPS);
    }

    public ModelComposite getObstructions() {
        return this.ser.obstructions;
    }

    public SimParams getSimParams() {
        return this.ser.simParams;
    }

    public MaterialManager getMaterialMgr() {
        return this.ser.matmgr;
    }

    public SurfaceManager getSurfaceMgr() {
        return this.ser.surfmgr;
    }

    public ReactionList getReactions() {
        return this.ser.reactions;
    }

    public String getUnprocessedRecords() {
        return this.ser.unprocessedRecords;
    }

    public void setUnprocessedRecords(String string) {
        this.ser.unprocessedRecords = string;
    }

    public void openModel(PyroSimObjectInputStream pyroSimObjectInputStream, boolean bl) throws IOException, ClassNotFoundException, Exception {
        this.pauseUpdates(false);
        try {
            Serialized serialized = pyroSimObjectInputStream.readModel();
            this.setSerialized(serialized);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.resumeUpdates();
        }
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public boolean saveModel(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ser);
        return true;
    }

    public boolean readBIMFile(String string) {
        boolean bl = true;
        this.pauseUpdates();
        try {
            BimImporter.open(this.ser, string);
        }
        catch (Throwable throwable) {
            bl = false;
            throwable.printStackTrace();
        }
        this.resumeUpdates();
        return bl;
    }

    public boolean readFDS5File(String string, boolean bl) throws Exception {
        this.pauseUpdates(false);
        try {
            PyroMod pyroMod = new PyroMod();
            pyroMod.setAutoProxUpdate(false);
            FDS5Parser fDS5Parser = new FDS5Parser();
            FDSParseResult fDSParseResult = fDS5Parser.parseFile(string, pyroMod);
            fDSParseResult.warningReport.showWarnings(bl);
            pyroMod.ser.initDefaults();
            this.setSerialized(pyroMod.ser);
            this.getFloorManager().addDefaults();
            pyroMod = null;
            this.resumeUpdates();
            this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
            return true;
        }
        catch (Exception exception) {
            this.resumeUpdates();
            throw exception;
        }
    }

    public void setSerialized(Serialized serialized) {
        if (this.ser != null) {
            this.ser.setDomain(null);
        }
        this.ser = serialized;
        this.ser.setDomain(this);
        this.d_texdbMgr.setTextureDB(this.ser.textures);
        this.d_selModel.clearSelection();
        this.getEvents().resetEvents();
    }

    public GridList getGridManager() {
        return this.ser.grids;
    }

    public ZoneMgr getZoneMgr() {
        return this.ser.zones;
    }

    public LeakMgr getZoneLeakMgr() {
        return this.ser.zoneLeaks;
    }

    public FloorManager getFloorManager() {
        return this.ser.floors;
    }

    public void setPL3DRecord(Plot3d plot3d) {
        this.ser.plot3d = plot3d;
        this.getEvents().changed(this.ser.plot3d, new Object[0]);
    }

    public void setSimParams(SimParams simParams) {
        this.ser.simParams = simParams;
        this.getEvents().changed(this.ser.simParams, new Object[0]);
    }

    public SmokeLinkModelMgr getSmokeLinkModels() {
        return this.ser.smokeLinkModels;
    }

    public HeatLinkModelMgr getHeatLinkModels() {
        return this.ser.heatLinkModels;
    }

    public SprinklerLinkModelMgr getSprinklerLinkModels() {
        return this.ser.sprkLinkModels;
    }

    public SprayModelMgr getSprayModels() {
        return this.ser.sprayModels;
    }

    public DeviceManager getDevices() {
        return this.ser.devices;
    }

    public ControlMgr getControls() {
        return this.ser.controls;
    }

    public Boundaries getBoundaryOutput() {
        return this.ser.boundaryOutput;
    }

    public IsosurfaceMgr getIsofList() {
        return this.ser.isosurfaces;
    }

    public SliceList getSlcfList() {
        return this.ser.slices;
    }

    public ParticleList getPartList() {
        return this.ser.particles;
    }

    public ExSpecList getExSpecList() {
        return this.ser.exSpecs;
    }

    public HvacList getHvacList() {
        return this.ser.hvacSystem;
    }

    public boolean getFdsEvacEnabled() {
        return this.ser.enableFdsEvac;
    }

    private Task taskSetFdsEvacEnabled(final boolean bl) {
        return new AUndoableTask(){

            @Override
            public void undo() {
                this.set(!bl);
            }

            @Override
            public void run() {
                this.set(bl);
            }

            private void set(boolean bl2) {
                PyroMod.this.ser.enableFdsEvac = bl2;
                PyroMod.this.getEvents().changed(PyroMod.this, EVT_FDS_EVAC_CHANGED);
            }
        };
    }

    public void setEvacEnabled(boolean bl) {
        Task task = this.taskSetFdsEvacEnabled(bl);
        String string = bl ? Intl.intl("Enable FDS+EVAC") : Intl.intl("Disable FDS+Evac");
        this.getTaskManager().exec(task, string);
    }

    public EvacList getEvacList() {
        return this.ser.evacs;
    }

    public EntrList getEntrList() {
        return this.ser.entrs;
    }

    public EvhoList getEvhoList() {
        return this.ser.evhos;
    }

    public CorrList getCorrList() {
        return this.ser.corrs;
    }

    public EvssList getEvssList() {
        return this.ser.evsss;
    }

    public ExitList getExitList() {
        return this.ser.exits;
    }

    public PersList getPersList() {
        return this.ser.perss;
    }

    public DoorList getDoorList() {
        return this.ser.doors;
    }

    public Plot3d getPlot3d() {
        return this.ser.plot3d;
    }

    public ProfList getProfList() {
        return this.ser.profs;
    }

    public StatisticMgr getMsrStatMgr() {
        return this.ser.msrStats;
    }

    public TextureDB getTextureDB() {
        return this.ser.textures;
    }

    public Surface getDefaultSurface() {
        return (Surface)this.getSurfaceMgr().get(PredefSurf.INERT.name());
    }

    public ResultsArchive getResultsArchive() {
        return this.ser.resultsArchive;
    }

    public Collection<? extends IPyroGeomSrc> getAllGeom() {
        return Hierarchy.flatten(this.getMembers(), IPyroGeomSrc.class);
    }

    public DepSnapshot getDependencies(IPyroObject ... iPyroObjectArray) {
        return this.getDependencies(Arrays.asList(iPyroObjectArray));
    }

    public DepSnapshot getDependencies(Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = new DepSnapshot(collection);
        this.collectDeps(depSnapshot);
        return depSnapshot;
    }

    private void collectDeps(DepSnapshot depSnapshot) {
        depSnapshot.start(this, this.ser);
    }

    public Object getLockObj() {
        return this.ser;
    }

    public void setLastFDSRun(FDSRun fDSRun) {
        if (!theUtil.equal(fDSRun, this.ser.lastFDSRun)) {
            this.ser.lastFDSRun = fDSRun;
            this.getEvents().changed(this, EVT_FDS_RUN_CHANGED);
        }
    }

    public FDSRun getLastFDSRun() {
        return this.ser.lastFDSRun;
    }

    public FDSClusterOptions getClusterOptions() {
        return this.ser.clusterOptions;
    }

    public void setClusterOptions(FDSClusterOptions fDSClusterOptions) {
        this.ser.clusterOptions = fDSClusterOptions;
        this.getEvents().changed(this, EVT_FDS_CLUSTER_OPTIONS_CHANGED);
    }

    public void setWriteProtected(boolean bl, byte[] byArray) {
        assert (byArray != null);
        this.ser.d_protect = bl;
        this.ser.d_protectPassHash = byArray;
    }

    public boolean isWriteProtected() {
        return this.ser.d_protect;
    }

    public byte[] getWriteProtectedPassHash() {
        return this.ser.d_protectPassHash;
    }

    @Override
    public PyroMod getDomain() {
        return this;
    }

    @Override
    public boolean changedEvt(Object ... objectArray) {
        return this.getEvents().changed(this, objectArray);
    }

    @Override
    public boolean isMixFracOnly() {
        return false;
    }

    @Override
    public boolean invokesMixFrac() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setDomain(PyroMod pyroMod) {
    }

    @Override
    public void setDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
    }

    @Override
    public IPyroObject getParent() {
        return null;
    }

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    private static class NilEvents
    extends Events {
        private NilEvents() {
        }

        @Override
        public void addObserver(IEventObserver iEventObserver) {
        }

        @Override
        public void removeObserver(IEventObserver iEventObserver) {
        }

        @Override
        public void clearObservers() {
        }

        @Override
        public void resetEvents() {
        }

        public Set<EventChannel> getAffectedChannels(Class clazz, Class ... classArray) {
            return Collections.EMPTY_SET;
        }

        @Override
        public void pause() {
        }

        @Override
        public void pause(boolean bl) {
        }

        @Override
        public boolean resume() {
            return false;
        }

        @Override
        public boolean willFireOnResume() {
            return false;
        }

        @Override
        public Collection<EventChannel> getChannels() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean added(Object object) {
            return false;
        }

        @Override
        public boolean added(Object ... objectArray) {
            return false;
        }

        @Override
        public boolean added(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean removed(Object object) {
            return false;
        }

        @Override
        public boolean removed(Object ... objectArray) {
            return false;
        }

        @Override
        public boolean removed(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean changed(Object object, Object ... objectArray) {
            return false;
        }

        @Override
        public boolean changed(Collection<?> collection, Object ... objectArray) {
            return false;
        }
    }

    private class PyroEvents
    extends Events {
        private PyroEvents() {
        }

        @Override
        protected void fireNotification() {
            if (PyroMod.this.d_autoProxUpdate) {
                boolean bl = false;
                for (EventChannel<PyroMod> eventChannel : this.getAffectedChannels(PyroMod.class, new Class[0])) {
                    if (!eventChannel.containsChange(EVT_MODEL_CHANGED)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    PyroMod.this.pauseUpdates(false);
                }
                PyroMod.this.d_geomProx.update();
                if (bl) {
                    PyroMod.this.resumeUpdates();
                }
            }
            PyroMod.this.pauseUpdates(false);
            for (EventChannel eventChannel : this.getChannels()) {
                PyroMod.this.d_selModel.deselectAll(eventChannel.getRemovedObjs());
            }
            PyroMod.this.resumeUpdates();
            PyroMod.this.d_rasterizations.update(this);
            super.fireNotification();
        }
    }

    public static class PasteOption {
        public static final int PASTE_ADD_INCOMING = 0;
        public static final int PASTE_REPLACE_EXISTING = 1;
        public static final int PASTE_KEEP_EXISTING = 2;
        public static final int PASTE_MAKE_INCOMING_UNIQUE = 3;
        public final int command;
        public final Object param;

        public PasteOption(int n, Object object) {
            this.command = n;
            this.param = object;
        }
    }
}

