/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2012_1.ILegacy_2012_1;

public class LegacyDictionary_2012_1 {
    private final Map<Object, Object> d_resolvedRefs = new IdentityHashMap<Object, Object>();
    private static final IResolver<ILegacy_2012_1> s_objResolver = new IResolver<ILegacy_2012_1>(){

        @Override
        public Object resolve(LegacyDictionary_2012_1 legacyDictionary_2012_1, ILegacy_2012_1 iLegacy_2012_1) {
            return iLegacy_2012_1.fromLegacy(legacyDictionary_2012_1);
        }
    };

    public Object get(ILegacy_2012_1 iLegacy_2012_1) {
        return this.resolve(iLegacy_2012_1, s_objResolver);
    }

    public <TCurr, TLeg extends ILegacy_2012_1> SortedSet<TCurr> get(SortedSet<TLeg> sortedSet) {
        if (sortedSet == null) {
            return null;
        }
        return (SortedSet)this.resolve(sortedSet, new SortedSetResolver());
    }

    public <TCurr, TLeg extends ILegacy_2012_1> List<TCurr> get(List<TLeg> list) {
        if (list == null) {
            return null;
        }
        return (List)this.resolve(list, new ListResolver());
    }

    public <TCurr, TLeg extends ILegacy_2012_1> TCurr[] get(Class<TCurr> clazz, TLeg[] TLegArray) {
        if (TLegArray == null) {
            return null;
        }
        return (Object[])this.resolve(TLegArray, new ArrResolver(clazz));
    }

    private <TCurr, TLeg> TCurr resolve(TLeg TLeg, IResolver<TLeg> iResolver) {
        if (TLeg == null) {
            return null;
        }
        if (!this.d_resolvedRefs.containsKey(TLeg)) {
            Object object = iResolver.resolve(this, TLeg);
            this.d_resolvedRefs.put(TLeg, object);
            return (TCurr)object;
        }
        return (TCurr)this.d_resolvedRefs.get(TLeg);
    }

    private static class ListResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<Collection<TLeg>> {
        private ListResolver() {
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 legacyDictionary_2012_1, Collection<TLeg> collection) {
            ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
            for (ILegacy_2012_1 iLegacy_2012_1 : collection) {
                arrayList.add(legacyDictionary_2012_1.get(iLegacy_2012_1));
            }
            return arrayList;
        }
    }

    private static class SortedSetResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<SortedSet<TLeg>> {
        private SortedSetResolver() {
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 legacyDictionary_2012_1, SortedSet<TLeg> sortedSet) {
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (ILegacy_2012_1 iLegacy_2012_1 : sortedSet) {
                treeSet.add(legacyDictionary_2012_1.get(iLegacy_2012_1));
            }
            return treeSet;
        }
    }

    private static class ArrResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<TLeg[]> {
        private final Class<TCurr> d_currClazz;

        public ArrResolver(Class<TCurr> clazz) {
            this.d_currClazz = clazz;
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 legacyDictionary_2012_1, TLeg[] TLegArray) {
            Object[] objectArray = (Object[])Array.newInstance(this.d_currClazz, TLegArray.length);
            for (int i = 0; i < TLegArray.length; ++i) {
                objectArray[i] = legacyDictionary_2012_1.get((ILegacy_2012_1)TLegArray[i]);
            }
            return objectArray;
        }
    }

    private static interface IResolver<T> {
        public Object resolve(LegacyDictionary_2012_1 var1, T var2);
    }
}

