/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Disposable;

public class theUtil {
    public static <T> Collection<T> cast(Collection<?> collection, Collection<T> collection2, Class<T> clazz) {
        for (Object obj : collection) {
            collection2.add(clazz.cast(obj));
        }
        return collection2;
    }

    public static Vector3d projectToPlane(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d2);
        double d = vector3d.dot(vector3d3);
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.scale(-d);
        vector3d3.add(vector3d4);
        return vector3d3;
    }

    public static double angleBetweenNPIToPPI(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = vector3d2.angle(vector3d3);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        double d2 = vector3d4.dot(vector3d);
        if (d2 >= 0.0) {
            return d;
        }
        return -d;
    }

    public static double angleBetween0To2PI(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = theUtil.angleBetweenNPIToPPI(vector3d, vector3d2, vector3d3);
        if (d >= 0.0) {
            return d;
        }
        return Math.PI * 2 + d;
    }

    public static UnitDouble roundAngle(UnitDouble unitDouble, UnitDouble unitDouble2, Unit unit) {
        double d = unitDouble.getValue(SI.RADIAN);
        double d2 = unitDouble2.getValue(SI.RADIAN);
        long l = Math.round(Math.PI * 2 / d2);
        long l2 = Math.round(Math.abs(d) / d2) % l;
        if (d < 0.0) {
            l2 = -l2;
        }
        double d3 = unitDouble2.getValueNoUnit() * (double)l2;
        double d4 = UnitDouble.convert(d3, unitDouble2.getUnit(), unit);
        return new UnitDouble(d4, unit);
    }

    public static Point3d p4dTo3d(Point4d point4d) {
        double d = 1.0 / point4d.w;
        return new Point3d(point4d.x * d, point4d.y * d, point4d.z * d);
    }

    public static void acquire(Disposable disposable) {
        if (disposable != null) {
            disposable.acquire();
        }
    }

    public static void acquire(Disposable[] disposableArray) {
        if (disposableArray != null) {
            for (int i = 0; i < disposableArray.length; ++i) {
                if (disposableArray[i] == null) continue;
                disposableArray[i].acquire();
            }
        }
    }

    public static <T> void acquire(Collection<T> collection) {
        if (collection != null) {
            for (T t : collection) {
                theUtil.acquire(t);
            }
        }
    }

    public static void acquire(Object object) {
        if (object instanceof Disposable) {
            ((Disposable)object).acquire();
        }
    }

    public static void acquire(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Disposable)) continue;
                ((Disposable)objectArray[i]).acquire();
            }
        }
    }

    public static void release(Disposable disposable) {
        if (disposable != null) {
            disposable.release();
        }
    }

    public static void release(Disposable[] disposableArray) {
        if (disposableArray != null) {
            for (int i = 0; i < disposableArray.length; ++i) {
                if (disposableArray[i] == null) continue;
                disposableArray[i].release();
            }
        }
    }

    public static <T> void release(Collection<T> collection) {
        if (collection != null) {
            for (T t : collection) {
                theUtil.release(t);
            }
        }
    }

    public static void release(Object object) {
        if (object instanceof Disposable) {
            ((Disposable)object).release();
        }
    }

    public static void release(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Disposable)) continue;
                ((Disposable)objectArray[i]).release();
            }
        }
    }

    public static String getFileExtension(File file) {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static int binarySearch(double[] dArray, double d, DoubleComparator doubleComparator) {
        return theUtil.binarySearch(dArray, d, 0, dArray.length - 1, doubleComparator);
    }

    private static int binarySearch(double[] dArray, double d, int n, int n2, DoubleComparator doubleComparator) {
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            double d2 = dArray[n3];
            int n4 = doubleComparator.compare(d2, d);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static <T extends Number> int[] toIntArray(Collection<T> collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Number number : collection) {
            nArray[n++] = number.intValue();
        }
        return nArray;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        assert (clazz != null);
        if (collection == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(objectArray);
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

