/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import pyrosim.legacy_2006_2.thunderheadeng.util.IWarning;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class WarningReport<T extends IWarning> {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private Collection<T> d_allWarnings = new ArrayList<T>();
    private final Class<T> d_warningType;
    private Collection<T> d_sortedWarnings;
    private final int[] d_warningInfoTypes;
    private final String[] d_warningInfoDescs;
    private int d_sortType;
    private int d_sortOrder = 0;

    public WarningReport(Class<T> clazz, int[] nArray, String[] stringArray, int n) {
        assert (nArray.length == stringArray.length);
        this.d_warningType = clazz;
        this.d_warningInfoTypes = nArray;
        this.d_warningInfoDescs = stringArray;
        this.d_sortType = n;
    }

    public Class<T> getType() {
        return this.d_warningType;
    }

    public void addWarning(T t) {
        this.d_allWarnings.add(t);
        this.d_sortedWarnings = null;
    }

    public void removeWarning(T t) {
        this.d_allWarnings.add(t);
        this.d_sortedWarnings = null;
    }

    public int[] getInfoTypes() {
        return this.d_warningInfoTypes;
    }

    public String[] getInfoDescriptions() {
        return this.d_warningInfoDescs;
    }

    public Collection<T> getWarnings() {
        if (this.d_sortOrder == 0) {
            return this.d_allWarnings;
        }
        this.sortWarnings(this.d_sortOrder);
        return this.d_sortedWarnings;
    }

    public boolean isEmpty() {
        return this.d_allWarnings.isEmpty();
    }

    public void setSortInfoType(int n, boolean bl) {
        this.d_sortType = n;
        this.d_sortedWarnings = null;
        if (bl) {
            this.sortWarnings(this.d_sortOrder);
        }
    }

    public void sortWarnings(int n) {
        this.sortWarnings(this.d_sortType, n);
    }

    public void sortWarnings(int n, int n2) {
        if (n != this.d_sortType || n2 != this.d_sortOrder) {
            this.d_sortedWarnings = null;
            this.d_sortType = n;
            this.d_sortOrder = n2;
        }
        if (this.d_sortedWarnings != null || this.d_sortOrder == 0) {
            return;
        }
        IWarning[] iWarningArray = (IWarning[])Array.newInstance(this.d_warningType, this.d_allWarnings.size());
        this.d_allWarnings.toArray(iWarningArray);
        final int n3 = this.d_sortOrder == 1 ? 1 : -1;
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                Comparable comparable = t.getWarningInfo(WarningReport.this.d_sortType);
                Comparable comparable2 = t2.getWarningInfo(WarningReport.this.d_sortType);
                if (comparable instanceof String) {
                    return ((String)((Object)comparable)).compareToIgnoreCase((String)((Object)comparable2)) * n3;
                }
                return comparable.compareTo(comparable2) * n3;
            }
        };
        Arrays.sort(iWarningArray, comparator);
        this.d_sortedWarnings = new VectorFromArray<IWarning>(iWarningArray);
    }

    public String prepareReport() {
        int n;
        Collection<T> collection = this.getWarnings();
        int[] nArray = new int[this.d_warningInfoTypes.length];
        for (int i = 0; i < this.d_warningInfoTypes.length; ++i) {
            if (this.d_warningInfoDescs[i].length() <= nArray[i]) continue;
            nArray[i] = this.d_warningInfoDescs[i].length();
        }
        for (IWarning iWarning : collection) {
            for (int i = 0; i < this.d_warningInfoTypes.length; ++i) {
                int n2 = iWarning.getWarningInfo(this.d_warningInfoTypes[i]).toString().length();
                if (n2 <= nArray[i]) continue;
                nArray[i] = n2;
            }
        }
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n4 = n;
            nArray[n4] = nArray[n4] + 3;
            n3 += nArray[n];
        }
        ++n3;
        n = collection.size() + 2;
        String string = new String(new StringBuffer((n3 += nArray.length + 1) * n));
        String string2 = System.getProperty("line.separator");
        for (int i = 0; i < this.d_warningInfoTypes.length; ++i) {
            string = string + "|";
            string = string + this.d_warningInfoDescs[i];
            string = string + WarningReport.padding(nArray[i] - this.d_warningInfoDescs[i].length(), ' ');
        }
        string = string + "|" + string2;
        string = string + WarningReport.padding(n3 - 1, '=');
        string = string + string2;
        for (IWarning iWarning : collection) {
            for (int i = 0; i < this.d_warningInfoTypes.length; ++i) {
                string = string + "|";
                String string3 = iWarning.getWarningInfo(this.d_warningInfoTypes[i]).toString();
                string = string + string3;
                string = string + WarningReport.padding(nArray[i] - string3.length(), ' ');
            }
            string = string + "|" + string2;
        }
        return string;
    }

    private static String padding(int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public void writeReport(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.print(this.prepareReport());
        printWriter.close();
    }
}

