/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Observable;
import java.util.Stack;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import thunderheadeng.gui.Application;

public class TaskManager
extends Observable {
    private final Stack<Task> d_undo = new Stack();
    private final Stack<Task> d_redo = new Stack();

    public void clearHistory() {
        this.d_undo.clear();
        this.d_redo.clear();
    }

    public void clearRedoHistory() {
        this.d_redo.clear();
    }

    public void clearUndoHistory() {
        this.d_undo.clear();
    }

    public void exec(Task task) {
        this.exec(task, false);
    }

    private void exec(Task task, boolean bl) {
        if (!bl) {
            this.d_redo.clear();
        }
        if (task.canUndo()) {
            this.d_undo.push(task);
        } else {
            this.d_undo.clear();
        }
        switch (task.getEst()) {
            case 0: {
                this.runShort(task);
                break;
            }
            case 1: {
                this.runMed(task);
                break;
            }
            case 2: {
                this.runLong(task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    private void runShort(Task task) {
        task.run();
    }

    private void runMed(Task task) {
        Application.getApp().beginWaitCursor();
        task.run();
        Application.getApp().endWaitCursor();
    }

    private void runLong(Task task) {
        task.run();
    }

    private void undoShort(Task task) {
        task.undo();
    }

    private void undoMed(Task task) {
        Application.getApp().beginWaitCursor();
        task.undo();
        Application.getApp().endWaitCursor();
    }

    private void undoLong(Task task) {
        task.undo();
    }

    public boolean canUndo() {
        return !this.d_undo.empty();
    }

    public void undo() {
        assert (this.canUndo());
        Task task = this.d_undo.pop();
        assert (task.canUndo());
        this.d_redo.push(task);
        switch (task.getEst()) {
            case 0: {
                this.undoShort(task);
                break;
            }
            case 1: {
                this.undoMed(task);
                break;
            }
            case 2: {
                this.undoLong(task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canRedo() {
        return !this.d_redo.empty();
    }

    public void redo() {
        assert (this.canRedo());
        Task task = this.d_redo.pop();
        this.exec(task, true);
    }
}

