/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Vector;

public class Stopwatch {
    private long d_start;
    private boolean d_running;
    private Vector d_splits;

    public Stopwatch() {
        this.reset();
    }

    public Split start() {
        if (!this.d_running) {
            this.d_start = System.currentTimeMillis();
            this.d_splits.add(new Long(0L));
            this.d_running = true;
            return new Split(0L, 0L);
        }
        return null;
    }

    public Split stop() {
        if (this.d_running) {
            long l = System.currentTimeMillis() - this.d_start;
            long l2 = (Long)this.d_splits.lastElement();
            this.d_splits.add(new Long(l));
            this.d_running = false;
            return new Split(l - l2, l);
        }
        return null;
    }

    public Split split() {
        long l = System.currentTimeMillis() - this.d_start;
        long l2 = (Long)this.d_splits.lastElement();
        this.d_splits.add(new Long(l));
        return new Split(l - l2, l);
    }

    public void reset() {
        this.d_start = 0L;
        this.d_running = false;
        this.d_splits = new Vector();
    }

    public static void main(String[] stringArray) {
        int n;
        Stopwatch stopwatch = new Stopwatch();
        System.out.println(stopwatch.start());
        System.out.println(stopwatch.split());
        for (n = 0; n < 10000000; ++n) {
        }
        System.out.println(stopwatch.split());
        for (n = 0; n < 5000000; ++n) {
        }
        System.out.println(stopwatch.split());
        System.out.println(stopwatch.stop());
    }

    public static class Split {
        private long d_lap;
        private long d_split;

        private Split(long l, long l2) {
            this.d_lap = l;
            this.d_split = l2;
        }

        public long getLapTime() {
            return this.d_lap;
        }

        public long getSplitTime() {
            return this.d_split;
        }

        public String toString() {
            return this.d_lap + "\t" + this.d_split;
        }
    }
}

