/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class SetMetrics {
    private final Hashtable<Class, Set<Object>> d_hash = new Hashtable();

    public SetMetrics(Collection collection) {
        for (Object e : collection) {
            this.add(e);
        }
    }

    public SetMetrics() {
        this(Collections.EMPTY_SET);
    }

    public void add(Object object) {
        this.addEntry(object.getClass(), object);
    }

    public boolean contains(Object object) {
        Set<Object> set = this.d_hash.get(object.getClass());
        if (set != null) {
            return set.contains(object);
        }
        return false;
    }

    public void remove(Object object) {
        this.removeEntry(object.getClass(), object);
    }

    public void clear() {
        this.d_hash.clear();
    }

    private void removeEntry(Class clazz, Object object) {
        Set<Object> set = this.d_hash.get(clazz);
        if (set == null) {
            return;
        }
        set.remove(object);
    }

    private void addEntry(Class clazz, Object object) {
        Set<Object> set = this.d_hash.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            this.d_hash.put(clazz, set);
        }
        set.add(object);
    }

    public <T> Set<T> filter(Class<? extends T> ... classArray) {
        HashSet<T> hashSet = new HashSet<T>();
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : classArray) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object object : entry.getValue()) {
                    hashSet.add(clazz.cast(object));
                }
            }
        }
        return hashSet;
    }

    public int getNum(Class ... classArray) {
        return this.filter(classArray).size();
    }

    public boolean isExclusive(Class ... classArray) {
        boolean bl = false;
        for (Class clazz : this.d_hash.keySet()) {
            boolean bl2 = false;
            for (Class clazz2 : classArray) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
            bl = true;
        }
        return bl;
    }
}

