/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyGenerator;
import pyrosim.legacy_2006_2.thunderheadeng.util.Keyable;

public class KeyableObject
implements Serializable,
Keyable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private transient Integer d_key = null;

    public KeyableObject() {
        this.ensureKeyed();
    }

    protected void ensureKeyed() {
        if (this.d_key != null) {
            KEY_GENERATOR.unregisterObject(this, this.d_key);
        }
        this.d_key = KEY_GENERATOR.generateKey();
        KEY_GENERATOR.registerObject(this, this.d_key);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ensureKeyed();
    }

    protected void finalize() throws Throwable {
        KEY_GENERATOR.unregisterObject(this, this.d_key);
        KEY_GENERATOR.returnKey(this.d_key);
        this.d_key = null;
    }

    @Override
    public void setKey(Integer n) {
        KEY_GENERATOR.unregisterObject(this, this.d_key);
        KEY_GENERATOR.returnKey(this.d_key);
        this.d_key = n;
        KEY_GENERATOR.registerObject(this, this.d_key);
    }

    @Override
    public Integer getKey() {
        return this.d_key;
    }

    public Object clone() {
        KeyableObject keyableObject = null;
        try {
            keyableObject = (KeyableObject)super.clone();
            keyableObject.d_key = null;
            keyableObject.ensureKeyed();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return keyableObject;
    }
}

