/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import pyrosim.legacy_2006_2.thunderheadeng.util.AbstractValueRange;

public final class DoubleValueRange
extends AbstractValueRange<Double>
implements Serializable {
    static final long serialVersionUID = 1L;

    private DoubleValueRange(double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(d, d2, bl, bl2, bl3, bl4);
    }

    public static DoubleValueRange createUncheckedRange() {
        return new DoubleValueRange(0.0, 0.0, false, false, false, false);
    }

    public static DoubleValueRange createCheckedMin(double d, boolean bl) {
        return new DoubleValueRange(d, 0.0, true, false, bl, false);
    }

    public static DoubleValueRange createCheckedMax(double d, boolean bl) {
        return new DoubleValueRange(0.0, d, false, true, false, bl);
    }

    public static DoubleValueRange createCheckedMinAndMax(double d, double d2, boolean bl, boolean bl2) {
        return new DoubleValueRange(d, d2, true, true, bl, bl2);
    }

    private double getClampOffset() {
        if (this.checksMin() && this.checksMax()) {
            double d = (Double)this.getMaxValue() - (Double)this.getMinValue();
            return d * 1.0E-6;
        }
        return 0.01;
    }

    @Override
    public String getDataType() {
        return "floating-point number";
    }

    @Override
    public String format(Object object) {
        Double d = (Double)object;
        if ((double)d.intValue() == d) {
            return d.intValue() + ".0";
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.applyPattern("##0.0####E0##");
        return decimalFormat.format(object);
    }

    @Override
    protected Double clampMaxUnincl(Double d) {
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        return (Double)this.getMaxValue() - this.getClampOffset();
    }

    @Override
    protected Double clampMinUnincl(Double d) {
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        return (Double)this.getMinValue() + this.getClampOffset();
    }
}

