/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.util.DiscreteSignal;

public class DigitalSignal
extends DiscreteSignal
implements Serializable {
    static final long serialVersionUID = 6908817182133350577L;
    private double d_sampleInterval;
    private int d_numSamples;
    private BitSet d_bits;

    protected DigitalSignal() {
    }

    @Override
    public DiscreteSignal newSignal(double d, int n) {
        return new DigitalSignal(d, n);
    }

    public DigitalSignal(double d, int n) {
        this.d_sampleInterval = d;
        this.d_bits = new BitSet(n);
        this.d_numSamples = n;
    }

    @Override
    public void setSample(int n, double d) {
        if (n < 0 || n >= this.d_numSamples) {
            return;
        }
        if (d >= 1.0) {
            this.d_bits.set(n);
        } else {
            this.d_bits.clear(n);
        }
    }

    public void setSample(int n, boolean bl) {
        if (n < 0 || n >= this.d_numSamples) {
            return;
        }
        if (bl) {
            this.d_bits.set(n);
        } else {
            this.d_bits.clear(n);
        }
    }

    public void setRangeHigh(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < n2 && i < this.d_numSamples; ++i) {
            this.d_bits.set(i);
        }
    }

    public void setRangeLow(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < n2 && i < this.d_numSamples; ++i) {
            this.d_bits.clear(i);
        }
    }

    public void setRange(int n, int n2, double d) {
        if (d >= 1.0) {
            this.setRangeHigh(n, n2);
        } else {
            this.setRangeLow(n, n2);
        }
    }

    @Override
    public double evaluateSample(int n) {
        if (n >= this.d_numSamples) {
            throw new IndexOutOfBoundsException("Index " + n + " is above " + n + ", the range of this DigitalSignal.");
        }
        return this.d_bits.get(n) ? 1.0 : 0.0;
    }

    @Override
    public DiscreteSignal invert() {
        int n = this.getNumSamples();
        for (int i = 0; i < n; ++i) {
            if (this.d_bits.get(i)) {
                this.d_bits.clear(i);
                continue;
            }
            this.d_bits.set(i);
        }
        return this;
    }

    @Override
    public DiscreteSignal add(DiscreteSignal discreteSignal) {
        DigitalSignal digitalSignal = (DigitalSignal)discreteSignal;
        if (this.getSampleInterval() != digitalSignal.getSampleInterval()) {
            DigitalSignal digitalSignal2 = (DigitalSignal)digitalSignal.clone();
            digitalSignal2.resample(this.getSampleInterval());
            this.d_bits.or(digitalSignal2.d_bits);
        } else {
            this.d_bits.or(digitalSignal.d_bits);
        }
        return this;
    }

    @Override
    public DiscreteSignal multiply(DiscreteSignal discreteSignal) {
        DigitalSignal digitalSignal = (DigitalSignal)discreteSignal;
        if (this.getSampleInterval() != digitalSignal.getSampleInterval()) {
            DigitalSignal digitalSignal2 = (DigitalSignal)digitalSignal.clone();
            digitalSignal2.resample(this.getSampleInterval());
            this.d_bits.and(digitalSignal2.d_bits);
        } else {
            this.d_bits.and(digitalSignal.d_bits);
        }
        return this;
    }

    @Override
    public void resample(double d) {
        if (d == this.d_sampleInterval) {
            return;
        }
        int n = (int)Math.ceil((double)this.d_numSamples * this.d_sampleInterval / d);
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.floor((double)i * this.d_sampleInterval / d);
            if (this.evaluate(n2) >= 1.0) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        this.d_sampleInterval = d;
        this.d_numSamples = n;
        this.d_bits = bitSet;
    }

    @Override
    public int getNumSamples() {
        return this.d_numSamples;
    }

    @Override
    public double getSampleInterval() {
        return this.d_sampleInterval;
    }

    public int[] getTransitions() {
        int n;
        double d = 1.0;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < this.d_numSamples; ++n) {
            if (this.evaluateSample(n) != d) continue;
            vector.add(new Integer(n));
            d = d != 1.0 ? 1 : 0;
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)vector.get(n);
        }
        return nArray;
    }

    public void setTransitions(int[] nArray) {
        int n;
        int n2 = 0;
        boolean bl = false;
        for (n = 0; n2 < nArray.length && n < this.d_numSamples; ++n) {
            if (n == nArray[n2]) {
                bl = !bl;
                ++n2;
            }
            if (bl) {
                this.d_bits.set(n);
                continue;
            }
            this.d_bits.clear(n);
        }
        if (bl) {
            this.setRangeHigh(n, this.d_numSamples);
        } else {
            this.setRangeLow(n, this.d_numSamples);
        }
    }

    public Object clone() {
        DigitalSignal digitalSignal = null;
        try {
            digitalSignal = (DigitalSignal)super.clone();
            digitalSignal.d_bits = (BitSet)this.d_bits.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("CloneNotSupportedException caught: " + cloneNotSupportedException.toString());
        }
        return digitalSignal;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DigitalSignal)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        DigitalSignal digitalSignal = (DigitalSignal)object;
        return this.d_numSamples == digitalSignal.d_numSamples && this.d_sampleInterval == digitalSignal.d_sampleInterval && this.d_bits.equals(digitalSignal.d_bits);
    }
}

