/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2006_2.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.IImage;

public class Image
extends ANativelyMirrored
implements IImage,
Serializable {
    static final long serialVersionUID = 1L;
    public transient byte[] d_bytes;
    public int d_width;
    public int d_height;
    public int d_pitch;
    public byte d_redOffset;
    public byte d_greenOffset;
    public byte d_blueOffset;
    private static final int method_getImageInfo = 0;

    public Image() {
        this.nativeConstructed(Image.class);
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
    }

    @Override
    public Class resolveNativeClass() {
        return Image.class;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            int n = objectInputStream.readInt();
            this.d_bytes = new byte[n];
            objectInputStream.readFully(this.d_bytes);
        } else {
            this.d_bytes = new byte[0];
        }
    }

    public int getHeight() {
        return this.d_height;
    }

    public int getWidth() {
        return this.d_width;
    }

    public ByteBuffer getBuffer() {
        throw new UnsupportedOperationException();
    }

    public class PixelIterator
    implements Iterator<IPixel> {
        private final ByteBuffer d_buffer;
        private final int d_numComponents;
        private final Pixel d_pixel = new Pixel();
        private int d_redix;
        private int d_greenix;
        private int d_blueix;

        public PixelIterator(ByteBuffer byteBuffer, int n) {
            this.d_redix = -3 + Image.this.d_redOffset;
            this.d_greenix = -3 + Image.this.d_greenOffset;
            this.d_blueix = -3 + Image.this.d_blueOffset;
            this.d_buffer = byteBuffer;
            this.d_numComponents = n * 3;
        }

        @Override
        public boolean hasNext() {
            return this.d_redix + 3 < this.d_numComponents;
        }

        @Override
        public IPixel next() {
            this.d_redix += 3;
            this.d_greenix += 3;
            this.d_blueix += 3;
            return this.d_pixel;
        }

        @Override
        public void remove() {
            assert (false);
        }

        public class Pixel
        implements IPixel {
            @Override
            public void set(byte by, byte by2, byte by3) {
                PixelIterator.this.d_buffer.put(PixelIterator.this.d_redix, by);
                PixelIterator.this.d_buffer.put(PixelIterator.this.d_greenix, by2);
                PixelIterator.this.d_buffer.put(PixelIterator.this.d_blueix, by3);
            }
        }
    }

    public class ImageRow
    extends AbstractCollection<IPixel> {
        private final ByteBuffer d_rowBuffer;

        public ImageRow(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<IPixel> iterator() {
            return new PixelIterator(this.d_rowBuffer, Image.this.d_width);
        }

        @Override
        public int size() {
            return Image.this.d_width;
        }
    }

    public static interface IPixel {
        public void set(byte var1, byte var2, byte var3);
    }
}

