/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.scene3d;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Camera
implements Cloneable {
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private Point3d d_pos;
    private Point3d d_ref;
    private Vector3d d_up;
    private double d_near;
    private double d_far;
    private double d_fov;
    private boolean d_orthographic;
    private double d_orthoScale;
    private Vector3d d_resetViewVector;
    private Vector3d d_resetUpVector;
    private Point3d d_resetPos;
    private Point3d d_resetRef;
    private boolean d_wireframe;
    private boolean d_flatShading;
    private boolean d_dirty;

    public Camera() {
        this.d_ref = new Point3d(0.0, 0.0, 0.0);
        this.d_pos = new Point3d(0.0, 0.0, 10.0);
        this.d_up = new Vector3d(0.0, 1.0, 0.0);
        this.d_resetPos = new Point3d(this.d_pos);
        this.d_resetRef = new Point3d(this.d_ref);
        this.d_resetUpVector = new Vector3d(this.d_up);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_resetViewVector = new Vector3d(0.0, 0.0, -1.0);
        this.d_orthographic = false;
        this.d_orthoScale = 1.0;
        this.d_wireframe = false;
        this.d_flatShading = false;
        this.d_dirty = true;
    }

    public Camera(Vector3d vector3d, Vector3d vector3d2, boolean bl, boolean bl2) {
        this.d_pos = new Point3d(0.0, 0.0, 0.0);
        this.d_ref = new Point3d(0.0, 0.0, 0.0);
        this.d_ref.add(vector3d);
        this.d_up = new Vector3d(vector3d2);
        this.d_resetPos = new Point3d(this.d_pos);
        this.d_resetRef = new Point3d(this.d_ref);
        this.d_resetUpVector = new Vector3d(this.d_up);
        this.d_resetViewVector = new Vector3d(vector3d);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_orthographic = true;
        this.d_orthoScale = 10.0;
        this.d_wireframe = bl;
        this.d_flatShading = bl2;
        this.d_dirty = true;
    }

    public Camera(Point3d point3d, Point3d point3d2, Vector3d vector3d, boolean bl, boolean bl2) {
        this.d_ref = new Point3d(point3d2);
        this.d_pos = new Point3d(point3d);
        this.d_up = new Vector3d(vector3d);
        this.d_resetPos = new Point3d(point3d);
        this.d_resetRef = new Point3d(point3d2);
        this.d_resetUpVector = new Vector3d(vector3d);
        this.d_resetViewVector = new Vector3d();
        this.d_resetViewVector.sub(point3d, point3d2);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_orthographic = false;
        this.d_orthoScale = 0.0;
        this.d_wireframe = bl;
        this.d_flatShading = bl2;
        this.d_dirty = true;
    }

    public void resetRotation() {
        Vector3d vector3d = new Vector3d(this.d_pos);
        this.d_up.set(0.0, 0.0, 1.0);
        this.d_ref.set(0.0, 1.0, 0.0);
        this.d_pos.set(0.0, 0.0, 0.0);
        this.d_ref.add(vector3d);
        this.d_pos.add(vector3d);
        this.d_dirty = true;
    }

    public boolean isOrthographic() {
        return this.d_orthographic;
    }

    public void setOrthographic(boolean bl) {
        if (this.d_orthographic != bl) {
            this.d_orthographic = bl;
            this.d_dirty = true;
        }
    }

    public boolean isWireframe() {
        return this.d_wireframe;
    }

    public void setWireframe(boolean bl) {
        if (this.d_wireframe != bl) {
            this.d_wireframe = bl;
            this.d_dirty = true;
        }
    }

    public boolean isShadingFlat() {
        return this.d_flatShading;
    }

    public void setShadingFlat(boolean bl) {
        if (this.d_flatShading != bl) {
            this.d_flatShading = bl;
            this.d_dirty = true;
        }
    }

    public double getOrthoScale() {
        return this.d_orthoScale;
    }

    public void setOrthoScale(double d) {
        if (this.d_orthoScale != d) {
            this.d_orthoScale = d;
            this.d_dirty = true;
        }
    }

    public Vector3d getResetViewVector() {
        return this.d_resetViewVector;
    }

    public void setResetViewVector(Vector3d vector3d) {
        if (!vector3d.equals(this.d_resetViewVector)) {
            this.d_resetViewVector.set(vector3d);
            this.d_dirty = true;
        }
    }

    public Vector3d getResetUpVector() {
        return this.d_resetUpVector;
    }

    public void setResetUpVector(Vector3d vector3d) {
        if (!vector3d.equals(this.d_resetUpVector)) {
            this.d_resetUpVector.set(vector3d);
            this.d_dirty = true;
        }
    }

    public void orbit(double d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.sub(this.d_pos, this.d_ref);
        vector3d3.set(this.d_up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        double d2 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d5.x, vector3d5.y, vector3d5.z, d2);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Vector3d vector3d6 = new Vector3d();
        vector3d6.sub(this.d_pos, this.d_ref);
        matrix3d.transform(vector3d6);
        this.d_pos.add(this.d_ref, vector3d6);
        matrix3d.transform(this.d_up);
        this.d_dirty = true;
    }

    public void orbit(double d, double d2, double d3, double d4) {
        Vector3d vector3d = new Vector3d(d2, d3, d4);
        this.orbit(d, vector3d);
    }

    public void rotate(double d, double d2, double d3, double d4) {
        double d5 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(d2, d3, d4, d5);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.d_ref, this.d_pos);
        matrix3d.transform(vector3d);
        this.d_ref.add(this.d_pos, vector3d);
        matrix3d.transform(this.d_up);
        this.d_dirty = true;
    }

    public void zoom(double d) {
        if (this.d_orthographic) {
            this.d_orthoScale /= d;
        } else {
            this.d_fov /= d;
        }
        this.d_dirty = true;
    }

    public void translateWorld(Vector3d vector3d, boolean bl) {
        this.d_pos.add(vector3d);
        if (bl) {
            this.d_ref.add(vector3d);
        }
        this.d_dirty = true;
    }

    public void translateEye(Vector3d vector3d, boolean bl) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.sub(this.d_pos, this.d_ref);
        vector3d3.set(this.d_up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        this.d_pos.add(vector3d5);
        if (bl) {
            this.d_ref.add(vector3d5);
        }
        this.d_dirty = true;
    }

    public void translateEye(double d, double d2, double d3, boolean bl) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.translateEye(vector3d, bl);
    }

    public void setPosition(Point3d point3d) {
        if (!point3d.equals(this.d_pos) || !point3d.equals(this.d_resetPos)) {
            this.d_pos.set(point3d);
            this.d_resetPos.set(point3d);
            this.d_dirty = true;
        }
    }

    public void setPosition(double d, double d2, double d3) {
        Point3d point3d = new Point3d(d, d2, d3);
        this.setPosition(point3d);
    }

    public void setReference(Point3d point3d) {
        if (!point3d.equals(this.d_ref) || !point3d.equals(this.d_resetRef)) {
            this.d_ref.set(point3d);
            this.d_resetRef.set(point3d);
            this.d_dirty = true;
        }
    }

    public void setReference(double d, double d2, double d3) {
        Point3d point3d = new Point3d(d, d2, d3);
        this.setReference(point3d);
    }

    public void setUpVector(Vector3d vector3d) {
        if (!vector3d.equals(this.d_up) || !vector3d.equals(this.d_resetUpVector)) {
            this.d_up.set(vector3d);
            this.d_resetUpVector.set(vector3d);
            this.d_dirty = true;
        }
    }

    public void setUpVector(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.setUpVector(vector3d);
    }

    public void setNearClip(double d) {
        if (d != this.d_near) {
            this.d_near = d;
            this.d_dirty = true;
        }
    }

    public void setFarClip(double d) {
        if (d != this.d_far) {
            this.d_far = d;
            this.d_dirty = true;
        }
    }

    public void setFieldOfView(double d) {
        if (d != this.d_fov) {
            this.d_fov = d;
            this.d_dirty = true;
        }
    }

    public Point3d getPosition() {
        return new Point3d(this.d_pos);
    }

    public void getPosition(double[] dArray) {
        dArray[0] = this.d_pos.x;
        dArray[1] = this.d_pos.y;
        dArray[2] = this.d_pos.z;
    }

    public Point3d getReference() {
        return new Point3d(this.d_ref);
    }

    public void getReference(double[] dArray) {
        dArray[0] = this.d_ref.x;
        dArray[1] = this.d_ref.y;
        dArray[2] = this.d_ref.z;
    }

    public Vector3d getViewVector() {
        Vector3d vector3d = new Vector3d(this.d_ref);
        vector3d.sub(this.d_pos);
        return vector3d;
    }

    public Vector3d getUpVector() {
        return new Vector3d(this.d_up);
    }

    public void getUpVector(double[] dArray) {
        dArray[0] = this.d_up.x;
        dArray[1] = this.d_up.y;
        dArray[2] = this.d_up.z;
    }

    public Vector3d getRightVector() {
        Vector3d vector3d = this.getUpVector();
        Vector3d vector3d2 = this.getViewVector();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        return vector3d3;
    }

    public Vector3d getForwardVector() {
        if (this.d_orthographic) {
            return this.d_resetViewVector;
        }
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.d_ref, this.d_pos);
        return vector3d;
    }

    public double getNearClip() {
        return this.d_near;
    }

    public double getFarClip() {
        return this.d_far;
    }

    public double getFieldOfView() {
        return this.d_fov;
    }

    public double getDistance() {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.d_ref, this.d_pos);
        return vector3d.length();
    }

    public double getSubjectSize() {
        if (this.d_orthographic) {
            return this.getOrthoScale() * 2.0;
        }
        return this.d_fov * Math.PI / 180.0 * this.getDistance();
    }

    public Vector4d getViewPlane() {
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Point3d point3d = this.getPosition();
        double d = -point3d.x * vector3d.x - point3d.y * vector3d.y - point3d.z * vector3d.z;
        return new Vector4d(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point3d, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        if (n == 0) {
            vector3d2.normalize(this.getViewVector());
        } else if (n == 2) {
            vector3d2.normalize(this.getUpVector());
        } else {
            vector3d = this.getUpVector();
            Vector3d vector3d3 = this.getViewVector();
            Vector3d vector3d4 = new Vector3d();
            vector3d4.cross(vector3d3, vector3d);
            vector3d2.normalize(vector3d4);
        }
        vector3d = new Vector3d();
        vector3d.sub(point3d, this.getPosition());
        double d = vector3d.dot(vector3d2);
        vector3d2.scale(d);
        return vector3d2;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d vector3d = this.getUpVector();
        vector3d.normalize();
        Vector3d vector3d2 = this.getRightVector();
        vector3d2.normalize();
        Vector3d vector3d3 = this.getViewVector();
        vector3d3.normalize();
        return new Matrix3d(vector3d2.x, vector3d2.y, vector3d2.z, vector3d.x, vector3d.y, vector3d.z, vector3d3.x, vector3d3.y, vector3d3.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d matrix3d = this.getLocalTransformLHR();
        matrix3d.m20 = -matrix3d.m20;
        matrix3d.m21 = -matrix3d.m21;
        matrix3d.m22 = -matrix3d.m22;
        return matrix3d;
    }

    public boolean isDirty() {
        return this.d_dirty;
    }

    public void setDirty(boolean bl) {
        this.d_dirty = bl;
    }

    public Object clone() {
        try {
            Camera camera = (Camera)super.clone();
            camera.d_pos = new Point3d(this.d_pos);
            camera.d_ref = new Point3d(this.d_ref);
            camera.d_up = new Vector3d(this.d_up);
            camera.d_resetViewVector = new Vector3d(this.d_resetViewVector);
            camera.d_resetUpVector = new Vector3d(this.d_resetUpVector);
            camera.d_resetPos = new Point3d(this.d_resetPos);
            camera.d_resetRef = new Point3d(this.d_resetRef);
            camera.d_orthographic = this.d_orthographic;
            camera.d_dirty = true;
            return camera;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return new Camera();
        }
    }
}

