/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.rasterization;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Point3i;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRasterization;

public class Raster3DMerger {
    public static <T> Map<MergedCell, IRasterization<? extends T>> mergeCells(Collection<? extends IRasterization<? extends T>> collection) {
        HashMap<MergedCell, IRasterization<T>> hashMap = new HashMap<MergedCell, IRasterization<T>>();
        for (IRasterization<T> object2 : collection) {
            for (Point3i point3i : object2.getCells()) {
                hashMap.put(new MergedCell(point3i.x, point3i.x, point3i.y, point3i.y, point3i.z, point3i.z), object2);
            }
        }
        Object object3 = Raster3DMerger.mergeCells(hashMap, new PointComp(), new ZRunComp(), new ZRunMerger());
        hashMap = null;
        Map<MergedCell, IRasterization<? extends T>> map = Raster3DMerger.mergeCells(object3, null, new XZRunComp(), new XZRunMerger());
        object3 = null;
        Map<MergedCell, IRasterization<? extends T>> map2 = Raster3DMerger.mergeCells(map, null, null, new XYZRunMerger());
        Object var3_5 = null;
        return map2;
    }

    private static <T> Map<MergedCell, IRasterization<? extends T>> mergeCells(Map<MergedCell, IRasterization<? extends T>> map, Comparator<MergedCell> comparator, Comparator<MergedCell> comparator2, Merger merger) {
        Map<MergedCell, IRasterization<T>> map2;
        if (comparator != null) {
            map2 = new TreeMap<MergedCell, IRasterization<T>>(comparator);
            for (Map.Entry object2 : map.entrySet()) {
                map2.put((MergedCell)object2.getKey(), (IRasterization<T>)object2.getValue());
            }
        } else {
            map2 = map;
        }
        Map.Entry[] entryArray = (Map.Entry[])Array.newInstance(Map.Entry.class, map2.size());
        map2.entrySet().toArray(entryArray);
        TreeMap<MergedCell, IRasterization<T>> treeMap = comparator2 != null ? new TreeMap(comparator2) : new HashMap();
        int n = 0;
        while (n < entryArray.length) {
            int n2;
            MergedCell mergedCell = (MergedCell)entryArray[n].getKey();
            IFragGenerator iFragGenerator = ((IRasterization)entryArray[n].getValue()).getFragGenerator();
            MergedCell mergedCell2 = merger.init(mergedCell);
            for (n2 = n + 1; n2 < entryArray.length; ++n2) {
                MergedCell mergedCell3 = (MergedCell)entryArray[n2].getKey();
                IFragGenerator iFragGenerator2 = ((IRasterization)entryArray[n2].getValue()).getFragGenerator();
                if (!merger.areCellsAdjacent(mergedCell2, mergedCell3) || !iFragGenerator.canMerge(iFragGenerator2)) break;
                mergedCell2 = merger.merge(mergedCell2, mergedCell3);
            }
            treeMap.put(mergedCell2, (IRasterization<T>)entryArray[n].getValue());
            n = n2;
        }
        return treeMap;
    }

    private static class XYZRunMerger
    implements Merger {
        private XYZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell mergedCell, MergedCell mergedCell2) {
            return mergedCell.x1 == mergedCell2.x1 && mergedCell.x2 == mergedCell2.x2 && mergedCell.z1 == mergedCell2.z1 && mergedCell.z2 == mergedCell2.z2 && mergedCell.y2 == mergedCell2.y1 - 1;
        }

        @Override
        public MergedCell init(MergedCell mergedCell) {
            return new MergedCell(mergedCell.x1, mergedCell.x2, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z2);
        }

        @Override
        public MergedCell merge(MergedCell mergedCell, MergedCell mergedCell2) {
            mergedCell.y2 = mergedCell2.y1;
            return mergedCell;
        }
    }

    private static class XZRunMerger
    implements Merger {
        private XZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell mergedCell, MergedCell mergedCell2) {
            return mergedCell.y1 == mergedCell2.y1 && mergedCell.z1 == mergedCell2.z1 && mergedCell.z2 == mergedCell2.z2 && mergedCell.x2 == mergedCell2.x1 - 1;
        }

        @Override
        public MergedCell init(MergedCell mergedCell) {
            return new MergedCell(mergedCell.x1, mergedCell.x1, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z2);
        }

        @Override
        public MergedCell merge(MergedCell mergedCell, MergedCell mergedCell2) {
            mergedCell.x2 = mergedCell2.x1;
            return mergedCell;
        }
    }

    private static class ZRunMerger
    implements Merger {
        private ZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell mergedCell, MergedCell mergedCell2) {
            return mergedCell.x1 == mergedCell2.x1 && mergedCell.y1 == mergedCell2.y1 && mergedCell.z2 == mergedCell2.z1 - 1;
        }

        @Override
        public MergedCell init(MergedCell mergedCell) {
            return new MergedCell(mergedCell.x1, mergedCell.x1, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z1);
        }

        @Override
        public MergedCell merge(MergedCell mergedCell, MergedCell mergedCell2) {
            mergedCell.z2 = mergedCell2.z1;
            return mergedCell;
        }
    }

    private static class XZRunComp
    implements Comparator<MergedCell> {
        private XZRunComp() {
        }

        @Override
        public int compare(MergedCell mergedCell, MergedCell mergedCell2) {
            int n = mergedCell.x1 - mergedCell2.x1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.x2 - mergedCell.x1 + 1;
            int n3 = mergedCell2.x2 - mergedCell2.x1 + 1;
            int n4 = n2 - n3;
            if (n4 != 0) {
                return n4;
            }
            int n5 = mergedCell.z1 - mergedCell2.z1;
            if (n5 != 0) {
                return n5;
            }
            int n6 = mergedCell.z2 - mergedCell.z1 + 1;
            int n7 = mergedCell2.z2 - mergedCell2.z1 + 1;
            int n8 = n6 - n7;
            if (n8 != 0) {
                return n8;
            }
            return mergedCell.y1 - mergedCell2.y1;
        }
    }

    private static class ZRunComp
    implements Comparator<MergedCell> {
        private ZRunComp() {
        }

        @Override
        public int compare(MergedCell mergedCell, MergedCell mergedCell2) {
            int n = mergedCell.y1 - mergedCell2.y1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.z1 - mergedCell2.z1;
            if (n2 != 0) {
                return n2;
            }
            int n3 = mergedCell.z2 - mergedCell.z1 + 1;
            int n4 = mergedCell2.z2 - mergedCell2.z1 + 1;
            int n5 = n3 - n4;
            if (n5 != 0) {
                return n5;
            }
            return mergedCell.x1 - mergedCell2.x1;
        }
    }

    private static class PointComp
    implements Comparator<MergedCell> {
        private PointComp() {
        }

        @Override
        public int compare(MergedCell mergedCell, MergedCell mergedCell2) {
            int n = mergedCell.y1 - mergedCell2.y1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.x1 - mergedCell2.x1;
            if (n2 != 0) {
                return n2;
            }
            return mergedCell.z1 - mergedCell2.z1;
        }
    }

    private static interface Merger {
        public MergedCell init(MergedCell var1);

        public boolean areCellsAdjacent(MergedCell var1, MergedCell var2);

        public MergedCell merge(MergedCell var1, MergedCell var2);
    }

    public static class MergedCell {
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public int z1;
        public int z2;

        public MergedCell(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x1 = n;
            this.x2 = n2;
            this.y1 = n3;
            this.y2 = n4;
            this.z1 = n5;
            this.z2 = n6;
        }
    }
}

