/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.rasterization;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.ConvexPolygon;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Intersections;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Solid3D;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Util;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRaster3D;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3DMerger;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2006_2.thunderheadeng.util.theUtil;

public class Raster3D<T>
implements IRaster3D<T> {
    private static final double EPSILON = 1.0E-9;
    private static final Vector3d XPOS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d YPOS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d ZPOS = new Vector3d(0.0, 0.0, 1.0);
    private final Class<T> d_fragType;
    private ConvexVolume d_rastVolume;
    private double[] d_xDiv;
    private double[] d_yDiv;
    private double[] d_zDiv;
    private final CellList d_cells;
    private IRasterization<? extends T> d_rast;
    static final theUtil.DoubleComparator d_comp = new theUtil.DoubleComparator(){

        @Override
        public int compare(double d, double d2) {
            if (Raster3D.doubleEq(d, d2, 1.0E-9)) {
                return 0;
            }
            return d < d2 ? -1 : 1;
        }
    };

    public Raster3D(Class<T> clazz, double[] dArray, double[] dArray2, double[] dArray3) {
        this(clazz, dArray, dArray2, dArray3, null);
    }

    public Raster3D(Class<T> clazz, double[] dArray, double[] dArray2, double[] dArray3, IRasterization iRasterization) {
        assert (dArray.length > 0 && dArray2.length > 0 && dArray3.length > 0);
        this.d_fragType = clazz;
        this.setRasterization(iRasterization);
        int n = dArray.length * dArray2.length * dArray3.length;
        int n2 = n / 8;
        this.d_cells = new CellList(n2);
        this.setDivisions(dArray, dArray2, dArray3);
    }

    private static double[] getCenters(double[] dArray) {
        double[] dArray2 = new double[dArray.length - 1];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (dArray[i] + dArray[i + 1]) * 0.5;
        }
        return dArray2;
    }

    public void setDivisions(double[] dArray, double[] dArray2, double[] dArray3) {
        this.clear();
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        this.d_xDiv = dArray;
        this.d_yDiv = dArray2;
        this.d_zDiv = dArray3;
        double d = this.d_xDiv[0];
        double d2 = this.d_xDiv[this.d_xDiv.length - 1];
        double d3 = this.d_yDiv[0];
        double d4 = this.d_yDiv[this.d_yDiv.length - 1];
        double d5 = this.d_zDiv[0];
        double d6 = this.d_zDiv[this.d_zDiv.length - 1];
        assert (d <= d2 && d3 <= d4 && d5 <= d6) : "Inside out raster error";
        Point3d point3d = new Point3d(d, d3, d5);
        Point3d point3d2 = new Point3d(d, d3, d6);
        Point3d point3d3 = new Point3d(d, d4, d5);
        Point3d point3d4 = new Point3d(d, d4, d6);
        Point3d point3d5 = new Point3d(d2, d3, d5);
        Point3d point3d6 = new Point3d(d2, d3, d6);
        Point3d point3d7 = new Point3d(d2, d4, d5);
        Point3d point3d8 = new Point3d(d2, d4, d6);
        ConvexPolygon[] convexPolygonArray = new ConvexPolygon[]{new ConvexPolygon(point3d, point3d3, point3d4, point3d2), new ConvexPolygon(point3d5, point3d6, point3d8, point3d7), new ConvexPolygon(point3d, point3d2, point3d6, point3d5), new ConvexPolygon(point3d7, point3d8, point3d4, point3d3), new ConvexPolygon(point3d, point3d5, point3d7, point3d3), new ConvexPolygon(point3d2, point3d4, point3d8, point3d6)};
        this.d_rastVolume = new ConvexVolume(convexPolygonArray);
    }

    public double[] getXDiv() {
        return this.d_xDiv;
    }

    public double[] getYDiv() {
        return this.d_yDiv;
    }

    public double[] getZDiv() {
        return this.d_zDiv;
    }

    @Override
    public void setRasterization(IRasterization<? extends T> iRasterization) {
        if (iRasterization == null) {
            return;
        }
        this.d_rast = iRasterization;
    }

    @Override
    public void clear() {
        this.d_cells.clear();
    }

    @Override
    public T[] getFrags(boolean bl) {
        return this.d_cells.getFrags(bl);
    }

    public T[] getFrags(Collection<? extends IRasterization<? extends T>> collection, boolean bl) {
        return this.d_cells.getFrags(collection, bl);
    }

    @Override
    public void removeRasterization(IRasterization<? extends T> iRasterization) {
        this.d_cells.removeCells(iRasterization);
    }

    private void addCell(Point3i point3i) {
        this.d_cells.addCell(point3i, this.d_rast);
    }

    private void markDirty() {
    }

    public void rasterizeTriangle(Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        this.rasterizeConvexPolygon(point3dArray);
    }

    public void rasterizeTriangle(IRasterization<? extends T> iRasterization, Point3d ... point3dArray) {
        this.setRasterization(iRasterization);
        this.rasterizeTriangle(point3dArray);
    }

    @Override
    public void rasterizeConvexPolygon(IRasterization<? extends T> iRasterization, Point3d ... point3dArray) {
        this.setRasterization(iRasterization);
        this.rasterizeConvexPolygon(point3dArray);
    }

    @Override
    public void rasterizeConvexPolygon(Point3d ... point3dArray) {
        this.markDirty();
        Point3d[] point3dArray2 = this.clipConvexPoly(point3dArray);
        point3dArray2 = Raster3D.deleteAdjacentDuplicates(1.0E-9, point3dArray2);
        if (point3dArray2.length <= 0) {
            return;
        }
        this.rasterizeClippedConvexPoly(point3dArray2);
    }

    private static void addToMinMax(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        if (point3i3.x < point3i.x) {
            point3i.x = point3i3.x;
        }
        if (point3i3.x > point3i2.x) {
            point3i2.x = point3i3.x;
        }
        if (point3i3.y < point3i.y) {
            point3i.y = point3i3.y;
        }
        if (point3i3.y > point3i2.y) {
            point3i2.y = point3i3.y;
        }
        if (point3i3.z < point3i.z) {
            point3i.z = point3i3.z;
        }
        if (point3i3.z > point3i2.z) {
            point3i2.z = point3i3.z;
        }
    }

    private void rasterizeClippedEdges(Point3i point3i, Point3i point3i2, Point3d ... point3dArray) {
        for (int i = 0; i < point3dArray.length; ++i) {
            int n = (i + 1) % point3dArray.length;
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[n];
            Point3i point3i3 = this.getIndex(point3d);
            Point3i point3i4 = this.getIndex(point3d2);
            this.rasterizeLineSeg(point3d, point3d2, point3i3, point3i4);
            Raster3D.addToMinMax(point3i, point3i2, point3i3);
            Raster3D.addToMinMax(point3i, point3i2, point3i4);
        }
    }

    private void rasterizeClippedConvexPoly(Point3d ... point3dArray) {
        Point3d point3d;
        Point3d point3d2;
        double d;
        double d2;
        int n;
        int n2;
        Point3i point3i = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point3i point3i2 = new Point3i(-2147483647, -2147483647, -2147483647);
        this.rasterizeClippedEdges(point3i, point3i2, point3dArray);
        if (point3dArray.length < 3) {
            return;
        }
        ConvexPolygon convexPolygon = new ConvexPolygon(point3dArray);
        Point3d point3d3 = new Point3d();
        for (n2 = point3i.z; n2 < point3i2.z; ++n2) {
            for (n = point3i.y; n < point3i2.y; ++n) {
                d2 = (this.d_yDiv[n] + this.d_yDiv[n + 1]) * 0.5;
                d = (this.d_zDiv[n2] + this.d_zDiv[n2 + 1]) * 0.5;
                point3d2 = new Point3d(this.d_xDiv[0], d2, d);
                point3d = new Point3d(this.d_xDiv[this.d_xDiv.length - 1], d2, d);
                if (!Intersections.lineSegPolyIntersection(point3d3, point3d2, point3d, XPOS, convexPolygon.d_plane, convexPolygon.d_points)) continue;
                this.addCell(new Point3i(Raster3D.getClampedBoundIndex(this.d_xDiv, point3d3.x), n, n2));
            }
        }
        for (n2 = point3i.z; n2 < point3i2.z; ++n2) {
            for (n = point3i.x; n < point3i2.x; ++n) {
                d2 = (this.d_xDiv[n] + this.d_xDiv[n + 1]) * 0.5;
                d = (this.d_zDiv[n2] + this.d_zDiv[n2 + 1]) * 0.5;
                point3d2 = new Point3d(d2, this.d_yDiv[0], d);
                point3d = new Point3d(d2, this.d_yDiv[this.d_yDiv.length - 1], d);
                if (!Intersections.lineSegPolyIntersection(point3d3, point3d2, point3d, YPOS, convexPolygon.d_plane, convexPolygon.d_points)) continue;
                this.addCell(new Point3i(n, Raster3D.getClampedBoundIndex(this.d_yDiv, point3d3.y), n2));
            }
        }
        for (n2 = point3i.y; n2 < point3i2.y; ++n2) {
            for (n = point3i.x; n < point3i2.x; ++n) {
                d2 = (this.d_xDiv[n] + this.d_xDiv[n + 1]) * 0.5;
                d = (this.d_yDiv[n2] + this.d_yDiv[n2 + 1]) * 0.5;
                point3d2 = new Point3d(d2, d, this.d_zDiv[0]);
                point3d = new Point3d(d2, d, this.d_zDiv[this.d_zDiv.length - 1]);
                if (!Intersections.lineSegPolyIntersection(point3d3, point3d2, point3d, ZPOS, convexPolygon.d_plane, convexPolygon.d_points)) continue;
                this.addCell(new Point3i(n, n2, Raster3D.getClampedBoundIndex(this.d_zDiv, point3d3.z)));
            }
        }
    }

    private void rasterizeLineSeg(Point3d ... point3dArray) {
        this.rasterizeLineSeg(point3dArray[0], point3dArray[1], this.getIndex(point3dArray[0]), this.getIndex(point3dArray[1]));
    }

    private void rasterizeLineSeg(Point3d point3d, Point3d point3d2, Point3i point3i, Point3i point3i2) {
        int n = Math.abs(point3i2.x - point3i.x);
        int n2 = Math.abs(point3i2.y - point3i.y);
        int n3 = Math.abs(point3i2.z - point3i.z);
        int n4 = point3i.x;
        int n5 = point3i.y;
        int n6 = point3i.z;
        if (n2 == 0 && n3 == 0) {
            int n7 = Math.min(point3i.x, point3i2.x);
            int n8 = Math.max(point3i.x, point3i2.x);
            for (n4 = n7; n4 <= n8; ++n4) {
                this.addCell(new Point3i(n4, n5, n6));
            }
            return;
        }
        if (n == 0 && n3 == 0) {
            int n9 = Math.min(point3i.y, point3i2.y);
            int n10 = Math.max(point3i.y, point3i2.y);
            for (n5 = n9; n5 <= n10; ++n5) {
                this.addCell(new Point3i(n4, n5, n6));
            }
            return;
        }
        if (n == 0 && n2 == 0) {
            int n11 = Math.min(point3i.z, point3i2.z);
            int n12 = Math.max(point3i.z, point3i2.z);
            for (n6 = n11; n6 <= n12; ++n6) {
                this.addCell(new Point3i(n4, n5, n6));
            }
            return;
        }
        MarchTester3D marchTester3D = new MarchTester3D(point3d, point3d2, this.d_xDiv, this.d_yDiv, this.d_zDiv);
        int n13 = point3d2.x >= point3d.x ? 1 : -1;
        int n14 = point3d2.y >= point3d.y ? 1 : -1;
        int n15 = point3d2.z >= point3d.z ? 1 : -1;
        while (true) {
            boolean bl;
            this.addCell(new Point3i(n4, n5, n6));
            boolean bl2 = n4 == point3i2.x;
            boolean bl3 = n5 == point3i2.y;
            boolean bl4 = bl = n6 == point3i2.z;
            if (bl2 && bl3 && bl) break;
            int n16 = n4 + n13;
            int n17 = n5 + n14;
            int n18 = n6 + n15;
            marchTester3D.test(!bl2, !bl3, !bl, n4, n5, n6, n16, n17, n18);
            if (marchTester3D.marchX()) {
                n4 = n16;
            }
            if (marchTester3D.marchY()) {
                n5 = n17;
            }
            if (!marchTester3D.marchZ()) continue;
            n6 = n18;
        }
    }

    public void rasterizeSolid(IRasterization<? extends T> iRasterization, IRasterization<? extends T>[] iRasterizationArray, Point3d[][] point3dArray) {
        int n;
        int n2;
        List<RayFaceIntersection> list;
        double d;
        double d2;
        int n3;
        int n4;
        int n5;
        Point3d[] point3dArray2;
        long l = System.nanoTime();
        ArrayList<Point3d[]> arrayList = new ArrayList<Point3d[]>(point3dArray.length);
        ArrayList<IRasterization<? extends T>> arrayList2 = new ArrayList<IRasterization<? extends T>>(point3dArray.length);
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = Raster3D.deleteAdjacentDuplicates(1.0E-9, point3dArray[i]);
            if (point3dArray[i].length < 3) continue;
            arrayList.add(point3dArray[i]);
            arrayList2.add(iRasterizationArray[i]);
        }
        Point3i point3i = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point3i point3i2 = new Point3i(-2147483647, -2147483647, -2147483647);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.setRasterization((IRasterization)arrayList2.get(i));
            point3dArray2 = this.clipConvexPoly((Point3d[])arrayList.get(i));
            for (n5 = 0; n5 < point3dArray2.length; ++n5) {
                this.rasterizeClippedEdges(point3i, point3i2, point3dArray2);
            }
        }
        Solid3D solid3D = new Solid3D(arrayList);
        point3dArray2 = new HashMap(solid3D.getFaces().length);
        for (n5 = 0; n5 < arrayList.size(); ++n5) {
            point3dArray2.put(solid3D.getFaces()[n5], arrayList2.get(n5));
        }
        ArrayList<FillRange> arrayList3 = new ArrayList<FillRange>();
        ArrayList<FillRange> arrayList4 = new ArrayList<FillRange>();
        ArrayList<FillRange> arrayList5 = new ArrayList<FillRange>();
        int[] nArray = new int[arrayList.size()];
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        for (n4 = point3i.z; n4 <= point3i2.z; ++n4) {
            for (n3 = point3i.y; n3 <= point3i2.y; ++n3) {
                d2 = (this.d_zDiv[n4] + this.d_zDiv[n4 + 1]) * 0.5;
                d = (this.d_yDiv[n3] + this.d_yDiv[n3 + 1]) * 0.5;
                point3d.set(this.d_xDiv[0], d, d2);
                point3d2.set(this.d_xDiv[this.d_xDiv.length - 1], d, d2);
                list = Raster3D.getRaySolidIntersections(point3d, XPOS, solid3D);
                if (list.isEmpty()) continue;
                if (list.size() % 2 != 0) {
                    System.err.println("Intersection count not even on x Ray/Solid intersection: " + d + ", " + d2 + "; " + list.size());
                    continue;
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    RayFaceIntersection rayFaceIntersection = list.get(n2);
                    n = Raster3D.getUnclampedBoundIndex(this.d_xDiv, rayFaceIntersection.d_intersection.x, 1.0);
                    if (n >= 0 && n < this.d_xDiv.length - 1) {
                        IRasterization iRasterization2 = (IRasterization)point3dArray2.get(rayFaceIntersection.d_face);
                        this.setRasterization(iRasterization2);
                        this.addCell(new Point3i(n, n3, n4));
                    }
                    nArray[n2] = n;
                }
                Arrays.sort(nArray, 0, list.size());
                for (n2 = 0; n2 < list.size(); n2 += 2) {
                    int n6 = n2 + 1;
                    if (n2 < 0 && n6 < 0 || n2 > this.d_xDiv.length - 2 && n6 > this.d_xDiv.length - 2) continue;
                    if (n2 < -1) {
                        n2 = -1;
                    }
                    if (n6 > this.d_xDiv.length - 1) {
                        n6 = this.d_xDiv.length - 1;
                    }
                    n = nArray[n2] + 1;
                    int n7 = nArray[n6] - 1;
                    arrayList3.add(new FillRange(n3, n4, n, n7));
                }
            }
        }
        for (n4 = point3i.z; n4 <= point3i2.z; ++n4) {
            for (n3 = point3i.x; n3 <= point3i2.x; ++n3) {
                d2 = (this.d_zDiv[n4] + this.d_zDiv[n4 + 1]) * 0.5;
                d = (this.d_xDiv[n3] + this.d_xDiv[n3 + 1]) * 0.5;
                point3d.set(d, this.d_yDiv[0], d2);
                point3d2.set(d, this.d_yDiv[this.d_yDiv.length - 1], d2);
                list = Raster3D.getRaySolidIntersections(point3d, YPOS, solid3D);
                if (list.isEmpty()) continue;
                if (list.size() % 2 != 0) {
                    System.err.println("Intersection count not even on y Ray/Solid intersection: " + d + ", " + d2 + "; " + list.size());
                    continue;
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    RayFaceIntersection rayFaceIntersection = list.get(n2);
                    n = Raster3D.getUnclampedBoundIndex(this.d_yDiv, rayFaceIntersection.d_intersection.y, 1.0);
                    if (n >= 0 && n < this.d_yDiv.length - 1) {
                        IRasterization iRasterization3 = (IRasterization)point3dArray2.get(rayFaceIntersection.d_face);
                        this.setRasterization(iRasterization3);
                        this.addCell(new Point3i(n3, n, n4));
                    }
                    nArray[n2] = n;
                }
                Arrays.sort(nArray, 0, list.size());
                for (n2 = 0; n2 < list.size(); n2 += 2) {
                    int n8 = n2 + 1;
                    if (n2 < 0 && n8 < 0 || n2 > this.d_yDiv.length - 2 && n8 > this.d_yDiv.length - 2) continue;
                    if (n2 < -1) {
                        n2 = -1;
                    }
                    if (n8 > this.d_yDiv.length - 1) {
                        n8 = this.d_yDiv.length - 1;
                    }
                    n = nArray[n2] + 1;
                    int n9 = nArray[n8] - 1;
                    arrayList4.add(new FillRange(n3, n4, n, n9));
                }
            }
        }
        for (n4 = point3i.y; n4 <= point3i2.y; ++n4) {
            for (n3 = point3i.x; n3 <= point3i2.x; ++n3) {
                d2 = (this.d_yDiv[n4] + this.d_yDiv[n4 + 1]) * 0.5;
                d = (this.d_xDiv[n3] + this.d_xDiv[n3 + 1]) * 0.5;
                point3d.set(d, d2, this.d_zDiv[0]);
                point3d2.set(d, d2, this.d_zDiv[this.d_zDiv.length - 1]);
                list = Raster3D.getRaySolidIntersections(point3d, ZPOS, solid3D);
                if (list.isEmpty()) continue;
                if (list.size() % 2 != 0) {
                    System.err.println("Intersection count not even on z Ray/Solid intersection: " + d + ", " + d2 + "; " + list.size());
                    continue;
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    RayFaceIntersection rayFaceIntersection = list.get(n2);
                    n = Raster3D.getUnclampedBoundIndex(this.d_zDiv, rayFaceIntersection.d_intersection.z, 1.0);
                    if (n >= 0 && n < this.d_zDiv.length - 1) {
                        IRasterization iRasterization4 = (IRasterization)point3dArray2.get(rayFaceIntersection.d_face);
                        this.setRasterization(iRasterization4);
                        this.addCell(new Point3i(n3, n4, n));
                    }
                    nArray[n2] = n;
                }
                Arrays.sort(nArray, 0, list.size());
                for (n2 = 0; n2 < list.size(); n2 += 2) {
                    int n10 = n2 + 1;
                    if (n2 < 0 && n10 < 0 || n2 > this.d_zDiv.length - 2 && n10 > this.d_zDiv.length - 2) continue;
                    if (n2 < -1) {
                        n2 = -1;
                    }
                    if (n10 > this.d_zDiv.length - 1) {
                        n10 = this.d_zDiv.length - 1;
                    }
                    n = nArray[n2] + 1;
                    int n11 = nArray[n10] - 1;
                    arrayList5.add(new FillRange(n3, n4, n, n11));
                }
            }
        }
        for (FillRange fillRange : arrayList3) {
            for (int i = fillRange.localZBegin; i <= fillRange.localZEnd; ++i) {
                this.addCell(new Point3i(i, fillRange.localx, fillRange.localy));
            }
        }
        for (FillRange fillRange : arrayList4) {
            for (int i = fillRange.localZBegin; i <= fillRange.localZEnd; ++i) {
                this.addCell(new Point3i(fillRange.localx, i, fillRange.localy));
            }
        }
        for (FillRange fillRange : arrayList5) {
            for (int i = fillRange.localZBegin; i <= fillRange.localZEnd; ++i) {
                this.addCell(new Point3i(fillRange.localx, fillRange.localy, i));
            }
        }
        long l2 = System.nanoTime();
        System.out.println((double)(l2 - l) / 1.0E9);
    }

    private Point3d[] clipConvexPoly(Point3d ... point3dArray) {
        return Raster3D.clipPolyToVolume(this.d_rastVolume, point3dArray);
    }

    private static Point3d[] clipPolyToVolume(ConvexVolume convexVolume, Point3d ... point3dArray) {
        Point3d[] point3dArray2 = point3dArray;
        for (ConvexPolygon convexPolygon : convexVolume.d_polys) {
            point3dArray2 = Raster3D.clipPolyToPoly(convexPolygon, point3dArray2);
        }
        return point3dArray2;
    }

    private static Point3d[] clipPolyToPoly(ConvexPolygon convexPolygon, Point3d ... point3dArray) {
        LinkedList<Point3d> linkedList = new LinkedList<Point3d>();
        for (int i = 0; i < point3dArray.length; ++i) {
            boolean bl;
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % point3dArray.length];
            boolean bl2 = Util.distance(point3d, convexPolygon.d_plane) >= 0.0;
            boolean bl3 = bl = Util.distance(point3d2, convexPolygon.d_plane) >= 0.0;
            if (bl2) {
                linkedList.add(point3d);
            }
            if (bl2 && bl || !bl2 && !bl) continue;
            Point3d point3d3 = new Point3d();
            Intersections.linePlaneIntersection(point3d3, point3d, point3d2, convexPolygon.d_plane);
            linkedList.add(point3d3);
        }
        return linkedList.toArray(new Point3d[linkedList.size()]);
    }

    private static <T> T[] deleteAdjacentDuplicates(Class<T> clazz, T ... TArray) {
        if (TArray.length <= 1) {
            return TArray;
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            T t2 = TArray[(i + 1) % TArray.length];
            if (t.equals(t2)) continue;
            arrayList.add(t);
        }
        if (arrayList.size() != TArray.length) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, arrayList.size());
            return arrayList.toArray(objectArray);
        }
        return TArray;
    }

    private static Point3d[] deleteAdjacentDuplicates(double d, Point3d ... point3dArray) {
        if (point3dArray.length <= 1) {
            return point3dArray;
        }
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(point3dArray.length);
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % point3dArray.length];
            if (point3d.epsilonEquals(point3d2, d)) continue;
            arrayList.add(point3d);
        }
        if (arrayList.size() != point3dArray.length) {
            return arrayList.toArray(new Point3d[arrayList.size()]);
        }
        return point3dArray;
    }

    private Point3i getIndex(Point3d point3d) {
        return new Point3i(Raster3D.getClampedBoundIndex(this.d_xDiv, point3d.x), Raster3D.getClampedBoundIndex(this.d_yDiv, point3d.y), Raster3D.getClampedBoundIndex(this.d_zDiv, point3d.z));
    }

    private static boolean doubleEq(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    private static boolean doubleEq(Double d, Double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    private static int getUnclampedBoundIndex(double[] dArray, double d, double d2) {
        int n = theUtil.binarySearch(dArray, d, d_comp);
        if (n < 0) {
            n = -(n + 1);
            --n;
        } else if (d2 < 0.0) {
            --n;
        }
        return n;
    }

    private static int getClampedBoundIndex(double[] dArray, double d) {
        int n = Raster3D.getUnclampedBoundIndex(dArray, d, 1.0);
        if (n < 0) {
            n = 0;
        } else if (n > dArray.length - 2) {
            n = dArray.length - 2;
        }
        return n;
    }

    private static List<RayFaceIntersection> getRaySolidIntersections(Point3d point3d, Vector3d vector3d, Solid3D solid3D) {
        RayFaceIntersection rayFaceIntersection;
        Solid3D.Edge[] edgeArray;
        HashSet<Solid3D.Face> hashSet = Sets.fromArrayHS(solid3D.getFaces());
        ArrayList<RayFaceIntersection> arrayList = new ArrayList<RayFaceIntersection>(solid3D.getFaces().length);
        Solid3D.Vertex[] vertexArray = solid3D.getVerts();
        for (int i = 0; i < vertexArray.length; ++i) {
            edgeArray = vertexArray[i];
            if (!Intersections.linePointIntersect(point3d, vector3d, edgeArray.getLocation(), 1.0E-9)) continue;
            RayFaceIntersection rayFaceIntersection2 = new RayFaceIntersection();
            rayFaceIntersection2.d_intersection = edgeArray.getLocation();
            rayFaceIntersection2.d_face = edgeArray.getFaces().iterator().next();
            arrayList.add(rayFaceIntersection2);
            if (!Raster3D.allFacesInSameAlignmentWithRay(vector3d, edgeArray.getFaces())) {
                arrayList.add(rayFaceIntersection2);
            }
            for (Solid3D.Face object : edgeArray.getFaces()) {
                hashSet.remove(object);
            }
        }
        HashSet<Solid3D.Face> hashSet2 = new HashSet<Solid3D.Face>(hashSet);
        edgeArray = solid3D.getEdges();
        for (int i = 0; i < edgeArray.length; ++i) {
            Point3d point3d2;
            Solid3D.Edge edge = edgeArray[i];
            if (!hashSet.contains(edge.getFace1()) || !hashSet.contains(edge.getFace2()) || (point3d2 = Intersections.lineLineSegIntersection(point3d, vector3d, edge.getP1().getLocation(), edge.getP2().getLocation(), edge.getDirection(), 1.0E-9)) == null) continue;
            rayFaceIntersection = new RayFaceIntersection();
            rayFaceIntersection.d_intersection = (Point3d)point3d2.clone();
            rayFaceIntersection.d_face = edge.getFace1();
            arrayList.add(rayFaceIntersection);
            if (!Raster3D.allFacesInSameAlignmentWithRay(vector3d, Arrays.asList(edge.getFace1(), edge.getFace2()))) {
                arrayList.add(rayFaceIntersection);
            }
            hashSet2.remove(edge.getFace1());
            hashSet2.remove(edge.getFace2());
        }
        Point3d point3d2 = new Point3d();
        for (Solid3D.Face face : hashSet2) {
            if (!Intersections.linePolyIntersection(point3d2, point3d, vector3d, face.getPlaneEquation(), face.getPoints())) continue;
            rayFaceIntersection = new RayFaceIntersection();
            rayFaceIntersection.d_intersection = (Point3d)point3d2.clone();
            rayFaceIntersection.d_face = face;
            arrayList.add(rayFaceIntersection);
        }
        return arrayList;
    }

    private static boolean allFacesInSameAlignmentWithRay(Vector3d vector3d, Collection<Solid3D.Face> collection) {
        int n = 0;
        int n2 = 0;
        for (Solid3D.Face face : collection) {
            double d = vector3d.dot(face.getNormal());
            if (Raster3D.doubleEq(d, 0.0, 1.0E-9)) continue;
            if (d < 0.0) {
                if (n > 0) {
                    return false;
                }
                ++n2;
                continue;
            }
            if (n2 > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static class Cell<T2> {
        private IRasterization<? extends T2> d_currentRast;
        private Set<IRasterization<? extends T2>> d_potentialRasts = new HashSet<IRasterization<? extends T2>>();

        public Cell(Point3i point3i, IRasterization<? extends T2> iRasterization) {
            this.d_currentRast = iRasterization;
            this.d_currentRast.addCell(point3i);
        }

        public IRasterization<? extends T2> getCurrentRast() {
            return this.d_currentRast;
        }

        public void addRast(Point3i point3i, IRasterization<? extends T2> iRasterization) {
            if (this.d_currentRast != iRasterization && !this.d_potentialRasts.contains(iRasterization)) {
                int n;
                int n2 = iRasterization.getFragGenerator().getCellPriority();
                if (n2 >= (n = this.d_currentRast.getFragGenerator().getCellPriority())) {
                    iRasterization.addPotentialCell(point3i);
                    this.d_potentialRasts.add(iRasterization);
                } else {
                    this.d_currentRast.removeCell(point3i);
                    this.d_currentRast.addPotentialCell(point3i);
                    this.d_potentialRasts.add(this.d_currentRast);
                    iRasterization.addCell(point3i);
                    this.d_currentRast = iRasterization;
                }
            }
        }

        public boolean removeCurrentRast(Point3i point3i) {
            if (this.d_potentialRasts.isEmpty()) {
                return true;
            }
            IRasterization<T2> iRasterization = this.getHighestPriorityRast();
            assert (iRasterization != null);
            iRasterization.removePotentialCell(point3i);
            iRasterization.addCell(point3i);
            this.d_potentialRasts.remove(iRasterization);
            this.d_currentRast = iRasterization;
            return false;
        }

        public void removePotentialRast(IRasterization<? extends T2> iRasterization) {
            assert (iRasterization != this.d_currentRast && this.d_currentRast != null);
            this.d_potentialRasts.remove(iRasterization);
        }

        private IRasterization<? extends T2> getHighestPriorityRast() {
            assert (this.d_potentialRasts.size() > 0);
            IRasterization<T2> iRasterization = null;
            int n = Integer.MAX_VALUE;
            for (IRasterization<T2> iRasterization2 : this.d_potentialRasts) {
                int n2 = iRasterization2.getFragGenerator().getCellPriority();
                if (n2 == 0) {
                    return iRasterization2;
                }
                if (n2 >= n) continue;
                n = n2;
                iRasterization = iRasterization2;
            }
            return iRasterization;
        }
    }

    private class CellList {
        private final Map<Point3i, Cell<T>> d_cells;

        public CellList(int n) {
            this.d_cells = new HashMap(n);
        }

        public T[] getFrags(Collection<? extends IRasterization<? extends T>> collection, boolean bl) {
            if (bl) {
                Map map = Raster3DMerger.mergeCells(collection);
                Object[] objectArray = (Object[])Array.newInstance(Raster3D.this.d_fragType, map.size());
                int n = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Raster3DMerger.MergedCell mergedCell = entry.getKey();
                    objectArray[n++] = entry.getValue().getFragGenerator().generateFrag(Raster3D.this.d_xDiv[mergedCell.x1], Raster3D.this.d_yDiv[mergedCell.y1], Raster3D.this.d_zDiv[mergedCell.z1], Raster3D.this.d_xDiv[mergedCell.x2 + 1], Raster3D.this.d_yDiv[mergedCell.y2 + 1], Raster3D.this.d_zDiv[mergedCell.z2 + 1]);
                }
                return objectArray;
            }
            int n = 0;
            for (IRasterization iRasterization : collection) {
                n += iRasterization.getCells().size();
            }
            Object[] objectArray = (Object[])Array.newInstance(Raster3D.this.d_fragType, n);
            int n2 = 0;
            for (IRasterization iRasterization : collection) {
                for (Point3i point3i : iRasterization.getCells()) {
                    objectArray[n2++] = iRasterization.getFragGenerator().generateFrag(Raster3D.this.d_xDiv[point3i.x], Raster3D.this.d_yDiv[point3i.y], Raster3D.this.d_zDiv[point3i.z], Raster3D.this.d_xDiv[point3i.x + 1], Raster3D.this.d_yDiv[point3i.y + 1], Raster3D.this.d_zDiv[point3i.z + 1]);
                }
            }
            return objectArray;
        }

        public T[] getFrags(boolean bl) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : this.d_cells.entrySet()) {
                hashSet.add(entry.getValue().getCurrentRast());
            }
            return this.getFrags(hashSet, bl);
        }

        public void addCell(Point3i point3i, IRasterization<? extends T> iRasterization) {
            Cell<Object> cell = this.d_cells.get(point3i);
            if (cell == null) {
                cell = new Cell(point3i, iRasterization);
                this.d_cells.put(point3i, cell);
            } else {
                cell.addRast(point3i, iRasterization);
            }
        }

        public void removeCells(IRasterization<? extends T> iRasterization) {
            Cell cell;
            for (Point3i point3i : iRasterization.getCells()) {
                cell = this.d_cells.get(point3i);
                boolean bl = cell.removeCurrentRast(point3i);
                if (!bl) continue;
                this.d_cells.remove(point3i);
            }
            for (Point3i point3i : iRasterization.getPotentialCells()) {
                cell = this.d_cells.get(point3i);
                cell.removePotentialRast(iRasterization);
            }
            iRasterization.clear();
        }

        public void clear() {
            this.d_cells.clear();
        }
    }

    private static class RayFaceIntersection {
        public Point3d d_intersection;
        public Solid3D.Face d_face;

        private RayFaceIntersection() {
        }
    }

    private static class ConvexVolume {
        public final ConvexPolygon[] d_polys;

        public ConvexVolume(ConvexPolygon[] convexPolygonArray) {
            this.d_polys = convexPolygonArray;
        }
    }

    private static class Line2d {
        public final Vector3d d_eq;

        public Line2d(double d, double d2, double d3, double d4) {
            Vector2d vector2d = new Vector2d(d3 - d, d4 - d2);
            vector2d.normalize();
            double d5 = vector2d.y;
            double d6 = -vector2d.x;
            double d7 = -(d5 * d + d6 * d2);
            this.d_eq = new Vector3d(d5, d6, d7);
        }

        public double distToPoint(Point2d point2d) {
            return Math.abs(point2d.x * this.d_eq.x + point2d.y * this.d_eq.y + this.d_eq.z);
        }
    }

    private static class MarchTester2D {
        public boolean march1;
        public boolean march2;
        private final Line2d d_line;
        private final double[] d_div1;
        private final double[] d_div2;

        public MarchTester2D(Line2d line2d, double[] dArray, double[] dArray2) {
            this.d_div1 = dArray;
            this.d_div2 = dArray2;
            this.d_line = line2d;
        }

        public void test(boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
            double d;
            if (!bl && !bl2) {
                this.march1 = false;
                this.march2 = false;
                return;
            }
            if (!bl) {
                this.march1 = false;
                this.march2 = true;
                return;
            }
            if (!bl2) {
                this.march1 = true;
                this.march2 = false;
                return;
            }
            this.march1 = true;
            this.march2 = false;
            Point2d point2d = this.getCellCenter(n3, n2);
            Point2d point2d2 = this.getCellCenter(n3, n4);
            double d2 = this.d_line.distToPoint(point2d);
            if (Raster3D.doubleEq(d2, d = this.d_line.distToPoint(point2d2), 1.0E-9) ? n2 > n4 : d2 < d) {
                return;
            }
            this.march2 = true;
            Point2d point2d3 = this.getCellCenter(n, n4);
            double d3 = this.d_line.distToPoint(point2d3);
            if (Raster3D.doubleEq(d, d3, 1.0E-9) ? n3 > n : d < d3) {
                return;
            }
            this.march1 = false;
        }

        private Point2d getCellCenter(int n, int n2) {
            return new Point2d((this.d_div1[n] + this.d_div1[n + 1]) * 0.5, (this.d_div2[n2] + this.d_div2[n2 + 1]) * 0.5);
        }
    }

    private static class MarchTester3D {
        private final MarchTester2D d_marchTesterXY;
        private final MarchTester2D d_marchTesterXZ;
        private final MarchTester2D d_marchTesterYZ;

        public MarchTester3D(Point3d point3d, Point3d point3d2, double[] dArray, double[] dArray2, double[] dArray3) {
            Line2d line2d = new Line2d(point3d.x, point3d.y, point3d2.x, point3d2.y);
            Line2d line2d2 = new Line2d(point3d.x, point3d.z, point3d2.x, point3d2.z);
            Line2d line2d3 = new Line2d(point3d.y, point3d.z, point3d2.y, point3d2.z);
            this.d_marchTesterXY = new MarchTester2D(line2d, dArray, dArray2);
            this.d_marchTesterXZ = new MarchTester2D(line2d2, dArray, dArray3);
            this.d_marchTesterYZ = new MarchTester2D(line2d3, dArray2, dArray3);
        }

        public void test(boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6) {
            this.d_marchTesterXY.test(bl, bl2, n, n2, n4, n5);
            this.d_marchTesterXZ.test(bl, bl3, n, n3, n4, n6);
            this.d_marchTesterYZ.test(bl2, bl3, n2, n3, n5, n6);
        }

        public boolean marchX() {
            return this.d_marchTesterXY.march1 && this.d_marchTesterXZ.march1;
        }

        public boolean marchY() {
            return this.d_marchTesterXY.march2 && this.d_marchTesterYZ.march1;
        }

        public boolean marchZ() {
            return this.d_marchTesterXZ.march2 && this.d_marchTesterYZ.march2;
        }
    }

    private class FillRange {
        public int localx;
        public int localy;
        public int localZBegin;
        public int localZEnd;

        public FillRange(int n, int n2, int n3, int n4) {
            this.localx = n;
            this.localy = n2;
            this.localZBegin = n3;
            this.localZEnd = n4;
        }
    }
}

