/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LERandomAccessFile
implements DataInput,
DataOutput {
    private static final String EmbeddedCopyright = "Copyright 1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected RandomAccessFile r;
    byte[] w;

    public LERandomAccessFile(String string, String string2) throws IOException {
        this.r = new RandomAccessFile(string, string2);
        this.w = new byte[8];
    }

    public LERandomAccessFile(File file, String string) throws IOException {
        this.r = new RandomAccessFile(file, string);
        this.w = new byte[8];
    }

    @Override
    public final short readShort() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.r.readFully(this.w, 0, 2);
        return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.r.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        this.r.readFully(this.w, 0, 8);
        return (long)this.w[7] << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.r.write(this.w, 0, 2);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.r.write(this.w, 0, 2);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.w[2] = (byte)(n >> 16);
        this.w[3] = (byte)(n >> 24);
        this.r.write(this.w, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.w[0] = (byte)l;
        this.w[1] = (byte)(l >> 8);
        this.w[2] = (byte)(l >> 16);
        this.w[3] = (byte)(l >> 24);
        this.w[4] = (byte)(l >> 32);
        this.w[5] = (byte)(l >> 40);
        this.w[6] = (byte)(l >> 48);
        this.w[7] = (byte)(l >> 56);
        this.r.write(this.w, 0, 8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.r.getFD();
    }

    public final long getFilePointer() throws IOException {
        return this.r.getFilePointer();
    }

    public final long length() throws IOException {
        return this.r.length();
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.r.read(byArray, n, n2);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.r.read(byArray);
    }

    public final int read() throws IOException {
        return this.r.read();
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.r.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.r.readFully(byArray, n, n2);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.r.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.r.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.r.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.r.readUnsignedByte();
    }

    @Override
    public final String readLine() throws IOException {
        return this.r.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.r.readUTF();
    }

    public final void seek(long l) throws IOException {
        this.r.seek(l);
    }

    @Override
    public final synchronized void write(int n) throws IOException {
        this.r.write(n);
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.r.write(byArray, n, n2);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.r.writeBoolean(bl);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.r.writeByte(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        this.r.writeBytes(string);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        this.r.writeUTF(string);
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.r.write(byArray, 0, byArray.length);
    }

    public final void close() throws IOException {
        this.r.close();
    }
}

