/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import pyrosim.legacy_2006_2.thunderheadeng.gui.guiField;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class guiIntField
extends guiField {
    private static final long serialVersionUID = -2018094539797374486L;
    private int d_value;
    private boolean d_modified;
    private IntValueRange d_range;

    public guiIntField() {
        this(0);
    }

    public guiIntField(IntValueRange intValueRange) {
        this((Integer)intValueRange.clampValue(intValueRange.getMinValue()), intValueRange);
    }

    public guiIntField(int n) {
        this(n, null);
    }

    public guiIntField(int n, IntValueRange intValueRange) {
        this.init();
        this.d_range = intValueRange == null ? IntValueRange.createUncheckedRange() : intValueRange;
        this.setValue(n);
    }

    private void init() {
        this.d_value = 0;
        this.d_modified = false;
        this.setHorizontalAlignment(2);
    }

    public void setValueRange(IntValueRange intValueRange) {
        this.d_range = intValueRange;
        this.setValue(this.d_range.clampValue(this.d_value));
    }

    public void setValue(int n) {
        if (!this.d_range.checkValue(n)) {
            String string = "Value out of range in guiIntField.setValue()";
            throw new IllegalArgumentException(string);
        }
        super.setText(Integer.toString(n));
        this.d_value = n;
    }

    @Override
    public void setText(String string) {
        int n = Integer.parseInt(string);
        this.setValue(n);
    }

    public int getValue() {
        return this.d_value;
    }

    public boolean validateData(boolean bl, boolean bl2) {
        int n;
        if (!this.shouldValidate()) {
            return true;
        }
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            if (bl2) {
                String string = "The entry \"" + this.getText() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(string);
                this.requestFocusHack();
            }
            return false;
        }
        if (!this.d_range.checkValue(n)) {
            if (bl2) {
                String string = "The entry \"" + this.getText() + "\" is out of range.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(string);
                this.requestFocusHack();
            }
            return false;
        }
        if (bl) {
            if (n != this.d_value) {
                this.setValue(n);
                this.d_modified = true;
            }
        } else {
            this.d_value = n;
        }
        return true;
    }

    @Override
    public boolean validateData() {
        return this.validateData(true, true);
    }

    @Override
    public boolean isModified() {
        if (this.d_modified) {
            return true;
        }
        try {
            int n = Integer.parseInt(this.getText());
            return n != this.d_value;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }
}

