/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import pyrosim.legacy_2006_2.thunderheadeng.io.CompositeFileFilter;
import pyrosim.legacy_2006_2.thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.gui.Application;

public class guiFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 5774484316535891628L;
    private boolean d_mustExist = true;
    private boolean d_promptOverwrite = true;
    private boolean d_allowPathCreate = true;
    private final CompositeFileFilter d_allSupportedTypesFilter = new CompositeFileFilter("All Supported Types");

    public guiFileChooser() {
        String string = Application.getApp().getWorkingDir();
        if (string != null) {
            this.setCurrentDirectory(new File(string));
        }
    }

    public guiFileChooser(FileFilter fileFilter) {
        this();
        this.addChoosableFileFilter(fileFilter);
    }

    public guiFileChooser(String string, String string2) {
        this();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension(string);
        exampleFileFilter.setDescription(string2);
        this.addChoosableFileFilter(exampleFileFilter);
    }

    @Override
    public void setCurrentDirectory(File file) {
        super.setCurrentDirectory(file);
        if (file != null) {
            Application.getApp().setWorkingDir(file.getPath());
        }
    }

    public void setMustExist(boolean bl) {
        this.d_mustExist = bl;
    }

    public boolean getMustExist() {
        return this.d_mustExist;
    }

    public void setPromptOverwrite(boolean bl) {
        this.d_promptOverwrite = bl;
    }

    public boolean getPromptOverwrite() {
        return this.d_promptOverwrite;
    }

    public void setAllowPathCreate(boolean bl) {
        this.d_allowPathCreate = bl;
    }

    public boolean getAllowPathCreate() {
        return this.d_allowPathCreate;
    }

    public String getFilename() {
        try {
            return this.getSelectedFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.getSelectedFile().getAbsolutePath();
        }
    }

    @Override
    public int showDialog(Component component, String string) {
        int n = super.showDialog(component, string);
        if (n == 0) {
            Application.getApp().setWorkingDir(this.getSelectedFile().getParent());
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void approveSelection() {
        block11: {
            File file;
            block10: {
                file = this.getSelectedFile();
                if (this.getDialogType() != 1) break block10;
                if ((file = this.addExtension(file)).exists()) {
                    int n;
                    if (!file.canWrite()) {
                        JOptionPane.showMessageDialog(this, "File is read-only. Please choose another file name.", "Read-only", 0);
                        return;
                    }
                    if (this.d_promptOverwrite && (n = JOptionPane.showOptionDialog(this, "File already exists. Overwrite?", "Overwrite existing file?", 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    break block11;
                } else {
                    if (!guiFileChooser.isFilenameLegal(file.getAbsolutePath())) {
                        JOptionPane.showMessageDialog(this, "Cannot create the specified path because it contains any of the following illegal characters:\n: * ? \" < > |", "Illegal characters", 1);
                        return;
                    }
                    File file2 = file.getParentFile();
                    if (!file2.exists()) {
                        if (!this.getAllowPathCreate()) {
                            JOptionPane.showMessageDialog(this, "The specified path does not exist. Please create the directory or save to an existing directory.", "Directory does not exist", 1);
                            return;
                        }
                        if (!file2.mkdir()) {
                            JOptionPane.showMessageDialog(this, "Could not create the specified path. Please enter a valid pathname where you have write access.", "Could not create path", 1);
                            return;
                        }
                    }
                }
                break block11;
            }
            if (this.getDialogType() == 0) {
                file = this.addExtension(file);
                if (this.d_mustExist && !file.exists()) {
                    JOptionPane.showMessageDialog(this, "Can't find selected file. Please select an existing file.", "Can't find file", 1);
                    return;
                }
            }
        }
        super.approveSelection();
    }

    private File addExtension(File file) {
        String[] stringArray;
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof ExampleFileFilter && (stringArray = ((ExampleFileFilter)fileFilter).getFilters()) != null && stringArray.length > 0) {
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
            if (string.indexOf(46) < 0) {
                file = new File(string + "." + stringArray[0]);
                this.setSelectedFile(file);
            }
        }
        return file;
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        super.addChoosableFileFilter(fileFilter);
        if (this.d_allSupportedTypesFilter != null && fileFilter != this.getAcceptAllFileFilter()) {
            this.d_allSupportedTypesFilter.addFilter(fileFilter);
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        boolean bl = super.removeChoosableFileFilter(fileFilter);
        if (this.d_allSupportedTypesFilter != null) {
            this.d_allSupportedTypesFilter.removeFilter(fileFilter);
        }
        return bl;
    }

    public CompositeFileFilter getAllSupportedTypesFilter() {
        return this.d_allSupportedTypesFilter;
    }

    public void setAllSupportedTypesFilterEnabled(boolean bl) {
        if (bl) {
            super.addChoosableFileFilter(this.d_allSupportedTypesFilter);
            this.setFileFilter(this.d_allSupportedTypesFilter);
        } else {
            super.removeChoosableFileFilter(this.d_allSupportedTypesFilter);
        }
    }

    public void selectFirstAppropriateFilter(File file) {
        if (file != null) {
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (!fileFilterArray[i].accept(file)) continue;
                this.setFileFilter(fileFilterArray[i]);
                return;
            }
        }
    }

    @Override
    public int showOpenDialog(Component component) throws HeadlessException {
        this.selectFirstAppropriateFilter(this.getSelectedFile());
        return super.showOpenDialog(component);
    }

    @Override
    public int showSaveDialog(Component component) throws HeadlessException {
        this.selectFirstAppropriateFilter(this.getSelectedFile());
        int n = super.showSaveDialog(component);
        if (n == 0) {
            File file = super.getSelectedFile();
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof ExampleFileFilter) {
                ExampleFileFilter exampleFileFilter = (ExampleFileFilter)fileFilter;
                this.setSelectedFile(exampleFileFilter.appendExtension(file));
            }
        }
        return n;
    }

    public static boolean isFilenameLegal(String string) {
        return string.lastIndexOf(58) < 2 && string.indexOf(42) < 0 && string.indexOf(63) < 0 && string.indexOf(34) < 0 && string.indexOf(60) < 0 && string.indexOf(62) < 0 && string.indexOf(124) < 0;
    }
}

