/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2006_2.thunderheadeng.gui.DlgListener;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2006_2.thunderheadeng.gui.guiPanel;

public class guiDialog
extends JDialog
implements Modifiable {
    private static final long serialVersionUID = -9121253956771601671L;
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int RESET = 4;
    public static final int CANCEL = 8;
    public static final int CLOSE = 16;
    public static final int HELP = 32;
    private JPanel d_btnPanel;
    private guiPanel d_dialogPane;
    protected int d_status;
    private Window d_owner = null;
    private Vector d_listeners = new Vector();
    private JButton d_helpButton;
    private JButton d_okButton;
    private JButton d_cancelButton;
    private JButton d_closeButton;
    private JButton d_resetButton;
    private JButton d_applyButton;
    protected CancelListener d_cancelListener;
    private boolean d_minimumSizeEnabled = false;
    private boolean d_disposeAfterModal = true;

    public guiDialog(JFrame jFrame) {
        this(jFrame, "", 0);
    }

    public guiDialog(JFrame jFrame, String string) {
        this(jFrame, string, 0);
    }

    public guiDialog(JDialog jDialog, String string, int n) {
        super((Dialog)jDialog, string);
        this.init(jDialog, n);
    }

    public guiDialog(JFrame jFrame, String string, int n) {
        super((Frame)jFrame, string);
        this.init(jFrame, n);
    }

    private void init(Window window, int n) {
        JButton jButton;
        this.d_owner = window;
        this.setResizable(false);
        this.setModal(true);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.d_btnPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        jPanel.add(this.d_btnPanel);
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.d_cancelListener = new CancelListener();
        this.getRootPane().registerKeyboardAction(this.d_cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(this.d_cancelListener);
        if ((n & 2) != 0) {
            this.d_applyButton = new ApplyBtn(this);
            jButton = this.d_applyButton;
            this.addButton(jButton);
            this.getRootPane().setDefaultButton(jButton);
        }
        if ((n & 1) != 0) {
            this.d_okButton = new OkBtn(this);
            jButton = this.d_okButton;
            this.addButton(jButton);
            this.getRootPane().setDefaultButton(jButton);
        }
        if ((n & 4) != 0) {
            this.d_resetButton = new ResetBtn(this);
            jButton = this.d_resetButton;
            this.addButton(jButton);
        }
        if ((n & 8) != 0) {
            this.d_cancelButton = new CancelBtn(this);
            jButton = this.d_cancelButton;
            this.addButton(jButton);
        }
        if ((n & 0x10) != 0) {
            this.d_closeButton = new CloseBtn(this);
            jButton = this.d_closeButton;
            this.addButton(jButton);
        }
        if ((n & 0x20) != 0) {
            this.d_helpButton = new HelpBtn(this);
            this.addButton(this.d_helpButton);
        }
        this.setSize(0, 0);
    }

    public JButton getButton(int n) {
        switch (n) {
            case 2: {
                return this.d_applyButton;
            }
            case 1: {
                return this.d_okButton;
            }
            case 4: {
                return this.d_resetButton;
            }
            case 8: {
                return this.d_cancelButton;
            }
            case 16: {
                return this.d_closeButton;
            }
            case 32: {
                return this.d_helpButton;
            }
        }
        return null;
    }

    public void setButtons(JComponent[] jComponentArray) {
        this.d_btnPanel.removeAll();
        for (int i = 0; i < jComponentArray.length; ++i) {
            this.addButton(jComponentArray[i]);
        }
    }

    public void addButton(JComponent jComponent) {
        JButton jButton = new JButton("Cancel");
        Dimension dimension = jButton.getPreferredSize();
        if (jComponent.getPreferredSize().getWidth() < (double)dimension.width) {
            jComponent.setPreferredSize(dimension);
        }
        this.d_btnPanel.add(jComponent);
    }

    public guiPanel getDialogPane() {
        return this.d_dialogPane;
    }

    public void setHelpIDString(String string) {
    }

    public void center() {
        Dimension dimension = this.getSize();
        if (this.d_owner == null) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            Point point = new Point(0, 0);
            this.setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
        } else {
            Dimension dimension3 = this.d_owner.getSize();
            Point point = this.d_owner.getLocation();
            int n = point.x + dimension3.width / 2;
            int n2 = point.y + dimension3.height / 2;
            Dimension dimension4 = Toolkit.getDefaultToolkit().getScreenSize();
            int n3 = n + dimension.width / 2 - dimension4.width;
            int n4 = n2 + dimension.height / 2 - dimension4.height;
            int n5 = Math.min(n - dimension.width / 2, n - dimension.width / 2 - n3);
            int n6 = Math.min(n2 - dimension.height / 2, n2 - dimension.height / 2 - n4);
            this.setLocation(Math.max(0, n5), Math.max(0, n6));
        }
    }

    private void beginShowing() {
        this.d_status = 8;
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0 || this.d_minimumSizeEnabled) {
            this.pack();
        }
        if (this.d_minimumSizeEnabled) {
            this.setMinimumSize(this.getPreferredSize());
        }
        if (dimension.width != 0 && dimension.height != 0) {
            this.setSize(dimension);
        }
        this.center();
        this.setVisible(true);
    }

    public boolean doModeless() {
        if (this.isVisible()) {
            return false;
        }
        this.setModal(false);
        this.beginShowing();
        return true;
    }

    public int doModal() {
        this.setModal(true);
        this.beginShowing();
        return this.d_status;
    }

    public void setDisposeAfterModal(boolean bl) {
        this.d_disposeAfterModal = bl;
    }

    public void setMinimumSizeEnabled(boolean bl) {
        if (bl) {
            this.enableEvents(101L);
        } else {
            this.disableEvents(101L);
        }
        this.d_minimumSizeEnabled = bl;
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        this.setSize(dimension);
    }

    public int getStatus() {
        return this.d_status;
    }

    public boolean validateData() {
        return this.d_dialogPane.validateData();
    }

    @Override
    public boolean isModified() {
        return this.d_dialogPane.isModified();
    }

    @Override
    public void setModified(boolean bl) {
        this.d_dialogPane.setModified(bl);
    }

    public void addDlgListener(DlgListener dlgListener) {
        this.d_listeners.add(dlgListener);
    }

    public void removeDlgListener(DlgListener dlgListener) {
        this.d_listeners.remove(dlgListener);
    }

    protected void fireButtonPressed(int n) {
        block8: for (int i = 0; i < this.d_listeners.size(); ++i) {
            DlgListener dlgListener = (DlgListener)this.d_listeners.get(i);
            switch (n) {
                case 1: {
                    dlgListener.okPressed();
                    continue block8;
                }
                case 2: {
                    dlgListener.applyPressed();
                    continue block8;
                }
                case 4: {
                    dlgListener.resetPressed();
                    continue block8;
                }
                case 8: {
                    dlgListener.cancelPressed();
                    continue block8;
                }
                case 16: {
                    dlgListener.closePressed();
                    continue block8;
                }
                case 32: {
                    dlgListener.helpPressed();
                    continue block8;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.d_disposeAfterModal) {
            this.dispose();
        }
    }

    protected void showMessageBox(String string) {
        guiDialog.showInvalidEntryMessage(this, string);
    }

    public static void showInvalidEntryMessage(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Invalid Entry", 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiDialog.this.requestFocus();
            }
        });
    }

    public static class HelpBtn
    extends JButton {
        private static final long serialVersionUID = 208177938893573209L;
        private guiDialog d_dlg;

        public HelpBtn(guiDialog guiDialog2) {
            super("Help");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    d_dlg.fireButtonPressed(32);
                }
            });
        }
    }

    public static class CloseBtn
    extends JButton {
        private static final long serialVersionUID = -5503470940940567407L;
        private guiDialog d_dlg;

        public CloseBtn(guiDialog guiDialog2) {
            super("Close");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((CloseBtn)this).d_dlg.d_status = 16;
                    d_dlg.fireButtonPressed(16);
                    d_dlg.setVisible(false);
                }
            });
        }
    }

    public static class CancelBtn
    extends JButton {
        private static final long serialVersionUID = -2693966101802036331L;
        private guiDialog d_dlg;

        public CancelBtn(guiDialog guiDialog2) {
            super("Cancel");
            this.d_dlg = guiDialog2;
            this.addActionListener(this.d_dlg.d_cancelListener);
        }
    }

    public static class ResetBtn
    extends JButton {
        private static final long serialVersionUID = -1747371388125153307L;
        private guiDialog d_dlg;

        public ResetBtn(guiDialog guiDialog2) {
            super("Reset");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    d_dlg.fireButtonPressed(4);
                }
            });
        }
    }

    public static class ApplyBtn
    extends JButton {
        private static final long serialVersionUID = 8450936287931651030L;
        private guiDialog d_dlg;

        public ApplyBtn(guiDialog guiDialog2) {
            super("Apply");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (d_dlg.validateData()) {
                        ((ApplyBtn)this).d_dlg.d_status = 2;
                        d_dlg.fireButtonPressed(2);
                    }
                }
            });
        }
    }

    public static class OkBtn
    extends JButton {
        private static final long serialVersionUID = -1186375968506063135L;
        private guiDialog d_dlg;

        public OkBtn(guiDialog guiDialog2) {
            super("OK");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (d_dlg.validateData()) {
                        ((OkBtn)this).d_dlg.d_status = 1;
                        d_dlg.fireButtonPressed(1);
                        d_dlg.setVisible(false);
                    }
                }
            });
        }
    }

    private class CancelListener
    extends WindowAdapter
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancel();
        }

        private void cancel() {
            guiDialog.this.d_status = 8;
            guiDialog.this.fireButtonPressed(8);
            guiDialog.this.setVisible(false);
        }
    }
}

