/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class guiComboBox
extends JComboBox
implements Modifiable,
Validateable {
    private static final long serialVersionUID = -2137489260497858960L;
    private ValueRange d_range = IntValueRange.createUncheckedRange();
    private boolean d_modified = false;

    public guiComboBox() {
        this.init(null);
    }

    public guiComboBox(Object[] objectArray) {
        super(objectArray);
        this.init(null);
    }

    public guiComboBox(Vector vector) {
        super(vector);
        this.init(null);
    }

    public guiComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init(null);
    }

    private void init(ValueRange valueRange) {
        this.setControls();
        this.attachModifiedListener();
    }

    public void setRange(ValueRange valueRange) {
        this.d_range = valueRange;
    }

    private void attachModifiedListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                guiComboBox.this.d_modified = true;
            }
        });
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void setItems(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    private void setControls() {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, 24);
    }

    @Override
    public boolean validateData() {
        if (!this.isEnabled() || !this.d_range.checksMax() && !this.d_range.checksMin()) {
            return true;
        }
        int n = 0;
        try {
            n = Integer.parseInt(this.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            String string = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        if (!this.d_range.checkValue(n)) {
            String string = "The entry \"" + this.getSelectedItem().toString() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    protected void showMessageBox(String string) {
        JOptionPane.showMessageDialog(null, string, "Invalid Entry", 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiComboBox.this.requestFocus();
            }
        });
    }
}

