/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainListener;

public abstract class Mediator {
    private static final boolean MERGE_EVENTS = true;
    private boolean d_printDebugStatements = System.getProperty("debug") != null;
    private int d_pauseUpdatesCounter = 0;
    private final Stack<List<IDomainEvent>> d_eventStack = new Stack();
    private final HashSet<IDomainListener> d_listeners;
    private boolean d_listening = true;
    private int d_lastListeningPos = 0;
    private static final Stack<ListenerResponse> s_eventResponses = new Stack();
    private static final DecimalFormat s_timeFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

    public Mediator() {
        this.d_eventStack.push(new ArrayList());
        this.d_listeners = new HashSet();
    }

    public boolean isListening() {
        return this.d_listening;
    }

    public void setDebugPrintingEnabled(boolean bl) {
        this.d_printDebugStatements = bl;
    }

    public void addListener(IDomainListener iDomainListener) {
        this.d_listeners.add(iDomainListener);
    }

    public void removeListener(IDomainListener iDomainListener) {
        this.d_listeners.remove(iDomainListener);
    }

    public Set<IDomainListener> getAllListeners() {
        return new HashSet<IDomainListener>(this.d_listeners);
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent) {
        if (!this.d_listening) {
            return false;
        }
        this.d_eventStack.peek().add(iDomainEvent);
        if (this.d_pauseUpdatesCounter > 0) {
            return false;
        }
        this.fireEvents(new Vector<IDomainEvent>((Collection)this.d_eventStack.peek()));
        return true;
    }

    public void pauseUpdates() {
        this.pauseUpdates(true);
    }

    public void pauseUpdates(boolean bl) {
        ++this.d_pauseUpdatesCounter;
        if (!this.d_listening) {
            return;
        }
        this.d_listening = bl;
        if (this.d_listening) {
            this.d_eventStack.push(new ArrayList());
            this.d_lastListeningPos = this.d_pauseUpdatesCounter;
        }
    }

    public boolean resumeUpdates(IDomainEvent iDomainEvent) {
        this.resumeUpdates(false);
        return this.fireDomainEvent(iDomainEvent);
    }

    public int resumeUpdates() {
        return this.resumeUpdates(true);
    }

    private int resumeUpdates(boolean bl) {
        assert (this.d_pauseUpdatesCounter > 0);
        if (this.d_pauseUpdatesCounter > this.d_lastListeningPos) {
            --this.d_pauseUpdatesCounter;
            if (this.d_pauseUpdatesCounter == this.d_lastListeningPos) {
                this.d_listening = true;
            }
            return 0;
        }
        List<IDomainEvent> list = this.d_eventStack.pop();
        if (bl) {
            List<IDomainEvent> list2 = this.d_eventStack.peek();
            list2.addAll(list);
        }
        --this.d_pauseUpdatesCounter;
        --this.d_lastListeningPos;
        if (this.d_pauseUpdatesCounter > 0) {
            return list.size();
        }
        return this.mergeAndFireEvents();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<IDomainEvent> mergeEvents(List<IDomainEvent> list) {
        IDomainEvent[] iDomainEventArray = list.toArray(new IDomainEvent[list.size()]);
        int n = iDomainEventArray.length - 1;
        while (true) {
            block13: {
                IDomainEvent iDomainEvent;
                int n2;
                IDomainEvent iDomainEvent2;
                block14: {
                    block12: {
                        if (n < 0) break block12;
                        iDomainEvent2 = iDomainEventArray[n];
                        if (iDomainEvent2 == null) break block13;
                        break block14;
                    }
                    ArrayList<IDomainEvent> arrayList = new ArrayList<IDomainEvent>();
                    IDomainEvent[] iDomainEventArray2 = iDomainEventArray;
                    int n3 = iDomainEventArray2.length;
                    n2 = 0;
                    while (true) {
                        if (n2 >= n3) {
                            return arrayList;
                        }
                        iDomainEvent = iDomainEventArray2[n2];
                        if (iDomainEvent != null) {
                            arrayList.add(iDomainEvent);
                        }
                        ++n2;
                    }
                }
                block9: for (n2 = n - 1; n2 >= 0; --n2) {
                    iDomainEvent = iDomainEventArray[n2];
                    if (iDomainEvent == null) continue;
                    IDomainEvent.MergeResult mergeResult = iDomainEvent.merge(iDomainEvent2);
                    switch (mergeResult.Action) {
                        case 0: {
                            iDomainEventArray[n] = null;
                            break;
                        }
                        case 1: {
                            iDomainEventArray[n2] = null;
                            break;
                        }
                        case 3: {
                            iDomainEventArray[n2] = null;
                            iDomainEventArray[n] = null;
                            break;
                        }
                        case 4: {
                            iDomainEventArray[n2] = mergeResult.Replacement;
                            iDomainEventArray[n] = null;
                            break;
                        }
                        case 2: {
                            continue block9;
                        }
                    }
                    if (iDomainEventArray[n] == null) break;
                }
            }
            --n;
        }
    }

    private int mergeAndFireEvents() {
        assert (this.d_pauseUpdatesCounter == 0);
        assert (this.d_eventStack.size() == 1);
        List<IDomainEvent> list = this.d_eventStack.peek();
        if (list.size() == 0) {
            return 0;
        }
        long l = System.nanoTime();
        if (System.getProperty("debug") != null) {
            System.out.println("Merging events");
        }
        List<IDomainEvent> list2 = this.mergeEvents(list);
        if (System.getProperty("debug") != null) {
            long l2 = System.nanoTime();
            double d = (double)(l2 - l) * 1.0E-9;
            System.out.println("Done merging events: " + s_timeFormat.format(d) + " s");
        }
        this.fireEvents(list2);
        return list2.size();
    }

    protected void fireEvents(List<IDomainEvent> list) {
        this.d_eventStack.peek().clear();
        if (list.size() == 0) {
            return;
        }
        this.debugPrintDispatchedEvents(list);
        for (IDomainListener object : this.d_listeners) {
            object.domainChanged(list, this);
        }
        for (IDomainEvent iDomainEvent : list) {
            iDomainEvent.eventDispatched();
        }
    }

    private void debugPrintDispatchedEvents(List<IDomainEvent> list) {
        if (!this.d_printDebugStatements) {
            return;
        }
        String string = "";
        for (IDomainEvent iDomainEvent : list) {
            String string2 = iDomainEvent.toString();
            if (string2.length() <= 0) continue;
            string = string + "->Firing Event " + list.hashCode() + ": " + string2 + "\n";
        }
        if (string.length() != 0) {
            System.out.print(string);
            System.out.flush();
        }
    }

    public static void debugResponseStarted(IDomainListener iDomainListener, List<IDomainEvent> list) {
        if (System.getProperty("debug") == null) {
            return;
        }
        ListenerResponse listenerResponse = new ListenerResponse(iDomainListener, list);
        s_eventResponses.push(listenerResponse);
        listenerResponse.startResponse();
    }

    public static void debugResponseEnded() {
        if (System.getProperty("debug") == null) {
            return;
        }
        assert (!s_eventResponses.isEmpty());
        ListenerResponse listenerResponse = s_eventResponses.pop();
        listenerResponse.endResponse();
    }

    public static void debugPrintEvents(String string, List<IDomainEvent> list) {
        if (System.getProperty("debug") == null) {
            return;
        }
        System.out.println("----" + string + " Responding to event " + list.hashCode() + "...");
        System.out.flush();
    }

    public static void debugPrintElapsedTimeForEvents(String string, List<IDomainEvent> list, double d) {
        if (System.getProperty("debug") == null) {
            return;
        }
        String string2 = s_timeFormat.format(d);
        System.out.println("----" + string + " Response to event " + list.hashCode() + " took " + string2 + " sec.");
        System.out.flush();
    }

    static {
        s_timeFormat.applyPattern("0.0000");
    }

    private static class ListenerResponse {
        protected long d_timeStarted;
        protected final IDomainListener d_listener;
        protected final List<IDomainEvent> d_events;

        public ListenerResponse(IDomainListener iDomainListener, List<IDomainEvent> list) {
            this.d_listener = iDomainListener;
            this.d_events = list;
        }

        public void startResponse() {
            this.d_timeStarted = System.nanoTime();
            Mediator.debugPrintEvents(this.d_listener.getClass().getSimpleName(), this.d_events);
        }

        public void endResponse() {
            long l = System.nanoTime();
            double d = (double)(l - this.d_timeStarted) * 1.0E-9;
            Mediator.debugPrintElapsedTimeForEvents(this.d_listener.getClass().getSimpleName(), this.d_events, d);
        }
    }
}

