/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Util;

public class Solid3D {
    private final Vertex[] d_verts;
    private final Edge[] d_edges;
    private final Face[] d_faces;

    public Solid3D(Point3d[] ... point3dArray) {
        this(Arrays.asList(point3dArray));
    }

    /*
     * WARNING - void declaration
     */
    public Solid3D(Collection<Point3d[]> collection) {
        void var6_14;
        int n;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Point3d[] point3dArray : collection) {
            for (Point3d i : point3dArray) {
                hashSet.add(i);
            }
        }
        this.d_verts = new Vertex[hashSet.size()];
        HashMap hashMap = new HashMap();
        int n2 = 0;
        for (Point3d point3d : hashSet) {
            hashMap.put(point3d, n2);
            this.d_verts[n2++] = new Vertex(point3d);
        }
        this.d_faces = new Face[collection.size()];
        n2 = 0;
        for (Point3d[] point3dArray : collection) {
            int[] j = new int[point3dArray.length];
            for (int face = 0; face < point3dArray.length; ++face) {
                j[face] = (Integer)hashMap.get(point3dArray[face]);
            }
            this.d_faces[n2++] = new Face(j);
        }
        for (int i = 0; i < this.d_verts.length; ++i) {
            Vertex vertex = this.d_verts[i];
            block6: for (int face = 0; face < this.d_faces.length; ++face) {
                Face j = this.d_faces[face];
                for (n = 0; n < j.d_ixes.length; ++n) {
                    if (j.d_ixes[n] != i) continue;
                    vertex.d_faces.add(j);
                    continue block6;
                }
            }
        }
        HashMap<EdgeKey, Edge> hashMap2 = new HashMap<EdgeKey, Edge>(this.d_verts.length);
        boolean i = false;
        while (var6_14 < this.d_faces.length) {
            Face face = this.d_faces[var6_14];
            for (int j = 0; j < face.d_ixes.length; ++j) {
                int n3;
                n = (j + 1) % face.d_ixes.length;
                int n4 = face.d_ixes[j];
                EdgeKey edgeKey = new EdgeKey(n4, n3 = face.d_ixes[n]);
                Edge edge = (Edge)hashMap2.get(edgeKey);
                if (edge == null) {
                    edge = new Edge(n4, n3);
                    edge.d_face1 = face;
                    hashMap2.put(edgeKey, edge);
                    continue;
                }
                edge.d_face2 = face;
            }
            ++var6_14;
        }
        this.d_edges = hashMap2.values().toArray(new Edge[hashMap2.size()]);
    }

    public Face[] getFaces() {
        return this.d_faces;
    }

    public Vertex[] getVerts() {
        return this.d_verts;
    }

    public Edge[] getEdges() {
        return this.d_edges;
    }

    private static class EdgeKey {
        private final int d_i1;
        private final int d_i2;

        private EdgeKey(int n, int n2) {
            if (n <= n2) {
                this.d_i1 = n;
                this.d_i2 = n2;
            } else {
                this.d_i1 = n2;
                this.d_i2 = n;
            }
        }

        public int hashCode() {
            return this.d_i1 + this.d_i2;
        }

        public boolean equals(Object object) {
            assert (object instanceof EdgeKey);
            EdgeKey edgeKey = (EdgeKey)object;
            return this.d_i1 == edgeKey.d_i1 && this.d_i2 == edgeKey.d_i2;
        }
    }

    public class Edge {
        private final int d_v1;
        private final int d_v2;
        private final Vector3d d_dir;
        private Face d_face1;
        private Face d_face2;

        private Edge(int n, int n2) {
            this.d_v1 = n;
            this.d_v2 = n2;
            this.d_dir = new Vector3d();
            this.d_dir.sub(this.getP2().getLocation(), this.getP1().getLocation());
            this.d_dir.normalize();
        }

        public final Vertex getP1() {
            return Solid3D.this.d_verts[this.d_v1];
        }

        public final Vertex getP2() {
            return Solid3D.this.d_verts[this.d_v2];
        }

        public final Vector3d getDirection() {
            return this.d_dir;
        }

        public final Face getFace1() {
            return this.d_face1;
        }

        public final Face getFace2() {
            return this.d_face2;
        }
    }

    public class Vertex {
        private final Point3d d_loc;
        private final List<Face> d_faces;

        private Vertex(Point3d point3d) {
            this.d_loc = point3d;
            this.d_faces = new ArrayList<Face>(3);
        }

        public Point3d getLocation() {
            return this.d_loc;
        }

        public List<Face> getFaces() {
            return this.d_faces;
        }
    }

    public class Face {
        private final int[] d_ixes;
        private final Vector4d d_planeEq;

        private Face(int ... nArray) {
            assert (nArray.length >= 3);
            this.d_ixes = nArray;
            this.d_planeEq = Util.getPlane(this.getVert(0).getLocation(), this.getVert(1).getLocation(), this.getVert(2).getLocation());
        }

        public final Vertex getVert(int n) {
            return Solid3D.this.d_verts[this.d_ixes[n]];
        }

        public final Vertex[] getVerts() {
            Vertex[] vertexArray = new Vertex[this.d_ixes.length];
            for (int i = 0; i < this.d_ixes.length; ++i) {
                vertexArray[i] = Solid3D.this.d_verts[this.d_ixes[i]];
            }
            return vertexArray;
        }

        public final Point3d[] getPoints() {
            Point3d[] point3dArray = new Point3d[this.d_ixes.length];
            for (int i = 0; i < this.d_ixes.length; ++i) {
                point3dArray[i] = Solid3D.this.d_verts[this.d_ixes[i]].getLocation();
            }
            return point3dArray;
        }

        public final double planeDot(Tuple3d tuple3d) {
            return this.d_planeEq.x * tuple3d.x + this.d_planeEq.y * tuple3d.y + this.d_planeEq.z * tuple3d.z + this.d_planeEq.w;
        }

        public final Vector4d getPlaneEquation() {
            return this.d_planeEq;
        }

        public final Vector3d getNormal() {
            return new Vector3d(this.d_planeEq.x, this.d_planeEq.y, this.d_planeEq.z);
        }
    }
}

