/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import pyrosim.legacy_2006_2.thunderheadeng.geometry.Util;

public class Intersections {
    public static final double DBL_EPSILON = 1.0E-9;
    public static final Vector3d VEC_ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Point3d PNT_ZERO = new Point3d(0.0, 0.0, 0.0);

    public static int compare(double d, double d2) {
        if (Math.abs(d - d2) < 1.0E-9) {
            return 0;
        }
        return Double.compare(d, d2);
    }

    public static boolean linePlaneIntersection(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector4d vector4d) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d3, point3d2);
        return Intersections.linePlaneIntersection(point3d, point3d2, vector3d, vector4d);
    }

    public static boolean linePlaneIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, Vector4d vector4d) {
        double d = vector3d.x * vector4d.x + vector3d.y * vector4d.y + vector3d.z * vector4d.z;
        if (Intersections.compare(d, 0.0) == 0) {
            return false;
        }
        double d2 = -(vector4d.w + vector4d.x * point3d2.x + vector4d.y * point3d2.y + vector4d.z * point3d2.z) / d;
        point3d.x = point3d2.x + vector3d.x * d2;
        point3d.y = point3d2.y + vector3d.y * d2;
        point3d.z = point3d2.z + vector3d.z * d2;
        return true;
    }

    public static boolean lineSegPolyIntersection(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Vector4d vector4d, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        double d = Util.distance(point3d2, vector4d);
        double d2 = Util.distance(point3d3, vector4d);
        int n = Intersections.compare(d, 0.0);
        int n2 = Intersections.compare(d2, 0.0);
        if (n >= 0 && n2 >= 0 || n < 0 && n2 < 0) {
            return false;
        }
        return Intersections.linePolyIntersection(point3d, point3d2, vector3d, vector4d, point3dArray);
    }

    public static boolean linePolyIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, Vector4d vector4d, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        if (!Intersections.linePlaneIntersection(point3d, point3d2, vector3d, vector4d)) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        vector3d2.sub(point3d, point3dArray[0]);
        vector3d3.sub(point3dArray[1], point3dArray[0]);
        vector3d5.cross(vector3d3, vector3d2);
        if (Intersections.isVecZero(vector3d5)) {
            return false;
        }
        for (int i = 1; i < point3dArray.length; ++i) {
            int n = (i + 1) % point3dArray.length;
            vector3d2.sub(point3d, point3dArray[i]);
            vector3d3.sub(point3dArray[n], point3dArray[i]);
            vector3d4.cross(vector3d3, vector3d2);
            if (Intersections.isVecZero(vector3d4) || Intersections.compare(vector3d5.dot(vector3d4), 0.0) < 0) {
                return false;
            }
            vector3d5.set(vector3d4);
        }
        return true;
    }

    private static boolean isVecZero(Vector3d vector3d) {
        return vector3d.epsilonEquals(VEC_ZERO, 1.0E-9);
    }

    public static boolean linePointIntersect(Point3d point3d, Vector3d vector3d, Point3d point3d2, double d) {
        Point3d point3d3 = Intersections.linePointProximity(point3d, vector3d, point3d2);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d2, point3d3);
        double d2 = vector3d2.lengthSquared();
        return d2 <= d;
    }

    public static Point3d linePointProximity(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d2, point3d);
        double d = vector3d2.dot(vector3d3);
        vector3d2.scale(d);
        Point3d point3d3 = new Point3d();
        point3d3.add(point3d, vector3d2);
        return point3d3;
    }

    public static Point3d lineLineSegIntersection(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d2, double d) {
        Point3d point3d4 = new Point3d();
        Point3d point3d5 = new Point3d();
        boolean bl = Intersections.lineLineSegProximity(point3d4, point3d5, point3d, vector3d, point3d2, point3d3, vector3d2);
        if (!bl) {
            return null;
        }
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d5, point3d4);
        double d2 = vector3d3.lengthSquared();
        if (d2 <= d) {
            return point3d4;
        }
        return null;
    }

    public static boolean lineLineSegProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Point3d point3d5, Vector3d vector3d2) {
        if (!Intersections.lineLineProximity(point3d, point3d2, point3d3, vector3d, point3d4, vector3d2)) {
            return false;
        }
        if (point3d2 != null) {
            Intersections.constrainPoint(point3d2, point3d4, point3d5, vector3d2);
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Vector3d vector3d2) {
        Vector4d vector4d;
        Vector3d vector3d3;
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d, vector3d2);
        if (Intersections.compare(vector3d4.dot(vector3d4), 0.0) == 0) {
            return false;
        }
        if (point3d != null) {
            vector3d3 = new Vector3d();
            vector3d3.cross(vector3d4, vector3d2);
            vector3d3.normalize();
            vector4d = Util.getPlane(vector3d3, point3d4);
            Intersections.linePlaneIntersection(point3d, point3d3, vector3d, vector4d);
        }
        if (point3d2 != null) {
            vector3d3 = new Vector3d();
            vector3d3.cross(vector3d4, vector3d);
            vector3d3.normalize();
            vector4d = Util.getPlane(vector3d3, point3d3);
            Intersections.linePlaneIntersection(point3d2, point3d4, vector3d2, vector4d);
        }
        return true;
    }

    private static double dot(Vector3d vector3d, Point3d point3d) {
        return vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z;
    }

    public static void constrainPoint(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d) {
        double d = Intersections.dot(vector3d, point3d);
        double d2 = Intersections.dot(vector3d, point3d2);
        double d3 = Intersections.dot(vector3d, point3d3);
        if (d < d2 && d < d3) {
            if (d2 - d < d3 - d) {
                point3d.set(point3d2);
            } else {
                point3d.set(point3d3);
            }
        } else if (d > d2 && d > d3) {
            if (d - d3 < d - d2) {
                point3d.set(point3d3);
            } else {
                point3d.set(point3d2);
            }
        }
    }
}

