/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class TextureInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String d_texname;
    private transient BufferedImage d_texdata;
    private double d_width;
    private double d_height;
    public static final int ORIGIN_DIRSCAN = 0;
    public static final int ORIGIN_DBREF = 1;
    public static final int ORIGIN_USER = 2;
    private int d_origin;

    public TextureInfo(String string, BufferedImage bufferedImage, int n) {
        this(string, bufferedImage, 1.0, 1.0, n);
    }

    public TextureInfo(String string, BufferedImage bufferedImage, double d, double d2, int n) {
        this.d_texname = string;
        this.d_texdata = bufferedImage;
        this.d_width = d;
        this.d_height = d2;
        this.d_origin = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.d_texname);
        objectOutputStream.writeDouble(this.d_width);
        objectOutputStream.writeDouble(this.d_height);
        objectOutputStream.writeInt(this.d_origin);
        ImageIO.write((RenderedImage)this.d_texdata, "jpg", objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_texname = (String)objectInputStream.readObject();
        this.d_width = objectInputStream.readDouble();
        this.d_height = objectInputStream.readDouble();
        this.d_origin = objectInputStream.readInt();
        this.d_texdata = ImageIO.read(objectInputStream);
    }

    public String getFileName() {
        return this.d_texname;
    }

    public BufferedImage getImage() {
        return this.d_texdata;
    }

    public double getWidth() {
        return this.d_width;
    }

    public double getHeight() {
        return this.d_height;
    }

    public void setWidth(double d) {
        this.d_width = d;
    }

    public void setHeight(double d) {
        this.d_height = d;
    }

    public int getOrigin() {
        return this.d_origin;
    }

    public int hashCode() {
        return this.d_texname.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[[TextureInfo]");
        stringBuffer.append(this.d_texname + ":");
        stringBuffer.append(this.d_origin + ":");
        stringBuffer.append(this.d_width + ":");
        stringBuffer.append(this.d_height + "]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TextureInfo && object != null) {
            TextureInfo textureInfo = (TextureInfo)object;
            return textureInfo.d_texname.equals(this.d_texname) && textureInfo.d_height == this.d_height && textureInfo.d_width == this.d_width && textureInfo.d_origin == this.d_origin;
        }
        return false;
    }
}

