/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.legacy.v17.TextureInfo;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.Image;

public class TextureDB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TEX_DIR_NAME = "textures";
    private Map<String, TextureInfo> d_texmap = new HashMap<String, TextureInfo>();
    private Map<String, Image> d_nativeImageMap = new HashMap<String, Image>();

    public TextureDB(File file) {
        File file2 = new File(file, TEX_DIR_NAME);
        if (!file2.isDirectory()) {
            if (file2.exists()) {
                file2.delete();
            }
            file2.mkdir();
        }
        this.refresh(file);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_texmap = new HashMap<String, TextureInfo>();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            TextureInfo textureInfo = (TextureInfo)objectInputStream.readObject();
            this.put(textureInfo.getFileName(), textureInfo);
        }
    }

    public Set<String> keys() {
        return this.d_texmap.keySet();
    }

    public TextureInfo get(String string) {
        return this.d_texmap.get(string);
    }

    public boolean put(String string, TextureInfo textureInfo) {
        TextureInfo textureInfo2 = this.d_texmap.get(string);
        if (textureInfo2 != null && textureInfo2.getOrigin() > textureInfo.getOrigin()) {
            return false;
        }
        if (textureInfo.getImage() != null) {
            this.d_texmap.put(string, textureInfo);
        }
        return true;
    }

    public boolean containsKey(String string) {
        return this.d_texmap.containsKey(string);
    }

    public void refresh(File file) {
        this.loadDefaults(file);
    }

    public Runnable loader(final File file) {
        return new Runnable(){

            @Override
            public void run() {
                TextureDB.this.loadDefaults(file);
            }
        };
    }

    public void copyIn(File file, File file2) throws IOException {
        File file3 = new File(file, TEX_DIR_NAME);
        File file4 = new File(file3, file2.getName());
        BufferedImage bufferedImage = ImageIO.read(file2);
        BufferedImage bufferedImage2 = TextureDB.makeSafe(bufferedImage);
        ImageIO.write((RenderedImage)bufferedImage2, "jpg", file4);
        TextureInfo textureInfo = new TextureInfo(file4.getName(), bufferedImage2, 0);
        this.put(textureInfo.getFileName(), textureInfo);
    }

    public void loadDefaults(File file) {
        File file2 = new File(file, TEX_DIR_NAME);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith("jpg");
            }
        };
        List<File> list = IOUtil.listFiles(file2, filenameFilter);
        for (int i = 0; i < list.size(); ++i) {
            try {
                TextureInfo textureInfo = this.createFromFile(list.get(i), 0);
                this.put(textureInfo.getFileName(), textureInfo);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static BufferedImage makeSafe(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private TextureInfo createFromFile(File file, int n) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        BufferedImage bufferedImage2 = TextureDB.makeSafe(bufferedImage);
        return new TextureInfo(file.getName(), bufferedImage2, n);
    }
}

