/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Color;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class Quad
implements Serializable {
    static final long serialVersionUID = 1L;
    private Point3D[] d_points;
    private Color d_color;

    public Quad(double[] dArray) {
        if (dArray.length != 12) {
            throw new IllegalArgumentException("This Quad construction requires 12 coordinates (p0.x, p0.y, p0.z, p1.x, ..., p3.z).");
        }
        this.init(new Point3D[]{new Point3D(dArray[0], dArray[1], dArray[2]), new Point3D(dArray[3], dArray[4], dArray[5]), new Point3D(dArray[6], dArray[7], dArray[8]), new Point3D(dArray[9], dArray[10], dArray[11])});
    }

    public Quad(Point3D point3D, Point3D point3D2, Point3D point3D3, Point3D point3D4) {
        this.init(new Point3D[]{point3D, point3D2, point3D3, point3D4});
    }

    public Quad(Point3D[] point3DArray) {
        this.init(point3DArray);
    }

    private void init(Point3D[] point3DArray) {
        if (point3DArray.length != 4) {
            throw new IllegalArgumentException("Quad must have 4 points.");
        }
        this.d_points = point3DArray;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)object;
        Point3D point3D = this.getPoint(0);
        for (n = 0; n < 4 && !point3D.equals(quad.getPoint(n)); ++n) {
        }
        if (n >= 4) {
            return false;
        }
        int n2 = n;
        for (n = 1; n < 4; ++n) {
            if (this.getPoint(n).equals(quad.getPoint((n + n2) % 4))) continue;
            return false;
        }
        return true;
    }

    public Vector3d getNormal() {
        Point3D point3D = this.getPoint(0);
        Point3D point3D2 = this.getPoint(1);
        Point3D point3D3 = this.getPoint(2);
        Point3d point3d = new Point3d(point3D.x, point3D.y, point3D.z);
        Point3d point3d2 = new Point3d(point3D2.x, point3D2.y, point3D2.z);
        Point3d point3d3 = new Point3d(point3D3.x, point3D3.y, point3D3.z);
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d2, point3d);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d3, point3d);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        return vector3d3;
    }

    public boolean isParallelZ() {
        return this.getPoint((int)0).z == this.getPoint((int)1).z && this.getPoint((int)0).z == this.getPoint((int)2).z && this.getPoint((int)0).z == this.getPoint((int)3).z;
    }

    public boolean isParallelX() {
        return this.getPoint((int)0).x == this.getPoint((int)1).x && this.getPoint((int)0).x == this.getPoint((int)2).x && this.getPoint((int)0).x == this.getPoint((int)3).x;
    }

    public boolean isParallelY() {
        return this.getPoint((int)0).y == this.getPoint((int)1).y && this.getPoint((int)0).y == this.getPoint((int)2).y && this.getPoint((int)0).y == this.getPoint((int)3).y;
    }

    public Point3D getPoint(int n) {
        return this.d_points[n];
    }

    public void setPoint(Point3D point3D, int n) {
        this.d_points[n] = point3D;
    }

    public void translate(double d, double d2, double d3) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += d;
            this.d_points[i].y += d2;
            this.d_points[i].z += d3;
        }
    }

    public void flipNormal() {
        Point3D point3D = this.d_points[1];
        this.d_points[1] = this.d_points[3];
        this.d_points[3] = point3D;
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
    }

    public Prism extrudeAlongNormal(double d) {
        double d2 = d * 0.5;
        double d3 = this.d_points[0].x;
        double d4 = this.d_points[2].x;
        double d5 = this.d_points[0].y;
        double d6 = this.d_points[2].y;
        double d7 = this.d_points[0].z;
        double d8 = this.d_points[2].z;
        if (this.isParallelX()) {
            d3 -= d2;
            d4 += d2;
        } else if (this.isParallelY()) {
            d5 -= d2;
            d6 += d2;
        } else if (this.isParallelZ()) {
            d7 -= d2;
            d8 += d2;
        }
        return new Prism(d3, d4, d5, d6, d7, d8);
    }

    public Object clone() {
        Point3D[] point3DArray = new Point3D[]{new Point3D(this.d_points[0].x, this.d_points[0].y, this.d_points[0].z), new Point3D(this.d_points[1].x, this.d_points[1].y, this.d_points[1].z), new Point3D(this.d_points[2].x, this.d_points[2].y, this.d_points[2].z), new Point3D(this.d_points[3].x, this.d_points[3].y, this.d_points[3].z)};
        Quad quad = new Quad(point3DArray);
        quad.setColor(this.d_color);
        return quad;
    }
}

